/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Cluster creation operation.
 */
@JsonFlatten
public class ClusterCreateParameters {
    /**
     * VM size.
     * The size of the virtual machines in the cluster. All nodes in a cluster
     * have the same VM size. For information about available VM sizes for
     * clusters using images from the Virtual Machines Marketplace see Sizes
     * for Virtual Machines (Linux). Batch AI service supports all Azure VM
     * sizes except STANDARD_A0 and those with premium storage (STANDARD_GS,
     * STANDARD_DS, and STANDARD_DSV2 series).
     */
    @JsonProperty(value = "properties.vmSize", required = true)
    private String vmSize;

    /**
     * VM priority.
     * VM priority. Allowed values are: dedicated (default) and lowpriority.
     * Possible values include: 'dedicated', 'lowpriority'.
     */
    @JsonProperty(value = "properties.vmPriority")
    private VmPriority vmPriority;

    /**
     * Scale settings.
     * Scale settings for the cluster. Batch AI service supports manual and
     * auto scale clusters.
     */
    @JsonProperty(value = "properties.scaleSettings")
    private ScaleSettings scaleSettings;

    /**
     * VM configuration.
     * OS image configuration for cluster nodes. All nodes in a cluster have
     * the same OS image.
     */
    @JsonProperty(value = "properties.virtualMachineConfiguration")
    private VirtualMachineConfiguration virtualMachineConfiguration;

    /**
     * Node setup.
     * Setup to be performed on each compute node in the cluster.
     */
    @JsonProperty(value = "properties.nodeSetup")
    private NodeSetup nodeSetup;

    /**
     * User account settings.
     * Settings for an administrator user account that will be created on each
     * compute node in the cluster.
     */
    @JsonProperty(value = "properties.userAccountSettings", required = true)
    private UserAccountSettings userAccountSettings;

    /**
     * Subnet.
     * Existing virtual network subnet to put the cluster nodes in. Note, if a
     * File Server mount configured in node setup, the File Server's subnet
     * will be used automatically.
     */
    @JsonProperty(value = "properties.subnet")
    private ResourceId subnet;

    /**
     * Get the size of the virtual machines in the cluster. All nodes in a cluster have the same VM size. For information about available VM sizes for clusters using images from the Virtual Machines Marketplace see Sizes for Virtual Machines (Linux). Batch AI service supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
     *
     * @return the vmSize value
     */
    public String vmSize() {
        return this.vmSize;
    }

    /**
     * Set the size of the virtual machines in the cluster. All nodes in a cluster have the same VM size. For information about available VM sizes for clusters using images from the Virtual Machines Marketplace see Sizes for Virtual Machines (Linux). Batch AI service supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
     *
     * @param vmSize the vmSize value to set
     * @return the ClusterCreateParameters object itself.
     */
    public ClusterCreateParameters withVmSize(String vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    /**
     * Get vM priority. Allowed values are: dedicated (default) and lowpriority. Possible values include: 'dedicated', 'lowpriority'.
     *
     * @return the vmPriority value
     */
    public VmPriority vmPriority() {
        return this.vmPriority;
    }

    /**
     * Set vM priority. Allowed values are: dedicated (default) and lowpriority. Possible values include: 'dedicated', 'lowpriority'.
     *
     * @param vmPriority the vmPriority value to set
     * @return the ClusterCreateParameters object itself.
     */
    public ClusterCreateParameters withVmPriority(VmPriority vmPriority) {
        this.vmPriority = vmPriority;
        return this;
    }

    /**
     * Get scale settings for the cluster. Batch AI service supports manual and auto scale clusters.
     *
     * @return the scaleSettings value
     */
    public ScaleSettings scaleSettings() {
        return this.scaleSettings;
    }

    /**
     * Set scale settings for the cluster. Batch AI service supports manual and auto scale clusters.
     *
     * @param scaleSettings the scaleSettings value to set
     * @return the ClusterCreateParameters object itself.
     */
    public ClusterCreateParameters withScaleSettings(ScaleSettings scaleSettings) {
        this.scaleSettings = scaleSettings;
        return this;
    }

    /**
     * Get oS image configuration for cluster nodes. All nodes in a cluster have the same OS image.
     *
     * @return the virtualMachineConfiguration value
     */
    public VirtualMachineConfiguration virtualMachineConfiguration() {
        return this.virtualMachineConfiguration;
    }

    /**
     * Set oS image configuration for cluster nodes. All nodes in a cluster have the same OS image.
     *
     * @param virtualMachineConfiguration the virtualMachineConfiguration value to set
     * @return the ClusterCreateParameters object itself.
     */
    public ClusterCreateParameters withVirtualMachineConfiguration(VirtualMachineConfiguration virtualMachineConfiguration) {
        this.virtualMachineConfiguration = virtualMachineConfiguration;
        return this;
    }

    /**
     * Get setup to be performed on each compute node in the cluster.
     *
     * @return the nodeSetup value
     */
    public NodeSetup nodeSetup() {
        return this.nodeSetup;
    }

    /**
     * Set setup to be performed on each compute node in the cluster.
     *
     * @param nodeSetup the nodeSetup value to set
     * @return the ClusterCreateParameters object itself.
     */
    public ClusterCreateParameters withNodeSetup(NodeSetup nodeSetup) {
        this.nodeSetup = nodeSetup;
        return this;
    }

    /**
     * Get settings for an administrator user account that will be created on each compute node in the cluster.
     *
     * @return the userAccountSettings value
     */
    public UserAccountSettings userAccountSettings() {
        return this.userAccountSettings;
    }

    /**
     * Set settings for an administrator user account that will be created on each compute node in the cluster.
     *
     * @param userAccountSettings the userAccountSettings value to set
     * @return the ClusterCreateParameters object itself.
     */
    public ClusterCreateParameters withUserAccountSettings(UserAccountSettings userAccountSettings) {
        this.userAccountSettings = userAccountSettings;
        return this;
    }

    /**
     * Get existing virtual network subnet to put the cluster nodes in. Note, if a File Server mount configured in node setup, the File Server's subnet will be used automatically.
     *
     * @return the subnet value
     */
    public ResourceId subnet() {
        return this.subnet;
    }

    /**
     * Set existing virtual network subnet to put the cluster nodes in. Note, if a File Server mount configured in node setup, the File Server's subnet will be used automatically.
     *
     * @param subnet the subnet value to set
     * @return the ClusterCreateParameters object itself.
     */
    public ClusterCreateParameters withSubnet(ResourceId subnet) {
        this.subnet = subnet;
        return this;
    }

}
