/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * CNTK (aka Microsoft Cognitive Toolkit) job settings.
 */
public class CNTKsettings {
    /**
     * Language type.
     * The language to use for launching CNTK (aka Microsoft Cognitive Toolkit)
     * job. Valid values are 'BrainScript' or 'Python'.
     */
    @JsonProperty(value = "languageType")
    private String languageType;

    /**
     * Config file path.
     * Specifies the path of the BrainScript config file. This property can be
     * specified only if the languageType is 'BrainScript'.
     */
    @JsonProperty(value = "configFilePath")
    private String configFilePath;

    /**
     * Python script file path.
     * Python script to execute. This property can be specified only if the
     * languageType is 'Python'.
     */
    @JsonProperty(value = "pythonScriptFilePath")
    private String pythonScriptFilePath;

    /**
     * Python interpreter path.
     * The path to the Python interpreter. This property can be specified only
     * if the languageType is 'Python'.
     */
    @JsonProperty(value = "pythonInterpreterPath")
    private String pythonInterpreterPath;

    /**
     * Command line arguments.
     * Command line arguments that need to be passed to the python script or
     * cntk executable.
     */
    @JsonProperty(value = "commandLineArgs")
    private String commandLineArgs;

    /**
     * Process count.
     * Number of processes to launch for the job execution. The default value
     * for this property is equal to nodeCount property.
     */
    @JsonProperty(value = "processCount")
    private Integer processCount;

    /**
     * Get the language to use for launching CNTK (aka Microsoft Cognitive Toolkit) job. Valid values are 'BrainScript' or 'Python'.
     *
     * @return the languageType value
     */
    public String languageType() {
        return this.languageType;
    }

    /**
     * Set the language to use for launching CNTK (aka Microsoft Cognitive Toolkit) job. Valid values are 'BrainScript' or 'Python'.
     *
     * @param languageType the languageType value to set
     * @return the CNTKsettings object itself.
     */
    public CNTKsettings withLanguageType(String languageType) {
        this.languageType = languageType;
        return this;
    }

    /**
     * Get specifies the path of the BrainScript config file. This property can be specified only if the languageType is 'BrainScript'.
     *
     * @return the configFilePath value
     */
    public String configFilePath() {
        return this.configFilePath;
    }

    /**
     * Set specifies the path of the BrainScript config file. This property can be specified only if the languageType is 'BrainScript'.
     *
     * @param configFilePath the configFilePath value to set
     * @return the CNTKsettings object itself.
     */
    public CNTKsettings withConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
        return this;
    }

    /**
     * Get python script to execute. This property can be specified only if the languageType is 'Python'.
     *
     * @return the pythonScriptFilePath value
     */
    public String pythonScriptFilePath() {
        return this.pythonScriptFilePath;
    }

    /**
     * Set python script to execute. This property can be specified only if the languageType is 'Python'.
     *
     * @param pythonScriptFilePath the pythonScriptFilePath value to set
     * @return the CNTKsettings object itself.
     */
    public CNTKsettings withPythonScriptFilePath(String pythonScriptFilePath) {
        this.pythonScriptFilePath = pythonScriptFilePath;
        return this;
    }

    /**
     * Get the path to the Python interpreter. This property can be specified only if the languageType is 'Python'.
     *
     * @return the pythonInterpreterPath value
     */
    public String pythonInterpreterPath() {
        return this.pythonInterpreterPath;
    }

    /**
     * Set the path to the Python interpreter. This property can be specified only if the languageType is 'Python'.
     *
     * @param pythonInterpreterPath the pythonInterpreterPath value to set
     * @return the CNTKsettings object itself.
     */
    public CNTKsettings withPythonInterpreterPath(String pythonInterpreterPath) {
        this.pythonInterpreterPath = pythonInterpreterPath;
        return this;
    }

    /**
     * Get command line arguments that need to be passed to the python script or cntk executable.
     *
     * @return the commandLineArgs value
     */
    public String commandLineArgs() {
        return this.commandLineArgs;
    }

    /**
     * Set command line arguments that need to be passed to the python script or cntk executable.
     *
     * @param commandLineArgs the commandLineArgs value to set
     * @return the CNTKsettings object itself.
     */
    public CNTKsettings withCommandLineArgs(String commandLineArgs) {
        this.commandLineArgs = commandLineArgs;
        return this;
    }

    /**
     * Get number of processes to launch for the job execution. The default value for this property is equal to nodeCount property.
     *
     * @return the processCount value
     */
    public Integer processCount() {
        return this.processCount;
    }

    /**
     * Set number of processes to launch for the job execution. The default value for this property is equal to nodeCount property.
     *
     * @param processCount the processCount value to set
     * @return the CNTKsettings object itself.
     */
    public CNTKsettings withProcessCount(Integer processCount) {
        this.processCount = processCount;
        return this;
    }

}
