/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Azure File Share mounting configuration.
 */
public class AzureFileShareReference {
    /**
     * Account name.
     * Name of the Azure storage account.
     */
    @JsonProperty(value = "accountName", required = true)
    private String accountName;

    /**
     * Azure File URL.
     * URL to access the Azure File.
     */
    @JsonProperty(value = "azureFileUrl", required = true)
    private String azureFileUrl;

    /**
     * Credentials.
     * Information about the Azure storage credentials.
     */
    @JsonProperty(value = "credentials", required = true)
    private AzureStorageCredentialsInfo credentials;

    /**
     * Relative mount path.
     * The relative path on the compute node where the Azure File share will be
     * mounted. Note that all cluster level file shares will be mounted under
     * $AZ_BATCHAI_MOUNT_ROOT location and all job level file shares will be
     * mounted under $AZ_BATCHAI_JOB_MOUNT_ROOT.
     */
    @JsonProperty(value = "relativeMountPath", required = true)
    private String relativeMountPath;

    /**
     * File mode.
     * File mode for files on the mounted file share. Default value: 0777.
     */
    @JsonProperty(value = "fileMode")
    private String fileMode;

    /**
     * Directory mode.
     * File mode for directories on the mounted file share. Default value:
     * 0777.
     */
    @JsonProperty(value = "directoryMode")
    private String directoryMode;

    /**
     * Get name of the Azure storage account.
     *
     * @return the accountName value
     */
    public String accountName() {
        return this.accountName;
    }

    /**
     * Set name of the Azure storage account.
     *
     * @param accountName the accountName value to set
     * @return the AzureFileShareReference object itself.
     */
    public AzureFileShareReference withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    /**
     * Get uRL to access the Azure File.
     *
     * @return the azureFileUrl value
     */
    public String azureFileUrl() {
        return this.azureFileUrl;
    }

    /**
     * Set uRL to access the Azure File.
     *
     * @param azureFileUrl the azureFileUrl value to set
     * @return the AzureFileShareReference object itself.
     */
    public AzureFileShareReference withAzureFileUrl(String azureFileUrl) {
        this.azureFileUrl = azureFileUrl;
        return this;
    }

    /**
     * Get information about the Azure storage credentials.
     *
     * @return the credentials value
     */
    public AzureStorageCredentialsInfo credentials() {
        return this.credentials;
    }

    /**
     * Set information about the Azure storage credentials.
     *
     * @param credentials the credentials value to set
     * @return the AzureFileShareReference object itself.
     */
    public AzureFileShareReference withCredentials(AzureStorageCredentialsInfo credentials) {
        this.credentials = credentials;
        return this;
    }

    /**
     * Get the relative path on the compute node where the Azure File share will be mounted. Note that all cluster level file shares will be mounted under $AZ_BATCHAI_MOUNT_ROOT location and all job level file shares will be mounted under $AZ_BATCHAI_JOB_MOUNT_ROOT.
     *
     * @return the relativeMountPath value
     */
    public String relativeMountPath() {
        return this.relativeMountPath;
    }

    /**
     * Set the relative path on the compute node where the Azure File share will be mounted. Note that all cluster level file shares will be mounted under $AZ_BATCHAI_MOUNT_ROOT location and all job level file shares will be mounted under $AZ_BATCHAI_JOB_MOUNT_ROOT.
     *
     * @param relativeMountPath the relativeMountPath value to set
     * @return the AzureFileShareReference object itself.
     */
    public AzureFileShareReference withRelativeMountPath(String relativeMountPath) {
        this.relativeMountPath = relativeMountPath;
        return this;
    }

    /**
     * Get file mode for files on the mounted file share. Default value: 0777.
     *
     * @return the fileMode value
     */
    public String fileMode() {
        return this.fileMode;
    }

    /**
     * Set file mode for files on the mounted file share. Default value: 0777.
     *
     * @param fileMode the fileMode value to set
     * @return the AzureFileShareReference object itself.
     */
    public AzureFileShareReference withFileMode(String fileMode) {
        this.fileMode = fileMode;
        return this;
    }

    /**
     * Get file mode for directories on the mounted file share. Default value: 0777.
     *
     * @return the directoryMode value
     */
    public String directoryMode() {
        return this.directoryMode;
    }

    /**
     * Set file mode for directories on the mounted file share. Default value: 0777.
     *
     * @param directoryMode the directoryMode value to set
     * @return the AzureFileShareReference object itself.
     */
    public AzureFileShareReference withDirectoryMode(String directoryMode) {
        this.directoryMode = directoryMode;
        return this;
    }

}
