/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.batchai.implementation.BatchAIManager;
import com.microsoft.azure.management.batchai.implementation.WorkspaceInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import org.joda.time.DateTime;

/**
 * Type representing Workspace.
 */
@Beta(Beta.SinceVersion.V1_12_0)
public interface BatchAIWorkspace extends
        GroupableResource<BatchAIManager, WorkspaceInner>,
        Refreshable<BatchAIWorkspace>,
        Updatable<BatchAIWorkspace.Update> {
    /**
     * @return the creationTime value.
     */
    DateTime creationTime();

    /**
     * @return the provisioningState value.
     */
    ProvisioningState provisioningState();

    /**
     * @return the provisioningStateTransitionTime value.
     */
    DateTime provisioningStateTransitionTime();

    /**
     * @return the entry point to Batch AI clusters management API for this workspace
     */
    BatchAIClusters clusters();

    /**
     * @return the entry point to Batch AI experiments management API for this workspace
     */
    BatchAIExperiments experiments();

    /**
     * @return the entry point to Batch AI file servers management API for this workspace
     */
    BatchAIFileServers fileServers();

    /**
     * The entirety of the Workspace definition.
     */
    interface Definition extends
            DefinitionStages.Blank,
            DefinitionStages.WithGroup,
            DefinitionStages.WithCreate {
    }

    /**
     * Grouping of Workspace definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of a Workspace definition.
         */
        interface Blank extends GroupableResource.DefinitionWithRegion<WithGroup> {
        }

        /**
         * The stage of the Workspace definition allowing to specify the resource group.
         */
        interface WithGroup extends GroupableResource.DefinitionStages.WithGroup<WithCreate> {
        }

        /**
         * The stage of the definition which contains all the minimum required inputs for
         * the resource to be created (via {@link WithCreate#create()}), but also allows
         * for any other optional settings to be specified.
         */
        interface WithCreate extends
                Creatable<BatchAIWorkspace>,
                Resource.DefinitionWithTags<WithCreate> {
        }
    }
    /**
     * The template for a Workspace update operation, containing all the settings that can be modified.
     */
    interface Update extends
            Appliable<BatchAIWorkspace>,
            Resource.UpdateWithTags<Update> {
    }
}
