/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A set of Azure Batch account keys.
 */
public class BatchAccountKeysInner {
    /**
     * The Batch account name.
     */
    @JsonProperty(value = "accountName", access = JsonProperty.Access.WRITE_ONLY)
    private String accountName;

    /**
     * The primary key associated with the account.
     */
    @JsonProperty(value = "primary", access = JsonProperty.Access.WRITE_ONLY)
    private String primary;

    /**
     * The secondary key associated with the account.
     */
    @JsonProperty(value = "secondary", access = JsonProperty.Access.WRITE_ONLY)
    private String secondary;

    /**
     * Get the Batch account name.
     *
     * @return the accountName value
     */
    public String accountName() {
        return this.accountName;
    }

    /**
     * Get the primary key associated with the account.
     *
     * @return the primary value
     */
    public String primary() {
        return this.primary;
    }

    /**
     * Get the secondary key associated with the account.
     *
     * @return the secondary value
     */
    public String secondary() {
        return this.secondary;
    }

}
