/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A VM Family and its associated core quota for the Batch account.
 */
public class VirtualMachineFamilyCoreQuota {
    /**
     * The Virtual Machine family name.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /**
     * The core quota for the VM family for the Batch account.
     */
    @JsonProperty(value = "coreQuota", access = JsonProperty.Access.WRITE_ONLY)
    private int coreQuota;

    /**
     * Get the Virtual Machine family name.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the core quota for the VM family for the Batch account.
     *
     * @return the coreQuota value
     */
    public int coreQuota() {
        return this.coreQuota;
    }

}
