/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for ContainerWorkingDirectory.
 */
public enum ContainerWorkingDirectory {
    /** Use the standard Batch service task working directory, which will contain the Task resource files populated by Batch. */
    TASK_WORKING_DIRECTORY("TaskWorkingDirectory"),

    /** Using container image defined working directory. Beware that this directory will not contain the resource files downloaded by Batch. */
    CONTAINER_IMAGE_DEFAULT("ContainerImageDefault");

    /** The actual serialized value for a ContainerWorkingDirectory instance. */
    private String value;

    ContainerWorkingDirectory(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ContainerWorkingDirectory instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed ContainerWorkingDirectory object, or null if unable to parse.
     */
    @JsonCreator
    public static ContainerWorkingDirectory fromString(String value) {
        ContainerWorkingDirectory[] items = ContainerWorkingDirectory.values();
        for (ContainerWorkingDirectory item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
