/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenUtils {
    public static Xpp3Dom getPluginConfiguration(MavenProject mavenProject, String pluginKey) {
        Plugin plugin = MavenUtils.getPluginFromMavenModel(mavenProject.getModel(), pluginKey);
        return plugin == null ? null : (Xpp3Dom)plugin.getConfiguration();
    }

    private static Plugin getPluginFromMavenModel(Model model, String pluginKey) {
        if (model.getBuild() == null) {
            return null;
        }
        for (Plugin plugin : model.getBuild().getPlugins()) {
            if (!pluginKey.equalsIgnoreCase(plugin.getKey())) continue;
            return plugin;
        }
        if (model.getBuild().getPluginManagement() == null) {
            return null;
        }
        for (Plugin plugin : model.getBuild().getPluginManagement().getPlugins()) {
            if (!pluginKey.equalsIgnoreCase(plugin.getKey())) continue;
            return plugin;
        }
        return null;
    }

    private MavenUtils() {
    }
}

