/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven;

import com.microsoft.applicationinsights.internal.channel.common.ApacheSenderFactory;
import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.common.utils.GetHashMac;
import com.microsoft.azure.common.utils.TextUtils;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.resources.Subscription;
import com.microsoft.azure.maven.auth.AuthConfiguration;
import com.microsoft.azure.maven.auth.AuthenticationSetting;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.auth.AzureAuthHelperLegacy;
import com.microsoft.azure.maven.auth.AzureClientFactory;
import com.microsoft.azure.maven.auth.MavenAuthManager;
import com.microsoft.azure.maven.model.MavenAuthConfiguration;
import com.microsoft.azure.maven.model.SubscriptionOption;
import com.microsoft.azure.maven.telemetry.AppInsightsProxy;
import com.microsoft.azure.maven.telemetry.TelemetryConfiguration;
import com.microsoft.azure.maven.telemetry.TelemetryProxy;
import com.microsoft.azure.maven.utils.CustomTextIoStringListReader;
import com.microsoft.azure.maven.utils.MavenUtils;
import com.microsoft.azure.maven.utils.ProxyUtils;
import com.microsoft.azure.maven.utils.SystemPropertyUtils;
import com.microsoft.azure.tools.auth.exception.AzureLoginException;
import com.microsoft.azure.tools.auth.model.AzureCredentialWrapper;
import com.microsoft.azure.tools.auth.util.AzureEnvironmentUtils;
import com.microsoft.azure.tools.common.util.StringListUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.TextIO;
import org.beryx.textio.TextIoFactory;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public abstract class AbstractAzureMojo
extends AbstractMojo
implements TelemetryConfiguration,
AuthConfiguration {
    public static final String PLUGIN_NAME_KEY = "pluginName";
    public static final String PLUGIN_VERSION_KEY = "pluginVersion";
    public static final String INSTALLATION_ID_KEY = "installationId";
    public static final String SESSION_ID_KEY = "sessionId";
    public static final String SUBSCRIPTION_ID_KEY = "subscriptionId";
    protected static final String DEPLOY = "deploy";
    private static final String AUTH_TYPE = "authType";
    private static final String AUTH_METHOD = "authMethod";
    private static final String TELEMETRY_NOT_ALLOWED = "TelemetryNotAllowed";
    private static final String INIT_FAILURE = "InitFailure";
    private static final String AZURE_INIT_FAIL = "Failed to authenticate with Azure. Please check your configuration.";
    private static final String FAILURE_REASON = "failureReason";
    private static final String JVM_UP_TIME = "jvmUpTime";
    private static final String CONFIGURATION_PATH = Paths.get(System.getProperty("user.home"), ".azure", "mavenplugins.properties").toString();
    private static final String FIRST_RUN_KEY = "first.run";
    private static final String PRIVACY_STATEMENT = "\nData/Telemetry\n---------\nThis project collects usage data and sends it to Microsoft to help improve our products and services.\nRead Microsoft's privacy statement to learn more: https://privacy.microsoft.com/en-us/privacystatement.\n\nYou can change your telemetry configuration through 'allowTelemetry' property.\nFor more information, please go to https://aka.ms/azure-maven-config.\n";
    protected static final String SUBSCRIPTION_TEMPLATE = "Subscription: %s(%s)";
    protected static final String USING_AZURE_ENVIRONMENT = "Using Azure environment: %s.";
    protected static final String SUBSCRIPTION_NOT_SPECIFIED = "Subscription ID was not specified, using the first subscription in current account, please refer https://github.com/microsoft/azure-maven-plugins/wiki/Authentication#subscription for more information.";
    protected static final String SUBSCRIPTION_NOT_FOUND = "Subscription %s was not found in current account.";
    private static final String INVALID_AZURE_ENVIRONMENT = "Invalid environment string '%s', please replace it with one of \"Azure\", \"AzureChina\", \"AzureGermany\", \"AzureUSGovernment\",.";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    protected File buildDirectory;
    @Parameter(defaultValue="${plugin}", readonly=true, required=true)
    protected PluginDescriptor plugin;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    protected Settings settings;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    protected MavenResourcesFiltering mavenResourcesFiltering;
    @Parameter
    protected AuthenticationSetting authentication;
    @Parameter
    protected String subscriptionId = "";
    @Parameter(property="allowTelemetry", defaultValue="true")
    protected boolean allowTelemetry;
    @Parameter(property="failsOnError", defaultValue="true")
    protected boolean failsOnError;
    @Parameter(property="httpProxyHost")
    protected String httpProxyHost;
    @Parameter(property="httpProxyPort")
    protected String httpProxyPort;
    @Parameter(property="authType")
    protected String authType;
    @Parameter(property="auth")
    protected MavenAuthConfiguration auth;
    @Component
    protected SettingsDecrypter settingsDecrypter;
    private Azure azure;
    private TelemetryProxy telemetryProxy;
    private AzureCredentialWrapper azureCredentialWrapper;
    private String sessionId = UUID.randomUUID().toString();
    private String installationId = GetHashMac.getHashMac();

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public String getBuildDirectoryAbsolutePath() {
        return this.buildDirectory.getAbsolutePath();
    }

    public MavenResourcesFiltering getMavenResourcesFiltering() {
        return this.mavenResourcesFiltering;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public AuthenticationSetting getAuthenticationSetting() {
        return this.authentication;
    }

    @Override
    public String getSubscriptionId() {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.subscriptionId, this.azureCredentialWrapper == null ? null : this.azureCredentialWrapper.getDefaultSubscriptionId()});
    }

    public boolean isTelemetryAllowed() {
        return this.allowTelemetry;
    }

    public boolean isFailingOnError() {
        return this.failsOnError;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getInstallationId() {
        return this.installationId == null ? "" : this.installationId;
    }

    public String getPluginName() {
        return this.plugin.getArtifactId();
    }

    public String getPluginVersion() {
        return this.plugin.getVersion();
    }

    @Override
    public String getUserAgent() {
        return this.isTelemetryAllowed() ? String.format("%s/%s %s:%s %s:%s", this.getPluginName(), this.getPluginVersion(), INSTALLATION_ID_KEY, this.getInstallationId(), SESSION_ID_KEY, this.getSessionId()) : String.format("%s/%s", this.getPluginName(), this.getPluginVersion());
    }

    @Override
    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    @Override
    public int getHttpProxyPort() {
        return NumberUtils.toInt((String)this.httpProxyPort, (int)0);
    }

    public Azure getAzureClient() throws AzureAuthFailureException, AzureExecutionException {
        if (this.azure == null) {
            if (this.authentication != null && (this.authentication.getFile() != null || StringUtils.isNotBlank((CharSequence)this.authentication.getServerId()))) {
                Log.warn((String)"You are using an old way of authentication which will be deprecated in future versions, please change your configurations.");
                this.azure = new AzureAuthHelperLegacy(this).getAzureClient();
            } else {
                this.azure = this.getOrCreateAzureClient();
            }
            if (this.azure == null) {
                this.getTelemetryProxy().trackEvent(INIT_FAILURE);
                throw new AzureAuthFailureException(AZURE_INIT_FAIL);
            }
            AbstractAzureMojo.printCurrentSubscription(this.azure);
            this.getTelemetryProxy().addDefaultProperty(AUTH_TYPE, this.getAuthType());
            this.getTelemetryProxy().addDefaultProperty(AUTH_METHOD, this.getAuthMethod());
            this.getTelemetryProxy().addDefaultProperty(SUBSCRIPTION_ID_KEY, this.azure.subscriptionId());
        }
        return this.azure;
    }

    protected String getAuthType() {
        return (String)StringUtils.firstNonBlank((CharSequence[])new String[]{this.auth == null ? null : this.auth.getType(), this.authType});
    }

    protected String selectSubscription(Subscription[] subscriptions) throws AzureExecutionException {
        if (subscriptions.length == 0) {
            throw new AzureExecutionException("Cannot find any subscriptions in current account.");
        }
        if (subscriptions.length == 1) {
            Log.info((String)String.format("There is only one subscription '%s' in your account, will use it automatically.", TextUtils.blue((String)SubscriptionOption.getSubscriptionName(subscriptions[0]))));
            return subscriptions[0].subscriptionId();
        }
        List wrapSubs = Arrays.stream(subscriptions).map(t -> new SubscriptionOption((Subscription)t)).sorted().collect(Collectors.toList());
        SubscriptionOption defaultValue = (SubscriptionOption)wrapSubs.get(0);
        TextIO textIO = TextIoFactory.getTextIO();
        SubscriptionOption subscriptionOptionSelected = (SubscriptionOption)((GenericInputReader)((GenericInputReader)new CustomTextIoStringListReader(() -> textIO.getTextTerminal(), null).withCustomPrompt(String.format("Please choose a subscription%s: ", AbstractAzureMojo.highlightDefaultValue(defaultValue == null ? null : defaultValue.getSubscriptionName()))).withNumberedPossibleValues(wrapSubs)).withDefaultValue((Object)defaultValue)).read(new String[]{"Available subscriptions:"});
        if (subscriptionOptionSelected == null) {
            throw new AzureExecutionException("You must select a subscription.");
        }
        return subscriptionOptionSelected.getSubscription().subscriptionId();
    }

    protected Azure getOrCreateAzureClient() throws AzureAuthFailureException, AzureExecutionException {
        try {
            MavenAuthConfiguration mavenAuthConfiguration = this.auth == null ? new MavenAuthConfiguration() : this.auth;
            mavenAuthConfiguration.setType(this.getAuthType());
            SystemPropertyUtils.injectCommandLineParameter("auth", mavenAuthConfiguration, MavenAuthConfiguration.class);
            this.azureCredentialWrapper = MavenAuthManager.getInstance().login(this.session, this.settingsDecrypter, mavenAuthConfiguration);
            if (Objects.isNull(this.azureCredentialWrapper)) {
                return null;
            }
            AzureEnvironment env = this.azureCredentialWrapper.getEnv();
            String environmentName = AzureEnvironmentUtils.azureEnvironmentToString((AzureEnvironment)env);
            if (env != AzureEnvironment.AZURE) {
                Log.prompt((String)String.format(USING_AZURE_ENVIRONMENT, TextUtils.cyan((String)environmentName)));
            }
            Log.info((String)this.azureCredentialWrapper.getCredentialDescription());
            PagedList subscriptions = Azure.configure().authenticate(this.azureCredentialWrapper.getAzureTokenCredentials()).subscriptions().list();
            subscriptions.loadAll();
            String targetSubscriptionId = this.getTargetSubscriptionId(this.getSubscriptionId(), (PagedList<Subscription>)subscriptions);
            AbstractAzureMojo.checkSubscription((List<Subscription>)subscriptions, targetSubscriptionId);
            this.azureCredentialWrapper.withDefaultSubscriptionId(targetSubscriptionId);
            return AzureClientFactory.getAzureClient(this.azureCredentialWrapper, this.getUserAgent());
        }
        catch (AzureLoginException | IOException e) {
            throw new AzureAuthFailureException(e.getMessage());
        }
    }

    protected AzureCredentialWrapper getAzureCredentialWrapper() {
        return this.azureCredentialWrapper;
    }

    public TelemetryProxy getTelemetryProxy() {
        if (this.telemetryProxy == null) {
            this.initTelemetry();
        }
        return this.telemetryProxy;
    }

    protected void initTelemetry() {
        this.telemetryProxy = new AppInsightsProxy(this);
        if (!this.isTelemetryAllowed()) {
            this.telemetryProxy.trackEvent(TELEMETRY_NOT_ALLOWED);
            this.telemetryProxy.disable();
        }
    }

    protected static void printCurrentSubscription(Azure azure) {
        if (azure == null) {
            return;
        }
        Subscription subscription = azure.getCurrentSubscription();
        if (subscription != null) {
            Log.info((String)String.format(SUBSCRIPTION_TEMPLATE, TextUtils.cyan((String)subscription.displayName()), TextUtils.cyan((String)subscription.subscriptionId())));
        }
    }

    protected boolean isAuthConfigurationExist() {
        String pluginKey = this.plugin.getPluginLookupKey();
        Xpp3Dom pluginDom = MavenUtils.getPluginConfiguration(this.project, pluginKey);
        if (pluginDom == null) {
            return false;
        }
        Xpp3Dom authDom = pluginDom.getChild("auth");
        return authDom != null && authDom.getChildren().length > 0;
    }

    @Override
    public Map<String, String> getTelemetryProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(INSTALLATION_ID_KEY, this.getInstallationId());
        map.put(PLUGIN_NAME_KEY, this.getPluginName());
        map.put(PLUGIN_VERSION_KEY, this.getPluginVersion());
        map.put(SUBSCRIPTION_ID_KEY, this.getSubscriptionId());
        map.put(SESSION_ID_KEY, this.getSessionId());
        return map;
    }

    public String getAuthMethod() {
        if (this.azureCredentialWrapper != null) {
            return this.azureCredentialWrapper.getAuthMethod().name();
        }
        AuthenticationSetting authSetting = this.getAuthenticationSetting();
        if (authSetting == null) {
            return "AzureCLI";
        }
        if (StringUtils.isNotEmpty((CharSequence)authSetting.getServerId())) {
            return "ServerId";
        }
        if (authSetting.getFile() != null) {
            return "AuthFile";
        }
        return "Unknown";
    }

    public void execute() throws MojoExecutionException {
        try {
            ProxyUtils.initProxy(Optional.ofNullable(this.session).map(s -> s.getRequest()).orElse(null));
            Thread.setDefaultUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler());
            Properties prop = new Properties();
            if (this.isFirstRun(prop)) {
                this.infoWithMultipleLines(PRIVACY_STATEMENT);
                this.updateConfigurationFile(prop);
            }
            if (this.isSkipMojo()) {
                Log.info((String)"Skip execution.");
                this.trackMojoSkip();
            } else {
                this.trackMojoStart();
                this.doExecute();
                this.trackMojoSuccess();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            ApacheSenderFactory.INSTANCE.create().close();
        }
    }

    protected boolean isSkipMojo() {
        return false;
    }

    protected abstract void doExecute() throws AzureExecutionException;

    protected void trackMojoSkip() {
        this.getTelemetryProxy().trackEvent(this.getClass().getSimpleName() + ".skip");
    }

    protected void trackMojoStart() {
        this.getTelemetryProxy().trackEvent(this.getClass().getSimpleName() + ".start");
    }

    protected void trackMojoSuccess() {
        this.getTelemetryProxy().trackEvent(this.getClass().getSimpleName() + ".success", this.recordJvmUpTime(new HashMap<String, String>()));
    }

    protected void trackMojoFailure(String message) {
        HashMap<String, String> failureParameters = new HashMap<String, String>();
        failureParameters.put(FAILURE_REASON, message);
        this.getTelemetryProxy().trackEvent(this.getClass().getSimpleName() + ".failure", this.recordJvmUpTime(failureParameters));
    }

    protected static String highlightDefaultValue(String defaultValue) {
        return StringUtils.isBlank((CharSequence)defaultValue) ? "" : String.format(" [%s]", TextUtils.blue((String)defaultValue));
    }

    protected void handleException(Exception exception) throws MojoExecutionException {
        String message = exception.getMessage();
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = exception.toString();
        }
        this.trackMojoFailure(message);
        if (this.isFailingOnError()) {
            throw new MojoExecutionException(message, exception);
        }
        Log.error((String)message);
    }

    protected void executeWithTimeRecorder(RunnableWithException operation, String name) throws AzureExecutionException {
        long startTime = System.currentTimeMillis();
        try {
            operation.run();
        }
        catch (Exception e) {
            try {
                throw new AzureExecutionException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                long endTime = System.currentTimeMillis();
                this.getTelemetryProxy().addDefaultProperty(String.format("%s-cost", name), String.valueOf(endTime - startTime));
                throw throwable;
            }
        }
        long endTime = System.currentTimeMillis();
        this.getTelemetryProxy().addDefaultProperty(String.format("%s-cost", name), String.valueOf(endTime - startTime));
    }

    private Map<String, String> recordJvmUpTime(Map<String, String> properties) {
        long jvmUpTime = ManagementFactory.getRuntimeMXBean().getUptime();
        properties.put(JVM_UP_TIME, String.valueOf(jvmUpTime));
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isFirstRun(Properties prop) {
        try {
            File configurationFile = new File(CONFIGURATION_PATH);
            if (!configurationFile.exists()) {
                configurationFile.getParentFile().mkdirs();
                configurationFile.createNewFile();
                return true;
            }
            try (FileInputStream input = new FileInputStream(CONFIGURATION_PATH);){
                prop.load(input);
                String firstRunValue = prop.getProperty(FIRST_RUN_KEY);
                if (firstRunValue == null) return true;
                if (firstRunValue.isEmpty()) return true;
                if (!firstRunValue.equalsIgnoreCase("false")) return true;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            Log.debug((String)e.getMessage());
        }
        return true;
    }

    private void updateConfigurationFile(Properties prop) {
        try (FileOutputStream output = new FileOutputStream(CONFIGURATION_PATH);){
            prop.setProperty(FIRST_RUN_KEY, "false");
            prop.store(output, "Azure Maven Plugin configurations");
        }
        catch (Exception e) {
            Log.debug((String)e.getMessage());
        }
    }

    public void infoWithMultipleLines(String messages) {
        String[] messageArray;
        for (String line : messageArray = messages.split("\\n")) {
            Log.info((String)line);
        }
    }

    private String getTargetSubscriptionId(String defaultSubscriptionId, PagedList<Subscription> subscriptions) throws IOException, AzureExecutionException {
        Collection filteredSubscriptions;
        List subsIdList = subscriptions.stream().map(Subscription::subscriptionId).collect(Collectors.toList());
        String targetSubscriptionId = defaultSubscriptionId;
        if (StringUtils.isBlank((CharSequence)targetSubscriptionId) && ArrayUtils.isNotEmpty((Object[])this.azureCredentialWrapper.getFilteredSubscriptionIds()) && (filteredSubscriptions = StringListUtils.intersectIgnoreCase(subsIdList, Arrays.asList(this.azureCredentialWrapper.getFilteredSubscriptionIds()))).size() == 1) {
            targetSubscriptionId = (String)filteredSubscriptions.iterator().next();
        }
        if (StringUtils.isBlank((CharSequence)targetSubscriptionId)) {
            return this.selectSubscription((Subscription[])subscriptions.toArray((Object[])new Subscription[0]));
        }
        return targetSubscriptionId;
    }

    private static void checkSubscription(List<Subscription> subscriptions, String targetSubscriptionId) throws AzureLoginException {
        if (StringUtils.isEmpty((CharSequence)targetSubscriptionId)) {
            Log.warn((String)SUBSCRIPTION_NOT_SPECIFIED);
            return;
        }
        Optional<Subscription> optionalSubscription = subscriptions.stream().filter(subscription -> StringUtils.equals((CharSequence)subscription.subscriptionId(), (CharSequence)targetSubscriptionId)).findAny();
        if (!optionalSubscription.isPresent()) {
            throw new AzureLoginException(String.format(SUBSCRIPTION_NOT_FOUND, targetSubscriptionId));
        }
    }

    protected static interface RunnableWithException {
        public void run() throws Exception;
    }

    protected class DefaultUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        protected DefaultUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            Log.debug((String)("uncaughtException: " + e));
        }
    }
}

