/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.common.appservice.DeploymentSlotSetting;
import com.microsoft.azure.common.appservice.DeploymentType;
import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.maven.AbstractAzureMojo;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.tools.auth.model.AzureCredentialWrapper;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Resource;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractAppServiceMojo
extends AbstractAzureMojo {
    protected static final String MAVEN_PLUGIN_POSTFIX = "-maven-plugin";
    protected static final String PORTAL_URL_PATTERN = "%s/#@%s/resource%s";
    @Parameter(property="resourceGroup", required=false)
    protected String resourceGroup;
    @Parameter(property="appName", required=false)
    protected String appName;
    @Parameter(property="deploymentType")
    protected String deploymentType;
    @Parameter(property="appServicePlanResourceGroup")
    protected String appServicePlanResourceGroup;
    @Parameter(property="appServicePlanName")
    protected String appServicePlanName;
    @Parameter(alias="deploymentSlot")
    protected DeploymentSlotSetting deploymentSlotSetting;
    @Parameter
    protected Properties appSettings;

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppServicePlanResourceGroup() {
        return this.appServicePlanResourceGroup;
    }

    public String getAppServicePlanName() {
        return this.appServicePlanName;
    }

    public Map getAppSettings() {
        if (this.appSettings == null) {
            this.appSettings = new Properties();
        }
        return this.appSettings;
    }

    public DeploymentType getDeploymentType() throws AzureExecutionException {
        return DeploymentType.fromString((String)this.deploymentType);
    }

    public DeploymentSlotSetting getDeploymentSlotSetting() {
        return this.deploymentSlotSetting;
    }

    public List<Resource> getResources() {
        return Collections.EMPTY_LIST;
    }

    public String getDeploymentStagingDirectoryPath() {
        String outputFolder = this.getPluginName().replaceAll(MAVEN_PLUGIN_POSTFIX, "");
        return Paths.get(this.getBuildDirectoryAbsolutePath(), outputFolder, this.getAppName()).toString();
    }

    public void setDeploymentSlot(DeploymentSlotSetting slotSetting) {
        this.deploymentSlotSetting = slotSetting;
    }

    public String getResourcePortalUrl(WebAppBase resource) throws AzureAuthFailureException, AzureExecutionException {
        AzureCredentialWrapper azureCredentialWrapper = this.getAzureCredentialWrapper();
        AzureEnvironment environment = azureCredentialWrapper.getEnv();
        String tenantId = this.getAzureClient().tenantId();
        return String.format(PORTAL_URL_PATTERN, AbstractAppServiceMojo.getPortalUrl(environment), tenantId, resource.id());
    }

    private static String getPortalUrl(AzureEnvironment azureEnvironment) {
        if (azureEnvironment == null || azureEnvironment == AzureEnvironment.AZURE) {
            return "https://ms.portal.azure.com";
        }
        if (azureEnvironment == AzureEnvironment.AZURE_CHINA) {
            return "https://portal.azure.cn";
        }
        return azureEnvironment.portal();
    }
}

