/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.queryer;

import com.microsoft.azure.maven.queryer.MavenPluginQueryer;
import com.microsoft.azure.maven.utils.TextIOUtils;
import com.microsoft.azure.toolkit.lib.common.logging.Log;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.beryx.textio.GenericInputReader;
import org.beryx.textio.StringInputReader;

public class TextIOMavenPluginQueryer
extends MavenPluginQueryer {
    private static final String FOUND_VALID_VALUE = "Found valid value. Skip user input.";
    private static final String PROMPT_STRING_WITHOUT_DEFAULTVALUE = "Define value for %s";

    @Override
    public String assureInputFromUser(String attribute, String defaultValue, List<String> options, String prompt) {
        String initValue = this.getInitValue(attribute);
        if (initValue != null && this.validateInputByOptions(initValue, options)) {
            Log.info((String)FOUND_VALID_VALUE);
            return initValue;
        }
        prompt = StringUtils.isEmpty((CharSequence)prompt) ? this.getPromptString(attribute) : prompt;
        return (String)((GenericInputReader)((GenericInputReader)((GenericInputReader)new GenericInputReader(TextIOUtils::getTextTerminal, null).withNumberedPossibleValues(options)).withDefaultValue((Object)defaultValue)).withEqualsFunc(StringUtils::equalsIgnoreCase)).read(new String[]{prompt});
    }

    @Override
    public String assureInputFromUser(String attribute, String defaultValue, String regex, String prompt, String errorMessage) {
        String initValue = this.getInitValue(attribute);
        if (initValue != null && this.validateInputByRegex(initValue, regex)) {
            Log.info((String)FOUND_VALID_VALUE);
            return initValue;
        }
        prompt = StringUtils.isEmpty((CharSequence)prompt) ? this.getPromptString(attribute) : prompt;
        return (String)((StringInputReader)new StringInputReader(TextIOUtils::getTextTerminal).withPattern(regex).withDefaultValue((Object)defaultValue)).withMinLength(0).read(new String[]{prompt});
    }

    private String getPromptString(String attributeName) {
        return String.format(PROMPT_STRING_WITHOUT_DEFAULTVALUE, attributeName);
    }

    @Override
    public void close() {
    }
}

