/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven;

import com.microsoft.azure.management.Azure;
import com.microsoft.azure.maven.auth.AuthConfiguration;
import com.microsoft.azure.maven.auth.AuthenticationSetting;
import com.microsoft.azure.maven.auth.AzureAuthFailureException;
import com.microsoft.azure.maven.auth.AzureAuthHelper;
import com.microsoft.azure.maven.telemetry.AppInsightsProxy;
import com.microsoft.azure.maven.telemetry.GetHashMac;
import com.microsoft.azure.maven.telemetry.TelemetryConfiguration;
import com.microsoft.azure.maven.telemetry.TelemetryProxy;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractAzureMojo
extends AbstractMojo
implements TelemetryConfiguration,
AuthConfiguration {
    public static final String PLUGIN_NAME_KEY = "pluginName";
    public static final String PLUGIN_VERSION_KEY = "pluginVersion";
    public static final String INSTALLATION_ID_KEY = "installationId";
    public static final String SESSION_ID_KEY = "sessionId";
    public static final String SUBSCRIPTION_ID_KEY = "subscriptionId";
    public static final String AUTH_TYPE = "authType";
    public static final String TELEMETRY_NOT_ALLOWED = "TelemetryNotAllowed";
    public static final String INIT_FAILURE = "InitFailure";
    public static final String AZURE_INIT_FAIL = "Failed to authenticate with Azure. Please check your configuration.";
    public static final String FAILURE_REASON = "failureReason";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    protected File buildDirectory;
    @Parameter(defaultValue="${plugin}", readonly=true, required=true)
    protected PluginDescriptor plugin;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    protected Settings settings;
    @Component(role=MavenResourcesFiltering.class, hint="default")
    protected MavenResourcesFiltering mavenResourcesFiltering;
    @Parameter
    protected AuthenticationSetting authentication;
    @Parameter
    protected String subscriptionId = "";
    @Parameter(property="allowTelemetry", defaultValue="true")
    protected boolean allowTelemetry;
    @Parameter(property="failsOnError", defaultValue="true")
    protected boolean failsOnError;
    private AzureAuthHelper azureAuthHelper = new AzureAuthHelper(this);
    private Azure azure;
    private TelemetryProxy telemetryProxy;
    private String sessionId = UUID.randomUUID().toString();
    private String installationId = GetHashMac.getHashMac();

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public String getBuildDirectoryAbsolutePath() {
        return this.buildDirectory.getAbsolutePath();
    }

    public MavenResourcesFiltering getMavenResourcesFiltering() {
        return this.mavenResourcesFiltering;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public AuthenticationSetting getAuthenticationSetting() {
        return this.authentication;
    }

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public boolean isTelemetryAllowed() {
        return this.allowTelemetry;
    }

    public boolean isFailingOnError() {
        return this.failsOnError;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getInstallationId() {
        return this.installationId == null ? "" : this.installationId;
    }

    public String getPluginName() {
        return this.plugin.getArtifactId();
    }

    public String getPluginVersion() {
        return this.plugin.getVersion();
    }

    @Override
    public String getUserAgent() {
        return String.format("%s/%s %s:%s %s:%s", this.getPluginName(), this.getPluginVersion(), INSTALLATION_ID_KEY, this.getInstallationId(), SESSION_ID_KEY, this.getSessionId());
    }

    public Azure getAzureClient() throws AzureAuthFailureException {
        if (this.azure == null) {
            this.azure = this.azureAuthHelper.getAzureClient();
            if (this.azure == null) {
                this.getTelemetryProxy().trackEvent(INIT_FAILURE);
                throw new AzureAuthFailureException(AZURE_INIT_FAIL);
            }
            this.getTelemetryProxy().addDefaultProperty(SUBSCRIPTION_ID_KEY, this.azure.subscriptionId());
        }
        return this.azure;
    }

    public TelemetryProxy getTelemetryProxy() {
        if (this.telemetryProxy == null) {
            this.initTelemetry();
        }
        return this.telemetryProxy;
    }

    protected void initTelemetry() {
        this.telemetryProxy = new AppInsightsProxy(this);
        if (!this.isTelemetryAllowed()) {
            this.telemetryProxy.trackEvent(TELEMETRY_NOT_ALLOWED);
            this.telemetryProxy.disable();
        }
    }

    @Override
    public Map<String, String> getTelemetryProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(INSTALLATION_ID_KEY, this.getInstallationId());
        map.put(PLUGIN_NAME_KEY, this.getPluginName());
        map.put(PLUGIN_VERSION_KEY, this.getPluginVersion());
        map.put(SUBSCRIPTION_ID_KEY, this.getSubscriptionId());
        map.put(SESSION_ID_KEY, this.getSessionId());
        map.put(AUTH_TYPE, this.getAuthType());
        return map;
    }

    public String getAuthType() {
        AuthenticationSetting authSetting = this.getAuthenticationSetting();
        if (authSetting == null) {
            return "AzureCLI";
        }
        if (StringUtils.isNotEmpty((String)authSetting.getServerId())) {
            return "ServerId";
        }
        if (authSetting.getFile() != null) {
            return "AuthFile";
        }
        return "Unknown";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Thread.setDefaultUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler());
            if (this.isSkipMojo()) {
                this.info("Skip execution.");
                this.trackMojoSkip();
            } else {
                this.trackMojoStart();
                this.doExecute();
                this.trackMojoSuccess();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected boolean isSkipMojo() {
        return false;
    }

    protected abstract void doExecute() throws Exception;

    protected void trackMojoSkip() {
        this.getTelemetryProxy().trackEvent(this.getClass().getSimpleName() + ".skip");
    }

    protected void trackMojoStart() {
        this.getTelemetryProxy().trackEvent(this.getClass().getSimpleName() + ".start");
    }

    protected void trackMojoSuccess() {
        this.getTelemetryProxy().trackEvent(this.getClass().getSimpleName() + ".success");
    }

    protected void trackMojoFailure(String message) {
        HashMap<String, String> failureReason = new HashMap<String, String>();
        failureReason.put(FAILURE_REASON, message);
        this.getTelemetryProxy().trackEvent(this.getClass().getSimpleName() + ".failure", failureReason);
    }

    protected void handleException(Exception exception) throws MojoExecutionException {
        String message = exception.getMessage();
        if (StringUtils.isEmpty((String)message)) {
            message = exception.toString();
        }
        this.trackMojoFailure(message);
        if (this.isFailingOnError()) {
            throw new MojoExecutionException(message, exception);
        }
        this.error(message);
    }

    public void debug(String message) {
        this.getLog().debug((CharSequence)message);
    }

    public void info(String message) {
        this.getLog().info((CharSequence)message);
    }

    public void warning(String message) {
        this.getLog().warn((CharSequence)message);
    }

    public void error(String message) {
        this.getLog().error((CharSequence)message);
    }

    protected class DefaultUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        protected DefaultUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            AbstractAzureMojo.this.debug("uncaughtException: " + e);
        }
    }
}

