/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.keyvault.webkey.JsonWebKeySignatureAlgorithm;
import com.microsoft.rest.Base64Url;

public class KeyVerifyParameters {
    @JsonProperty(value="alg", required=true)
    private JsonWebKeySignatureAlgorithm algorithm;
    @JsonProperty(required=true)
    private Base64Url digest;
    @JsonProperty(value="value", required=true)
    private Base64Url signature;

    public JsonWebKeySignatureAlgorithm algorithm() {
        return this.algorithm;
    }

    public KeyVerifyParameters withAlgorithm(JsonWebKeySignatureAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public byte[] digest() {
        if (this.digest == null) {
            return null;
        }
        return this.digest.getDecodedBytes();
    }

    public KeyVerifyParameters withDigest(byte[] digest) {
        this.digest = digest == null ? null : Base64Url.encode((byte[])digest);
        return this;
    }

    public byte[] signature() {
        if (this.signature == null) {
            return null;
        }
        return this.signature.getDecodedBytes();
    }

    public KeyVerifyParameters withSignature(byte[] signature) {
        this.signature = signature == null ? null : Base64Url.encode((byte[])signature);
        return this;
    }
}

