/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.authentication;

import com.microsoft.azure.keyvault.authentication.ChallengeCache;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Authenticator;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public abstract class KeyVaultCredentials
implements ServiceClientCredentials {
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String AUTHENTICATE = "Authorization";
    private static final String BEARER_TOKEP_REFIX = "Bearer ";
    private final ChallengeCache cache = new ChallengeCache();

    public void applyCredentialsFilter(OkHttpClient.Builder clientBuilder) {
        clientBuilder.addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                HttpUrl url = chain.request().url();
                Map<String, String> challengeMap = KeyVaultCredentials.this.cache.getCachedChallenge(url);
                if (challengeMap != null) {
                    String credential = KeyVaultCredentials.this.getAuthenticationCredentials(challengeMap);
                    Request newRequest = chain.request().newBuilder().header(KeyVaultCredentials.AUTHENTICATE, KeyVaultCredentials.BEARER_TOKEP_REFIX + credential).build();
                    return chain.proceed(newRequest);
                }
                return chain.proceed(chain.request());
            }
        });
        clientBuilder.authenticator(new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                String authenticateHeader = response.header(KeyVaultCredentials.WWW_AUTHENTICATE);
                Map challengeMap = KeyVaultCredentials.extractChallenge(authenticateHeader, KeyVaultCredentials.BEARER_TOKEP_REFIX);
                KeyVaultCredentials.this.cache.addCachedChallenge(response.request().url(), challengeMap);
                String credential = KeyVaultCredentials.this.getAuthenticationCredentials(challengeMap);
                if (credential == null) {
                    return null;
                }
                return response.request().newBuilder().header(KeyVaultCredentials.AUTHENTICATE, KeyVaultCredentials.BEARER_TOKEP_REFIX + credential).build();
            }
        });
    }

    private String getAuthenticationCredentials(Map<String, String> challengeMap) {
        String authorization = challengeMap.get("authorization");
        if (authorization == null) {
            authorization = challengeMap.get("authorization_uri");
        }
        String resource = challengeMap.get("resource");
        String scope = challengeMap.get("scope");
        return this.doAuthenticate(authorization, resource, scope);
    }

    private static Map<String, String> extractChallenge(String authenticateHeader, String authChallengePrefix) {
        if (!KeyVaultCredentials.isValidChallenge(authenticateHeader, authChallengePrefix)) {
            return null;
        }
        authenticateHeader = authenticateHeader.toLowerCase().replace(authChallengePrefix.toLowerCase(), "");
        String[] challenges = authenticateHeader.split(", ");
        HashMap<String, String> challengeMap = new HashMap<String, String>();
        for (String pair : challenges) {
            String[] keyValue = pair.split("=");
            challengeMap.put(keyValue[0].replaceAll("\"", ""), keyValue[1].replaceAll("\"", ""));
        }
        return challengeMap;
    }

    private static boolean isValidChallenge(String authenticateHeader, String authChallengePrefix) {
        return authenticateHeader != null && !authenticateHeader.isEmpty() && authenticateHeader.toLowerCase().startsWith(authChallengePrefix.toLowerCase());
    }

    public abstract String doAuthenticate(String var1, String var2, String var3);
}

