/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceCall;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.AzureServiceResponseBuilder;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.RestClient;
import com.microsoft.azure.keyvault.models.BackupKeyResult;
import com.microsoft.azure.keyvault.models.CertificateAttributes;
import com.microsoft.azure.keyvault.models.CertificateBundle;
import com.microsoft.azure.keyvault.models.CertificateCreateParameters;
import com.microsoft.azure.keyvault.models.CertificateImportParameters;
import com.microsoft.azure.keyvault.models.CertificateIssuerItem;
import com.microsoft.azure.keyvault.models.CertificateIssuerSetParameters;
import com.microsoft.azure.keyvault.models.CertificateIssuerUpdateParameters;
import com.microsoft.azure.keyvault.models.CertificateItem;
import com.microsoft.azure.keyvault.models.CertificateMergeParameters;
import com.microsoft.azure.keyvault.models.CertificateOperation;
import com.microsoft.azure.keyvault.models.CertificateOperationUpdateParameter;
import com.microsoft.azure.keyvault.models.CertificatePolicy;
import com.microsoft.azure.keyvault.models.CertificateUpdateParameters;
import com.microsoft.azure.keyvault.models.Contacts;
import com.microsoft.azure.keyvault.models.IssuerAttributes;
import com.microsoft.azure.keyvault.models.IssuerBundle;
import com.microsoft.azure.keyvault.models.IssuerCredentials;
import com.microsoft.azure.keyvault.models.KeyAttributes;
import com.microsoft.azure.keyvault.models.KeyBundle;
import com.microsoft.azure.keyvault.models.KeyCreateParameters;
import com.microsoft.azure.keyvault.models.KeyImportParameters;
import com.microsoft.azure.keyvault.models.KeyItem;
import com.microsoft.azure.keyvault.models.KeyOperationResult;
import com.microsoft.azure.keyvault.models.KeyOperationsParameters;
import com.microsoft.azure.keyvault.models.KeyRestoreParameters;
import com.microsoft.azure.keyvault.models.KeySignParameters;
import com.microsoft.azure.keyvault.models.KeyUpdateParameters;
import com.microsoft.azure.keyvault.models.KeyVaultErrorException;
import com.microsoft.azure.keyvault.models.KeyVerifyParameters;
import com.microsoft.azure.keyvault.models.KeyVerifyResult;
import com.microsoft.azure.keyvault.models.OrganizationDetails;
import com.microsoft.azure.keyvault.models.PageImpl;
import com.microsoft.azure.keyvault.models.SecretAttributes;
import com.microsoft.azure.keyvault.models.SecretBundle;
import com.microsoft.azure.keyvault.models.SecretItem;
import com.microsoft.azure.keyvault.models.SecretSetParameters;
import com.microsoft.azure.keyvault.models.SecretUpdateParameters;
import com.microsoft.azure.keyvault.webkey.JsonWebKey;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyEncryptionAlgorithm;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyOperation;
import com.microsoft.azure.keyvault.webkey.JsonWebKeySignatureAlgorithm;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyType;
import com.microsoft.rest.RestException;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

final class KeyVaultClientImpl
extends AzureServiceClient {
    private KeyVaultClientService service;
    private AzureClient azureClient;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public KeyVaultClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public KeyVaultClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public KeyVaultClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    KeyVaultClientImpl(ServiceClientCredentials credentials) {
        this("https://{vaultBaseUrl}", credentials);
    }

    private KeyVaultClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        this(new RestClient.Builder().withBaseUrl(baseUrl).withCredentials(credentials).build());
    }

    KeyVaultClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2015-06-01";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.azureClient = new AzureClient((AzureServiceClient)this);
        this.initializeService();
    }

    public String userAgent() {
        return String.format("Azure-SDK-For-Java/%s (%s)", ((Object)((Object)this)).getClass().getPackage().getImplementationVersion(), "KeyVaultClient, 2015-06-01");
    }

    private void initializeService() {
        this.service = (KeyVaultClientService)this.restClient().retrofit().create(KeyVaultClientService.class);
    }

    public KeyBundle createKey(String vaultBaseUrl, String keyName, JsonWebKeyType kty) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (KeyBundle)((ServiceResponse)this.createKeyWithServiceResponseAsync(vaultBaseUrl, keyName, kty).toBlocking().single()).getBody();
    }

    public ServiceCall<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceCall.create(this.createKeyWithServiceResponseAsync(vaultBaseUrl, keyName, kty), serviceCallback);
    }

    public Observable<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty) {
        return this.createKeyWithServiceResponseAsync(vaultBaseUrl, keyName, kty).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<KeyBundle>> createKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (kty == null) {
            throw new IllegalArgumentException("Parameter kty is required and cannot be null.");
        }
        Object keySize = null;
        Object keyOps = null;
        Object keyAttributes = null;
        Object tags = null;
        KeyCreateParameters parameters = new KeyCreateParameters();
        parameters.withKty(kty);
        parameters.withKeySize(null);
        parameters.withKeyOps(null);
        parameters.withKeyAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.createKey(keyName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.createKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public KeyBundle createKey(String vaultBaseUrl, String keyName, JsonWebKeyType kty, Integer keySize, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (KeyBundle)((ServiceResponse)this.createKeyWithServiceResponseAsync(vaultBaseUrl, keyName, kty, keySize, keyOps, keyAttributes, tags).toBlocking().single()).getBody();
    }

    public ServiceCall<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty, Integer keySize, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceCall.create(this.createKeyWithServiceResponseAsync(vaultBaseUrl, keyName, kty, keySize, keyOps, keyAttributes, tags), serviceCallback);
    }

    public Observable<KeyBundle> createKeyAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty, Integer keySize, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags) {
        return this.createKeyWithServiceResponseAsync(vaultBaseUrl, keyName, kty, keySize, keyOps, keyAttributes, tags).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<KeyBundle>> createKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, JsonWebKeyType kty, Integer keySize, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (kty == null) {
            throw new IllegalArgumentException("Parameter kty is required and cannot be null.");
        }
        Validator.validate(keyOps);
        Validator.validate((Object)keyAttributes);
        Validator.validate(tags);
        KeyCreateParameters parameters = new KeyCreateParameters();
        parameters.withKty(kty);
        parameters.withKeySize(keySize);
        parameters.withKeyOps(keyOps);
        parameters.withKeyAttributes(keyAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.createKey(keyName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.createKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyBundle> createKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<KeyBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public KeyBundle importKey(String vaultBaseUrl, String keyName, JsonWebKey key) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (KeyBundle)((ServiceResponse)this.importKeyWithServiceResponseAsync(vaultBaseUrl, keyName, key).toBlocking().single()).getBody();
    }

    public ServiceCall<KeyBundle> importKeyAsync(String vaultBaseUrl, String keyName, JsonWebKey key, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceCall.create(this.importKeyWithServiceResponseAsync(vaultBaseUrl, keyName, key), serviceCallback);
    }

    public Observable<KeyBundle> importKeyAsync(String vaultBaseUrl, String keyName, JsonWebKey key) {
        return this.importKeyWithServiceResponseAsync(vaultBaseUrl, keyName, key).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<KeyBundle>> importKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, JsonWebKey key) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("Parameter key is required and cannot be null.");
        }
        Validator.validate((Object)key);
        Object hsm = null;
        Object keyAttributes = null;
        Object tags = null;
        KeyImportParameters parameters = new KeyImportParameters();
        parameters.withHsm(null);
        parameters.withKey(key);
        parameters.withKeyAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.importKey(keyName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.importKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public KeyBundle importKey(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (KeyBundle)((ServiceResponse)this.importKeyWithServiceResponseAsync(vaultBaseUrl, keyName, key, hsm, keyAttributes, tags).toBlocking().single()).getBody();
    }

    public ServiceCall<KeyBundle> importKeyAsync(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceCall.create(this.importKeyWithServiceResponseAsync(vaultBaseUrl, keyName, key, hsm, keyAttributes, tags), serviceCallback);
    }

    public Observable<KeyBundle> importKeyAsync(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags) {
        return this.importKeyWithServiceResponseAsync(vaultBaseUrl, keyName, key, hsm, keyAttributes, tags).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<KeyBundle>> importKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, JsonWebKey key, Boolean hsm, KeyAttributes keyAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (key == null) {
            throw new IllegalArgumentException("Parameter key is required and cannot be null.");
        }
        Validator.validate((Object)key);
        Validator.validate((Object)keyAttributes);
        Validator.validate(tags);
        KeyImportParameters parameters = new KeyImportParameters();
        parameters.withHsm(hsm);
        parameters.withKey(key);
        parameters.withKeyAttributes(keyAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.importKey(keyName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.importKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyBundle> importKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<KeyBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public KeyBundle deleteKey(String vaultBaseUrl, String keyName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (KeyBundle)((ServiceResponse)this.deleteKeyWithServiceResponseAsync(vaultBaseUrl, keyName).toBlocking().single()).getBody();
    }

    public ServiceCall<KeyBundle> deleteKeyAsync(String vaultBaseUrl, String keyName, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceCall.create(this.deleteKeyWithServiceResponseAsync(vaultBaseUrl, keyName), serviceCallback);
    }

    public Observable<KeyBundle> deleteKeyAsync(String vaultBaseUrl, String keyName) {
        return this.deleteKeyWithServiceResponseAsync(vaultBaseUrl, keyName).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<KeyBundle>> deleteKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.deleteKey(keyName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.deleteKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyBundle> deleteKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<KeyBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public KeyBundle updateKey(String vaultBaseUrl, String keyName, String keyVersion) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (KeyBundle)((ServiceResponse)this.updateKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion).toBlocking().single()).getBody();
    }

    public ServiceCall<KeyBundle> updateKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceCall.create(this.updateKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion), serviceCallback);
    }

    public Observable<KeyBundle> updateKeyAsync(String vaultBaseUrl, String keyName, String keyVersion) {
        return this.updateKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<KeyBundle>> updateKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Object keyOps = null;
        Object keyAttributes = null;
        Object tags = null;
        KeyUpdateParameters parameters = new KeyUpdateParameters();
        parameters.withKeyOps(null);
        parameters.withKeyAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateKey(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.updateKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public KeyBundle updateKey(String vaultBaseUrl, String keyName, String keyVersion, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (KeyBundle)((ServiceResponse)this.updateKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, keyOps, keyAttributes, tags).toBlocking().single()).getBody();
    }

    public ServiceCall<KeyBundle> updateKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceCall.create(this.updateKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, keyOps, keyAttributes, tags), serviceCallback);
    }

    public Observable<KeyBundle> updateKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags) {
        return this.updateKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, keyOps, keyAttributes, tags).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<KeyBundle>> updateKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, List<JsonWebKeyOperation> keyOps, KeyAttributes keyAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate(keyOps);
        Validator.validate((Object)keyAttributes);
        Validator.validate(tags);
        KeyUpdateParameters parameters = new KeyUpdateParameters();
        parameters.withKeyOps(keyOps);
        parameters.withKeyAttributes(keyAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateKey(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.updateKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyBundle> updateKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<KeyBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public KeyBundle getKey(String vaultBaseUrl, String keyName, String keyVersion) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (KeyBundle)((ServiceResponse)this.getKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion).toBlocking().single()).getBody();
    }

    public ServiceCall<KeyBundle> getKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceCall.create(this.getKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion), serviceCallback);
    }

    public Observable<KeyBundle> getKeyAsync(String vaultBaseUrl, String keyName, String keyVersion) {
        return this.getKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<KeyBundle>> getKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getKey(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.getKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyBundle> getKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<KeyBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public PagedList<KeyItem> getKeyVersions(String vaultBaseUrl, String keyName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getKeyVersionsSinglePageAsync(vaultBaseUrl, keyName).toBlocking().single();
        return new PagedList<KeyItem>((Page)response.getBody()){

            public Page<KeyItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getKeyVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<KeyItem>> getKeyVersionsAsync(String vaultBaseUrl, String keyName, ListOperationCallback<KeyItem> serviceCallback) {
        return AzureServiceCall.create(this.getKeyVersionsSinglePageAsync(vaultBaseUrl, keyName), (Func1)new Func1<String, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getKeyVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<KeyItem>> getKeyVersionsAsync(String vaultBaseUrl, String keyName) {
        return this.getKeyVersionsWithServiceResponseAsync(vaultBaseUrl, keyName).map((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Page<KeyItem>>(){

            public Page<KeyItem> call(ServiceResponse<Page<KeyItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeyVersionsWithServiceResponseAsync(String vaultBaseUrl, String keyName) {
        return this.getKeyVersionsSinglePageAsync(vaultBaseUrl, keyName).concatMap((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(ServiceResponse<Page<KeyItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getKeyVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeyVersionsSinglePageAsync(String vaultBaseUrl, String keyName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getKeyVersions(keyName, maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getKeyVersionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<KeyItem> getKeyVersions(String vaultBaseUrl, String keyName, Integer maxresults) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getKeyVersionsSinglePageAsync(vaultBaseUrl, keyName, maxresults).toBlocking().single();
        return new PagedList<KeyItem>((Page)response.getBody()){

            public Page<KeyItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getKeyVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<KeyItem>> getKeyVersionsAsync(String vaultBaseUrl, String keyName, Integer maxresults, ListOperationCallback<KeyItem> serviceCallback) {
        return AzureServiceCall.create(this.getKeyVersionsSinglePageAsync(vaultBaseUrl, keyName, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getKeyVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<KeyItem>> getKeyVersionsAsync(String vaultBaseUrl, String keyName, Integer maxresults) {
        return this.getKeyVersionsWithServiceResponseAsync(vaultBaseUrl, keyName, maxresults).map((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Page<KeyItem>>(){

            public Page<KeyItem> call(ServiceResponse<Page<KeyItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeyVersionsWithServiceResponseAsync(String vaultBaseUrl, String keyName, Integer maxresults) {
        return this.getKeyVersionsSinglePageAsync(vaultBaseUrl, keyName, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(ServiceResponse<Page<KeyItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getKeyVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeyVersionsSinglePageAsync(String vaultBaseUrl, String keyName, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getKeyVersions(keyName, maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getKeyVersionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<KeyItem>> getKeyVersionsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<PageImpl<KeyItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public PagedList<KeyItem> getKeys(String vaultBaseUrl) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getKeysSinglePageAsync(vaultBaseUrl).toBlocking().single();
        return new PagedList<KeyItem>((Page)response.getBody()){

            public Page<KeyItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getKeysNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<KeyItem>> getKeysAsync(String vaultBaseUrl, ListOperationCallback<KeyItem> serviceCallback) {
        return AzureServiceCall.create(this.getKeysSinglePageAsync(vaultBaseUrl), (Func1)new Func1<String, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getKeysNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<KeyItem>> getKeysAsync(String vaultBaseUrl) {
        return this.getKeysWithServiceResponseAsync(vaultBaseUrl).map((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Page<KeyItem>>(){

            public Page<KeyItem> call(ServiceResponse<Page<KeyItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeysWithServiceResponseAsync(String vaultBaseUrl) {
        return this.getKeysSinglePageAsync(vaultBaseUrl).concatMap((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(ServiceResponse<Page<KeyItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getKeysNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeysSinglePageAsync(String vaultBaseUrl) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getKeys(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<KeyItem> getKeys(String vaultBaseUrl, Integer maxresults) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getKeysSinglePageAsync(vaultBaseUrl, maxresults).toBlocking().single();
        return new PagedList<KeyItem>((Page)response.getBody()){

            public Page<KeyItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getKeysNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<KeyItem>> getKeysAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<KeyItem> serviceCallback) {
        return AzureServiceCall.create(this.getKeysSinglePageAsync(vaultBaseUrl, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getKeysNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<KeyItem>> getKeysAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getKeysWithServiceResponseAsync(vaultBaseUrl, maxresults).map((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Page<KeyItem>>(){

            public Page<KeyItem> call(ServiceResponse<Page<KeyItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeysWithServiceResponseAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getKeysSinglePageAsync(vaultBaseUrl, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(ServiceResponse<Page<KeyItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getKeysNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeysSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getKeys(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getKeysDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<KeyItem>> getKeysDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<PageImpl<KeyItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public BackupKeyResult backupKey(String vaultBaseUrl, String keyName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (BackupKeyResult)((ServiceResponse)this.backupKeyWithServiceResponseAsync(vaultBaseUrl, keyName).toBlocking().single()).getBody();
    }

    public ServiceCall<BackupKeyResult> backupKeyAsync(String vaultBaseUrl, String keyName, ServiceCallback<BackupKeyResult> serviceCallback) {
        return ServiceCall.create(this.backupKeyWithServiceResponseAsync(vaultBaseUrl, keyName), serviceCallback);
    }

    public Observable<BackupKeyResult> backupKeyAsync(String vaultBaseUrl, String keyName) {
        return this.backupKeyWithServiceResponseAsync(vaultBaseUrl, keyName).map((Func1)new Func1<ServiceResponse<BackupKeyResult>, BackupKeyResult>(){

            public BackupKeyResult call(ServiceResponse<BackupKeyResult> response) {
                return (BackupKeyResult)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<BackupKeyResult>> backupKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.backupKey(keyName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackupKeyResult>>>(){

            public Observable<ServiceResponse<BackupKeyResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.backupKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BackupKeyResult> backupKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<BackupKeyResult>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public KeyBundle restoreKey(String vaultBaseUrl, byte[] keyBundleBackup) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (KeyBundle)((ServiceResponse)this.restoreKeyWithServiceResponseAsync(vaultBaseUrl, keyBundleBackup).toBlocking().single()).getBody();
    }

    public ServiceCall<KeyBundle> restoreKeyAsync(String vaultBaseUrl, byte[] keyBundleBackup, ServiceCallback<KeyBundle> serviceCallback) {
        return ServiceCall.create(this.restoreKeyWithServiceResponseAsync(vaultBaseUrl, keyBundleBackup), serviceCallback);
    }

    public Observable<KeyBundle> restoreKeyAsync(String vaultBaseUrl, byte[] keyBundleBackup) {
        return this.restoreKeyWithServiceResponseAsync(vaultBaseUrl, keyBundleBackup).map((Func1)new Func1<ServiceResponse<KeyBundle>, KeyBundle>(){

            public KeyBundle call(ServiceResponse<KeyBundle> response) {
                return (KeyBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<KeyBundle>> restoreKeyWithServiceResponseAsync(String vaultBaseUrl, byte[] keyBundleBackup) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (keyBundleBackup == null) {
            throw new IllegalArgumentException("Parameter keyBundleBackup is required and cannot be null.");
        }
        KeyRestoreParameters parameters = new KeyRestoreParameters();
        parameters.withKeyBundleBackup(keyBundleBackup);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.restoreKey(this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyBundle>>>(){

            public Observable<ServiceResponse<KeyBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.restoreKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyBundle> restoreKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<KeyBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public KeyOperationResult encrypt(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (KeyOperationResult)((ServiceResponse)this.encryptWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).toBlocking().single()).getBody();
    }

    public ServiceCall<KeyOperationResult> encryptAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        return ServiceCall.create(this.encryptWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value), serviceCallback);
    }

    public Observable<KeyOperationResult> encryptAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        return this.encryptWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).map((Func1)new Func1<ServiceResponse<KeyOperationResult>, KeyOperationResult>(){

            public KeyOperationResult call(ServiceResponse<KeyOperationResult> response) {
                return (KeyOperationResult)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<KeyOperationResult>> encryptWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Parameter algorithm is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.withAlgorithm(algorithm);
        parameters.withValue(value);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.encrypt(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyOperationResult>>>(){

            public Observable<ServiceResponse<KeyOperationResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.encryptDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyOperationResult> encryptDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<KeyOperationResult>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public KeyOperationResult decrypt(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (KeyOperationResult)((ServiceResponse)this.decryptWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).toBlocking().single()).getBody();
    }

    public ServiceCall<KeyOperationResult> decryptAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        return ServiceCall.create(this.decryptWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value), serviceCallback);
    }

    public Observable<KeyOperationResult> decryptAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        return this.decryptWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).map((Func1)new Func1<ServiceResponse<KeyOperationResult>, KeyOperationResult>(){

            public KeyOperationResult call(ServiceResponse<KeyOperationResult> response) {
                return (KeyOperationResult)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<KeyOperationResult>> decryptWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Parameter algorithm is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.withAlgorithm(algorithm);
        parameters.withValue(value);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.decrypt(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyOperationResult>>>(){

            public Observable<ServiceResponse<KeyOperationResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.decryptDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyOperationResult> decryptDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<KeyOperationResult>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public KeyOperationResult sign(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (KeyOperationResult)((ServiceResponse)this.signWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).toBlocking().single()).getBody();
    }

    public ServiceCall<KeyOperationResult> signAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        return ServiceCall.create(this.signWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value), serviceCallback);
    }

    public Observable<KeyOperationResult> signAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value) {
        return this.signWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).map((Func1)new Func1<ServiceResponse<KeyOperationResult>, KeyOperationResult>(){

            public KeyOperationResult call(ServiceResponse<KeyOperationResult> response) {
                return (KeyOperationResult)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<KeyOperationResult>> signWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] value) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Parameter algorithm is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        KeySignParameters parameters = new KeySignParameters();
        parameters.withAlgorithm(algorithm);
        parameters.withValue(value);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.sign(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyOperationResult>>>(){

            public Observable<ServiceResponse<KeyOperationResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.signDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyOperationResult> signDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<KeyOperationResult>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public KeyVerifyResult verify(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (KeyVerifyResult)((ServiceResponse)this.verifyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, digest, signature).toBlocking().single()).getBody();
    }

    public ServiceCall<KeyVerifyResult> verifyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature, ServiceCallback<KeyVerifyResult> serviceCallback) {
        return ServiceCall.create(this.verifyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, digest, signature), serviceCallback);
    }

    public Observable<KeyVerifyResult> verifyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        return this.verifyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, digest, signature).map((Func1)new Func1<ServiceResponse<KeyVerifyResult>, KeyVerifyResult>(){

            public KeyVerifyResult call(ServiceResponse<KeyVerifyResult> response) {
                return (KeyVerifyResult)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<KeyVerifyResult>> verifyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Parameter algorithm is required and cannot be null.");
        }
        if (digest == null) {
            throw new IllegalArgumentException("Parameter digest is required and cannot be null.");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Parameter signature is required and cannot be null.");
        }
        KeyVerifyParameters parameters = new KeyVerifyParameters();
        parameters.withAlgorithm(algorithm);
        parameters.withDigest(digest);
        parameters.withSignature(signature);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.verify(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyVerifyResult>>>(){

            public Observable<ServiceResponse<KeyVerifyResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.verifyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyVerifyResult> verifyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<KeyVerifyResult>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public KeyOperationResult wrapKey(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (KeyOperationResult)((ServiceResponse)this.wrapKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).toBlocking().single()).getBody();
    }

    public ServiceCall<KeyOperationResult> wrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        return ServiceCall.create(this.wrapKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value), serviceCallback);
    }

    public Observable<KeyOperationResult> wrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        return this.wrapKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).map((Func1)new Func1<ServiceResponse<KeyOperationResult>, KeyOperationResult>(){

            public KeyOperationResult call(ServiceResponse<KeyOperationResult> response) {
                return (KeyOperationResult)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<KeyOperationResult>> wrapKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Parameter algorithm is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.withAlgorithm(algorithm);
        parameters.withValue(value);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.wrapKey(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyOperationResult>>>(){

            public Observable<ServiceResponse<KeyOperationResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.wrapKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyOperationResult> wrapKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<KeyOperationResult>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public KeyOperationResult unwrapKey(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (KeyOperationResult)((ServiceResponse)this.unwrapKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).toBlocking().single()).getBody();
    }

    public ServiceCall<KeyOperationResult> unwrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        return ServiceCall.create(this.unwrapKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value), serviceCallback);
    }

    public Observable<KeyOperationResult> unwrapKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        return this.unwrapKeyWithServiceResponseAsync(vaultBaseUrl, keyName, keyVersion, algorithm, value).map((Func1)new Func1<ServiceResponse<KeyOperationResult>, KeyOperationResult>(){

            public KeyOperationResult call(ServiceResponse<KeyOperationResult> response) {
                return (KeyOperationResult)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<KeyOperationResult>> unwrapKeyWithServiceResponseAsync(String vaultBaseUrl, String keyName, String keyVersion, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (keyName == null) {
            throw new IllegalArgumentException("Parameter keyName is required and cannot be null.");
        }
        if (keyVersion == null) {
            throw new IllegalArgumentException("Parameter keyVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Parameter algorithm is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        KeyOperationsParameters parameters = new KeyOperationsParameters();
        parameters.withAlgorithm(algorithm);
        parameters.withValue(value);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.unwrapKey(keyName, keyVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<KeyOperationResult>>>(){

            public Observable<ServiceResponse<KeyOperationResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.unwrapKeyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<KeyOperationResult> unwrapKeyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<KeyOperationResult>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public SecretBundle setSecret(String vaultBaseUrl, String secretName, String value) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (SecretBundle)((ServiceResponse)this.setSecretWithServiceResponseAsync(vaultBaseUrl, secretName, value).toBlocking().single()).getBody();
    }

    public ServiceCall<SecretBundle> setSecretAsync(String vaultBaseUrl, String secretName, String value, ServiceCallback<SecretBundle> serviceCallback) {
        return ServiceCall.create(this.setSecretWithServiceResponseAsync(vaultBaseUrl, secretName, value), serviceCallback);
    }

    public Observable<SecretBundle> setSecretAsync(String vaultBaseUrl, String secretName, String value) {
        return this.setSecretWithServiceResponseAsync(vaultBaseUrl, secretName, value).map((Func1)new Func1<ServiceResponse<SecretBundle>, SecretBundle>(){

            public SecretBundle call(ServiceResponse<SecretBundle> response) {
                return (SecretBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<SecretBundle>> setSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName, String value) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        Object tags = null;
        Object contentType = null;
        Object secretAttributes = null;
        SecretSetParameters parameters = new SecretSetParameters();
        parameters.withValue(value);
        parameters.withTags(null);
        parameters.withContentType(null);
        parameters.withSecretAttributes(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.setSecret(secretName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretBundle>>>(){

            public Observable<ServiceResponse<SecretBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.setSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public SecretBundle setSecret(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (SecretBundle)((ServiceResponse)this.setSecretWithServiceResponseAsync(vaultBaseUrl, secretName, value, tags, contentType, secretAttributes).toBlocking().single()).getBody();
    }

    public ServiceCall<SecretBundle> setSecretAsync(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes, ServiceCallback<SecretBundle> serviceCallback) {
        return ServiceCall.create(this.setSecretWithServiceResponseAsync(vaultBaseUrl, secretName, value, tags, contentType, secretAttributes), serviceCallback);
    }

    public Observable<SecretBundle> setSecretAsync(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes) {
        return this.setSecretWithServiceResponseAsync(vaultBaseUrl, secretName, value, tags, contentType, secretAttributes).map((Func1)new Func1<ServiceResponse<SecretBundle>, SecretBundle>(){

            public SecretBundle call(ServiceResponse<SecretBundle> response) {
                return (SecretBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<SecretBundle>> setSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName, String value, Map<String, String> tags, String contentType, SecretAttributes secretAttributes) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter value is required and cannot be null.");
        }
        Validator.validate(tags);
        Validator.validate((Object)secretAttributes);
        SecretSetParameters parameters = new SecretSetParameters();
        parameters.withValue(value);
        parameters.withTags(tags);
        parameters.withContentType(contentType);
        parameters.withSecretAttributes(secretAttributes);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.setSecret(secretName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretBundle>>>(){

            public Observable<ServiceResponse<SecretBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.setSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SecretBundle> setSecretDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<SecretBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public SecretBundle deleteSecret(String vaultBaseUrl, String secretName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (SecretBundle)((ServiceResponse)this.deleteSecretWithServiceResponseAsync(vaultBaseUrl, secretName).toBlocking().single()).getBody();
    }

    public ServiceCall<SecretBundle> deleteSecretAsync(String vaultBaseUrl, String secretName, ServiceCallback<SecretBundle> serviceCallback) {
        return ServiceCall.create(this.deleteSecretWithServiceResponseAsync(vaultBaseUrl, secretName), serviceCallback);
    }

    public Observable<SecretBundle> deleteSecretAsync(String vaultBaseUrl, String secretName) {
        return this.deleteSecretWithServiceResponseAsync(vaultBaseUrl, secretName).map((Func1)new Func1<ServiceResponse<SecretBundle>, SecretBundle>(){

            public SecretBundle call(ServiceResponse<SecretBundle> response) {
                return (SecretBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<SecretBundle>> deleteSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.deleteSecret(secretName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretBundle>>>(){

            public Observable<ServiceResponse<SecretBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.deleteSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SecretBundle> deleteSecretDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<SecretBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public SecretBundle updateSecret(String vaultBaseUrl, String secretName, String secretVersion) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (SecretBundle)((ServiceResponse)this.updateSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion).toBlocking().single()).getBody();
    }

    public ServiceCall<SecretBundle> updateSecretAsync(String vaultBaseUrl, String secretName, String secretVersion, ServiceCallback<SecretBundle> serviceCallback) {
        return ServiceCall.create(this.updateSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion), serviceCallback);
    }

    public Observable<SecretBundle> updateSecretAsync(String vaultBaseUrl, String secretName, String secretVersion) {
        return this.updateSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion).map((Func1)new Func1<ServiceResponse<SecretBundle>, SecretBundle>(){

            public SecretBundle call(ServiceResponse<SecretBundle> response) {
                return (SecretBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<SecretBundle>> updateSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName, String secretVersion) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (secretVersion == null) {
            throw new IllegalArgumentException("Parameter secretVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Object contentType = null;
        Object secretAttributes = null;
        Object tags = null;
        SecretUpdateParameters parameters = new SecretUpdateParameters();
        parameters.withContentType(null);
        parameters.withSecretAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateSecret(secretName, secretVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretBundle>>>(){

            public Observable<ServiceResponse<SecretBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.updateSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public SecretBundle updateSecret(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (SecretBundle)((ServiceResponse)this.updateSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion, contentType, secretAttributes, tags).toBlocking().single()).getBody();
    }

    public ServiceCall<SecretBundle> updateSecretAsync(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags, ServiceCallback<SecretBundle> serviceCallback) {
        return ServiceCall.create(this.updateSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion, contentType, secretAttributes, tags), serviceCallback);
    }

    public Observable<SecretBundle> updateSecretAsync(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        return this.updateSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion, contentType, secretAttributes, tags).map((Func1)new Func1<ServiceResponse<SecretBundle>, SecretBundle>(){

            public SecretBundle call(ServiceResponse<SecretBundle> response) {
                return (SecretBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<SecretBundle>> updateSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName, String secretVersion, String contentType, SecretAttributes secretAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (secretVersion == null) {
            throw new IllegalArgumentException("Parameter secretVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)secretAttributes);
        Validator.validate(tags);
        SecretUpdateParameters parameters = new SecretUpdateParameters();
        parameters.withContentType(contentType);
        parameters.withSecretAttributes(secretAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateSecret(secretName, secretVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretBundle>>>(){

            public Observable<ServiceResponse<SecretBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.updateSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SecretBundle> updateSecretDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<SecretBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public SecretBundle getSecret(String vaultBaseUrl, String secretName, String secretVersion) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (SecretBundle)((ServiceResponse)this.getSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion).toBlocking().single()).getBody();
    }

    public ServiceCall<SecretBundle> getSecretAsync(String vaultBaseUrl, String secretName, String secretVersion, ServiceCallback<SecretBundle> serviceCallback) {
        return ServiceCall.create(this.getSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion), serviceCallback);
    }

    public Observable<SecretBundle> getSecretAsync(String vaultBaseUrl, String secretName, String secretVersion) {
        return this.getSecretWithServiceResponseAsync(vaultBaseUrl, secretName, secretVersion).map((Func1)new Func1<ServiceResponse<SecretBundle>, SecretBundle>(){

            public SecretBundle call(ServiceResponse<SecretBundle> response) {
                return (SecretBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<SecretBundle>> getSecretWithServiceResponseAsync(String vaultBaseUrl, String secretName, String secretVersion) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (secretVersion == null) {
            throw new IllegalArgumentException("Parameter secretVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getSecret(secretName, secretVersion, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SecretBundle>>>(){

            public Observable<ServiceResponse<SecretBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.getSecretDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SecretBundle> getSecretDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<SecretBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public PagedList<SecretItem> getSecrets(String vaultBaseUrl) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getSecretsSinglePageAsync(vaultBaseUrl).toBlocking().single();
        return new PagedList<SecretItem>((Page)response.getBody()){

            public Page<SecretItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getSecretsNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<SecretItem>> getSecretsAsync(String vaultBaseUrl, ListOperationCallback<SecretItem> serviceCallback) {
        return AzureServiceCall.create(this.getSecretsSinglePageAsync(vaultBaseUrl), (Func1)new Func1<String, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getSecretsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SecretItem>> getSecretsAsync(String vaultBaseUrl) {
        return this.getSecretsWithServiceResponseAsync(vaultBaseUrl).map((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Page<SecretItem>>(){

            public Page<SecretItem> call(ServiceResponse<Page<SecretItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretsWithServiceResponseAsync(String vaultBaseUrl) {
        return this.getSecretsSinglePageAsync(vaultBaseUrl).concatMap((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(ServiceResponse<Page<SecretItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getSecretsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretsSinglePageAsync(String vaultBaseUrl) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getSecrets(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getSecretsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<SecretItem> getSecrets(String vaultBaseUrl, Integer maxresults) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getSecretsSinglePageAsync(vaultBaseUrl, maxresults).toBlocking().single();
        return new PagedList<SecretItem>((Page)response.getBody()){

            public Page<SecretItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getSecretsNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<SecretItem>> getSecretsAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<SecretItem> serviceCallback) {
        return AzureServiceCall.create(this.getSecretsSinglePageAsync(vaultBaseUrl, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getSecretsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SecretItem>> getSecretsAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getSecretsWithServiceResponseAsync(vaultBaseUrl, maxresults).map((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Page<SecretItem>>(){

            public Page<SecretItem> call(ServiceResponse<Page<SecretItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretsWithServiceResponseAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getSecretsSinglePageAsync(vaultBaseUrl, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(ServiceResponse<Page<SecretItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getSecretsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretsSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getSecrets(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getSecretsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SecretItem>> getSecretsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<PageImpl<SecretItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public PagedList<SecretItem> getSecretVersions(String vaultBaseUrl, String secretName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getSecretVersionsSinglePageAsync(vaultBaseUrl, secretName).toBlocking().single();
        return new PagedList<SecretItem>((Page)response.getBody()){

            public Page<SecretItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getSecretVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<SecretItem>> getSecretVersionsAsync(String vaultBaseUrl, String secretName, ListOperationCallback<SecretItem> serviceCallback) {
        return AzureServiceCall.create(this.getSecretVersionsSinglePageAsync(vaultBaseUrl, secretName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getSecretVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SecretItem>> getSecretVersionsAsync(String vaultBaseUrl, String secretName) {
        return this.getSecretVersionsWithServiceResponseAsync(vaultBaseUrl, secretName).map((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Page<SecretItem>>(){

            public Page<SecretItem> call(ServiceResponse<Page<SecretItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretVersionsWithServiceResponseAsync(String vaultBaseUrl, String secretName) {
        return this.getSecretVersionsSinglePageAsync(vaultBaseUrl, secretName).concatMap((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(ServiceResponse<Page<SecretItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getSecretVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretVersionsSinglePageAsync(String vaultBaseUrl, String secretName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getSecretVersions(secretName, maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getSecretVersionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<SecretItem> getSecretVersions(String vaultBaseUrl, String secretName, Integer maxresults) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getSecretVersionsSinglePageAsync(vaultBaseUrl, secretName, maxresults).toBlocking().single();
        return new PagedList<SecretItem>((Page)response.getBody()){

            public Page<SecretItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getSecretVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<SecretItem>> getSecretVersionsAsync(String vaultBaseUrl, String secretName, Integer maxresults, ListOperationCallback<SecretItem> serviceCallback) {
        return AzureServiceCall.create(this.getSecretVersionsSinglePageAsync(vaultBaseUrl, secretName, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getSecretVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SecretItem>> getSecretVersionsAsync(String vaultBaseUrl, String secretName, Integer maxresults) {
        return this.getSecretVersionsWithServiceResponseAsync(vaultBaseUrl, secretName, maxresults).map((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Page<SecretItem>>(){

            public Page<SecretItem> call(ServiceResponse<Page<SecretItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretVersionsWithServiceResponseAsync(String vaultBaseUrl, String secretName, Integer maxresults) {
        return this.getSecretVersionsSinglePageAsync(vaultBaseUrl, secretName, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(ServiceResponse<Page<SecretItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getSecretVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretVersionsSinglePageAsync(String vaultBaseUrl, String secretName, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (secretName == null) {
            throw new IllegalArgumentException("Parameter secretName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getSecretVersions(secretName, maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getSecretVersionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SecretItem>> getSecretVersionsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<PageImpl<SecretItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public PagedList<CertificateItem> getCertificates(String vaultBaseUrl) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getCertificatesSinglePageAsync(vaultBaseUrl).toBlocking().single();
        return new PagedList<CertificateItem>((Page)response.getBody()){

            public Page<CertificateItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<CertificateItem>> getCertificatesAsync(String vaultBaseUrl, ListOperationCallback<CertificateItem> serviceCallback) {
        return AzureServiceCall.create(this.getCertificatesSinglePageAsync(vaultBaseUrl), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getCertificatesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CertificateItem>> getCertificatesAsync(String vaultBaseUrl) {
        return this.getCertificatesWithServiceResponseAsync(vaultBaseUrl).map((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Page<CertificateItem>>(){

            public Page<CertificateItem> call(ServiceResponse<Page<CertificateItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificatesWithServiceResponseAsync(String vaultBaseUrl) {
        return this.getCertificatesSinglePageAsync(vaultBaseUrl).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(ServiceResponse<Page<CertificateItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getCertificatesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificatesSinglePageAsync(String vaultBaseUrl) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificates(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getCertificatesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<CertificateItem> getCertificates(String vaultBaseUrl, Integer maxresults) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getCertificatesSinglePageAsync(vaultBaseUrl, maxresults).toBlocking().single();
        return new PagedList<CertificateItem>((Page)response.getBody()){

            public Page<CertificateItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<CertificateItem>> getCertificatesAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<CertificateItem> serviceCallback) {
        return AzureServiceCall.create(this.getCertificatesSinglePageAsync(vaultBaseUrl, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getCertificatesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CertificateItem>> getCertificatesAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getCertificatesWithServiceResponseAsync(vaultBaseUrl, maxresults).map((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Page<CertificateItem>>(){

            public Page<CertificateItem> call(ServiceResponse<Page<CertificateItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificatesWithServiceResponseAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getCertificatesSinglePageAsync(vaultBaseUrl, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(ServiceResponse<Page<CertificateItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getCertificatesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificatesSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificates(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getCertificatesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CertificateItem>> getCertificatesDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<PageImpl<CertificateItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public CertificateBundle deleteCertificate(String vaultBaseUrl, String certificateName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (CertificateBundle)((ServiceResponse)this.deleteCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName).toBlocking().single()).getBody();
    }

    public ServiceCall<CertificateBundle> deleteCertificateAsync(String vaultBaseUrl, String certificateName, ServiceCallback<CertificateBundle> serviceCallback) {
        return ServiceCall.create(this.deleteCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName), serviceCallback);
    }

    public Observable<CertificateBundle> deleteCertificateAsync(String vaultBaseUrl, String certificateName) {
        return this.deleteCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName).map((Func1)new Func1<ServiceResponse<CertificateBundle>, CertificateBundle>(){

            public CertificateBundle call(ServiceResponse<CertificateBundle> response) {
                return (CertificateBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<CertificateBundle>> deleteCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.deleteCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateBundle>>>(){

            public Observable<ServiceResponse<CertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.deleteCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateBundle> deleteCertificateDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<CertificateBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public Contacts setCertificateContacts(String vaultBaseUrl, Contacts contacts) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (Contacts)((ServiceResponse)this.setCertificateContactsWithServiceResponseAsync(vaultBaseUrl, contacts).toBlocking().single()).getBody();
    }

    public ServiceCall<Contacts> setCertificateContactsAsync(String vaultBaseUrl, Contacts contacts, ServiceCallback<Contacts> serviceCallback) {
        return ServiceCall.create(this.setCertificateContactsWithServiceResponseAsync(vaultBaseUrl, contacts), serviceCallback);
    }

    public Observable<Contacts> setCertificateContactsAsync(String vaultBaseUrl, Contacts contacts) {
        return this.setCertificateContactsWithServiceResponseAsync(vaultBaseUrl, contacts).map((Func1)new Func1<ServiceResponse<Contacts>, Contacts>(){

            public Contacts call(ServiceResponse<Contacts> response) {
                return (Contacts)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Contacts>> setCertificateContactsWithServiceResponseAsync(String vaultBaseUrl, Contacts contacts) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (contacts == null) {
            throw new IllegalArgumentException("Parameter contacts is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)contacts);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.setCertificateContacts(contacts, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Contacts>>>(){

            public Observable<ServiceResponse<Contacts>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.setCertificateContactsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Contacts> setCertificateContactsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<Contacts>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public Contacts getCertificateContacts(String vaultBaseUrl) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (Contacts)((ServiceResponse)this.getCertificateContactsWithServiceResponseAsync(vaultBaseUrl).toBlocking().single()).getBody();
    }

    public ServiceCall<Contacts> getCertificateContactsAsync(String vaultBaseUrl, ServiceCallback<Contacts> serviceCallback) {
        return ServiceCall.create(this.getCertificateContactsWithServiceResponseAsync(vaultBaseUrl), serviceCallback);
    }

    public Observable<Contacts> getCertificateContactsAsync(String vaultBaseUrl) {
        return this.getCertificateContactsWithServiceResponseAsync(vaultBaseUrl).map((Func1)new Func1<ServiceResponse<Contacts>, Contacts>(){

            public Contacts call(ServiceResponse<Contacts> response) {
                return (Contacts)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Contacts>> getCertificateContactsWithServiceResponseAsync(String vaultBaseUrl) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificateContacts(this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Contacts>>>(){

            public Observable<ServiceResponse<Contacts>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.getCertificateContactsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Contacts> getCertificateContactsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<Contacts>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public Contacts deleteCertificateContacts(String vaultBaseUrl) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (Contacts)((ServiceResponse)this.deleteCertificateContactsWithServiceResponseAsync(vaultBaseUrl).toBlocking().single()).getBody();
    }

    public ServiceCall<Contacts> deleteCertificateContactsAsync(String vaultBaseUrl, ServiceCallback<Contacts> serviceCallback) {
        return ServiceCall.create(this.deleteCertificateContactsWithServiceResponseAsync(vaultBaseUrl), serviceCallback);
    }

    public Observable<Contacts> deleteCertificateContactsAsync(String vaultBaseUrl) {
        return this.deleteCertificateContactsWithServiceResponseAsync(vaultBaseUrl).map((Func1)new Func1<ServiceResponse<Contacts>, Contacts>(){

            public Contacts call(ServiceResponse<Contacts> response) {
                return (Contacts)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Contacts>> deleteCertificateContactsWithServiceResponseAsync(String vaultBaseUrl) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.deleteCertificateContacts(this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Contacts>>>(){

            public Observable<ServiceResponse<Contacts>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.deleteCertificateContactsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Contacts> deleteCertificateContactsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<Contacts>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public PagedList<CertificateIssuerItem> getCertificateIssuers(String vaultBaseUrl) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getCertificateIssuersSinglePageAsync(vaultBaseUrl).toBlocking().single();
        return new PagedList<CertificateIssuerItem>((Page)response.getBody()){

            public Page<CertificateIssuerItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getCertificateIssuersNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<CertificateIssuerItem>> getCertificateIssuersAsync(String vaultBaseUrl, ListOperationCallback<CertificateIssuerItem> serviceCallback) {
        return AzureServiceCall.create(this.getCertificateIssuersSinglePageAsync(vaultBaseUrl), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getCertificateIssuersNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CertificateIssuerItem>> getCertificateIssuersAsync(String vaultBaseUrl) {
        return this.getCertificateIssuersWithServiceResponseAsync(vaultBaseUrl).map((Func1)new Func1<ServiceResponse<Page<CertificateIssuerItem>>, Page<CertificateIssuerItem>>(){

            public Page<CertificateIssuerItem> call(ServiceResponse<Page<CertificateIssuerItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateIssuerItem>>> getCertificateIssuersWithServiceResponseAsync(String vaultBaseUrl) {
        return this.getCertificateIssuersSinglePageAsync(vaultBaseUrl).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateIssuerItem>>, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(ServiceResponse<Page<CertificateIssuerItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getCertificateIssuersNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateIssuerItem>>> getCertificateIssuersSinglePageAsync(String vaultBaseUrl) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificateIssuers(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getCertificateIssuersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<CertificateIssuerItem> getCertificateIssuers(String vaultBaseUrl, Integer maxresults) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getCertificateIssuersSinglePageAsync(vaultBaseUrl, maxresults).toBlocking().single();
        return new PagedList<CertificateIssuerItem>((Page)response.getBody()){

            public Page<CertificateIssuerItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getCertificateIssuersNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<CertificateIssuerItem>> getCertificateIssuersAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<CertificateIssuerItem> serviceCallback) {
        return AzureServiceCall.create(this.getCertificateIssuersSinglePageAsync(vaultBaseUrl, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getCertificateIssuersNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CertificateIssuerItem>> getCertificateIssuersAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getCertificateIssuersWithServiceResponseAsync(vaultBaseUrl, maxresults).map((Func1)new Func1<ServiceResponse<Page<CertificateIssuerItem>>, Page<CertificateIssuerItem>>(){

            public Page<CertificateIssuerItem> call(ServiceResponse<Page<CertificateIssuerItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateIssuerItem>>> getCertificateIssuersWithServiceResponseAsync(String vaultBaseUrl, Integer maxresults) {
        return this.getCertificateIssuersSinglePageAsync(vaultBaseUrl, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateIssuerItem>>, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(ServiceResponse<Page<CertificateIssuerItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getCertificateIssuersNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateIssuerItem>>> getCertificateIssuersSinglePageAsync(String vaultBaseUrl, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificateIssuers(maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getCertificateIssuersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CertificateIssuerItem>> getCertificateIssuersDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<PageImpl<CertificateIssuerItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public IssuerBundle setCertificateIssuer(String vaultBaseUrl, String issuerName, String provider) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (IssuerBundle)((ServiceResponse)this.setCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider).toBlocking().single()).getBody();
    }

    public ServiceCall<IssuerBundle> setCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, ServiceCallback<IssuerBundle> serviceCallback) {
        return ServiceCall.create(this.setCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider), serviceCallback);
    }

    public Observable<IssuerBundle> setCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider) {
        return this.setCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider).map((Func1)new Func1<ServiceResponse<IssuerBundle>, IssuerBundle>(){

            public IssuerBundle call(ServiceResponse<IssuerBundle> response) {
                return (IssuerBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<IssuerBundle>> setCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName, String provider) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (issuerName == null) {
            throw new IllegalArgumentException("Parameter issuerName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Parameter provider is required and cannot be null.");
        }
        Object credentials = null;
        Object organizationDetails = null;
        Object attributes = null;
        CertificateIssuerSetParameters parameter = new CertificateIssuerSetParameters();
        parameter.withProvider(provider);
        parameter.withCredentials(null);
        parameter.withOrganizationDetails(null);
        parameter.withAttributes(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.setCertificateIssuer(issuerName, this.apiVersion(), this.acceptLanguage(), parameter, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IssuerBundle>>>(){

            public Observable<ServiceResponse<IssuerBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.setCertificateIssuerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public IssuerBundle setCertificateIssuer(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (IssuerBundle)((ServiceResponse)this.setCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes).toBlocking().single()).getBody();
    }

    public ServiceCall<IssuerBundle> setCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes, ServiceCallback<IssuerBundle> serviceCallback) {
        return ServiceCall.create(this.setCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes), serviceCallback);
    }

    public Observable<IssuerBundle> setCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        return this.setCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes).map((Func1)new Func1<ServiceResponse<IssuerBundle>, IssuerBundle>(){

            public IssuerBundle call(ServiceResponse<IssuerBundle> response) {
                return (IssuerBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<IssuerBundle>> setCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (issuerName == null) {
            throw new IllegalArgumentException("Parameter issuerName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Parameter provider is required and cannot be null.");
        }
        Validator.validate((Object)credentials);
        Validator.validate((Object)organizationDetails);
        Validator.validate((Object)attributes);
        CertificateIssuerSetParameters parameter = new CertificateIssuerSetParameters();
        parameter.withProvider(provider);
        parameter.withCredentials(credentials);
        parameter.withOrganizationDetails(organizationDetails);
        parameter.withAttributes(attributes);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.setCertificateIssuer(issuerName, this.apiVersion(), this.acceptLanguage(), parameter, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IssuerBundle>>>(){

            public Observable<ServiceResponse<IssuerBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.setCertificateIssuerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<IssuerBundle> setCertificateIssuerDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<IssuerBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public IssuerBundle updateCertificateIssuer(String vaultBaseUrl, String issuerName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (IssuerBundle)((ServiceResponse)this.updateCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName).toBlocking().single()).getBody();
    }

    public ServiceCall<IssuerBundle> updateCertificateIssuerAsync(String vaultBaseUrl, String issuerName, ServiceCallback<IssuerBundle> serviceCallback) {
        return ServiceCall.create(this.updateCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName), serviceCallback);
    }

    public Observable<IssuerBundle> updateCertificateIssuerAsync(String vaultBaseUrl, String issuerName) {
        return this.updateCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName).map((Func1)new Func1<ServiceResponse<IssuerBundle>, IssuerBundle>(){

            public IssuerBundle call(ServiceResponse<IssuerBundle> response) {
                return (IssuerBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<IssuerBundle>> updateCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (issuerName == null) {
            throw new IllegalArgumentException("Parameter issuerName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Object provider = null;
        Object credentials = null;
        Object organizationDetails = null;
        Object attributes = null;
        CertificateIssuerUpdateParameters parameter = new CertificateIssuerUpdateParameters();
        parameter.withProvider(null);
        parameter.withCredentials(null);
        parameter.withOrganizationDetails(null);
        parameter.withAttributes(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateCertificateIssuer(issuerName, this.apiVersion(), this.acceptLanguage(), parameter, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IssuerBundle>>>(){

            public Observable<ServiceResponse<IssuerBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.updateCertificateIssuerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public IssuerBundle updateCertificateIssuer(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (IssuerBundle)((ServiceResponse)this.updateCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes).toBlocking().single()).getBody();
    }

    public ServiceCall<IssuerBundle> updateCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes, ServiceCallback<IssuerBundle> serviceCallback) {
        return ServiceCall.create(this.updateCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes), serviceCallback);
    }

    public Observable<IssuerBundle> updateCertificateIssuerAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        return this.updateCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName, provider, credentials, organizationDetails, attributes).map((Func1)new Func1<ServiceResponse<IssuerBundle>, IssuerBundle>(){

            public IssuerBundle call(ServiceResponse<IssuerBundle> response) {
                return (IssuerBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<IssuerBundle>> updateCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName, String provider, IssuerCredentials credentials, OrganizationDetails organizationDetails, IssuerAttributes attributes) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (issuerName == null) {
            throw new IllegalArgumentException("Parameter issuerName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)credentials);
        Validator.validate((Object)organizationDetails);
        Validator.validate((Object)attributes);
        CertificateIssuerUpdateParameters parameter = new CertificateIssuerUpdateParameters();
        parameter.withProvider(provider);
        parameter.withCredentials(credentials);
        parameter.withOrganizationDetails(organizationDetails);
        parameter.withAttributes(attributes);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateCertificateIssuer(issuerName, this.apiVersion(), this.acceptLanguage(), parameter, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IssuerBundle>>>(){

            public Observable<ServiceResponse<IssuerBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.updateCertificateIssuerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<IssuerBundle> updateCertificateIssuerDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<IssuerBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public IssuerBundle getCertificateIssuer(String vaultBaseUrl, String issuerName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (IssuerBundle)((ServiceResponse)this.getCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName).toBlocking().single()).getBody();
    }

    public ServiceCall<IssuerBundle> getCertificateIssuerAsync(String vaultBaseUrl, String issuerName, ServiceCallback<IssuerBundle> serviceCallback) {
        return ServiceCall.create(this.getCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName), serviceCallback);
    }

    public Observable<IssuerBundle> getCertificateIssuerAsync(String vaultBaseUrl, String issuerName) {
        return this.getCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName).map((Func1)new Func1<ServiceResponse<IssuerBundle>, IssuerBundle>(){

            public IssuerBundle call(ServiceResponse<IssuerBundle> response) {
                return (IssuerBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<IssuerBundle>> getCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (issuerName == null) {
            throw new IllegalArgumentException("Parameter issuerName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificateIssuer(issuerName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IssuerBundle>>>(){

            public Observable<ServiceResponse<IssuerBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.getCertificateIssuerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<IssuerBundle> getCertificateIssuerDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<IssuerBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public IssuerBundle deleteCertificateIssuer(String vaultBaseUrl, String issuerName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (IssuerBundle)((ServiceResponse)this.deleteCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName).toBlocking().single()).getBody();
    }

    public ServiceCall<IssuerBundle> deleteCertificateIssuerAsync(String vaultBaseUrl, String issuerName, ServiceCallback<IssuerBundle> serviceCallback) {
        return ServiceCall.create(this.deleteCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName), serviceCallback);
    }

    public Observable<IssuerBundle> deleteCertificateIssuerAsync(String vaultBaseUrl, String issuerName) {
        return this.deleteCertificateIssuerWithServiceResponseAsync(vaultBaseUrl, issuerName).map((Func1)new Func1<ServiceResponse<IssuerBundle>, IssuerBundle>(){

            public IssuerBundle call(ServiceResponse<IssuerBundle> response) {
                return (IssuerBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<IssuerBundle>> deleteCertificateIssuerWithServiceResponseAsync(String vaultBaseUrl, String issuerName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (issuerName == null) {
            throw new IllegalArgumentException("Parameter issuerName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.deleteCertificateIssuer(issuerName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IssuerBundle>>>(){

            public Observable<ServiceResponse<IssuerBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.deleteCertificateIssuerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<IssuerBundle> deleteCertificateIssuerDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<IssuerBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public CertificateOperation createCertificate(String vaultBaseUrl, String certificateName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (CertificateOperation)((ServiceResponse)this.createCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName).toBlocking().single()).getBody();
    }

    public ServiceCall<CertificateOperation> createCertificateAsync(String vaultBaseUrl, String certificateName, ServiceCallback<CertificateOperation> serviceCallback) {
        return ServiceCall.create(this.createCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName), serviceCallback);
    }

    public Observable<CertificateOperation> createCertificateAsync(String vaultBaseUrl, String certificateName) {
        return this.createCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName).map((Func1)new Func1<ServiceResponse<CertificateOperation>, CertificateOperation>(){

            public CertificateOperation call(ServiceResponse<CertificateOperation> response) {
                return (CertificateOperation)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<CertificateOperation>> createCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Object certificatePolicy = null;
        Object certificateAttributes = null;
        Object tags = null;
        CertificateCreateParameters parameters = new CertificateCreateParameters();
        parameters.withCertificatePolicy(null);
        parameters.withCertificateAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.createCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateOperation>>>(){

            public Observable<ServiceResponse<CertificateOperation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.createCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public CertificateOperation createCertificate(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (CertificateOperation)((ServiceResponse)this.createCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificatePolicy, certificateAttributes, tags).toBlocking().single()).getBody();
    }

    public ServiceCall<CertificateOperation> createCertificateAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, ServiceCallback<CertificateOperation> serviceCallback) {
        return ServiceCall.create(this.createCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificatePolicy, certificateAttributes, tags), serviceCallback);
    }

    public Observable<CertificateOperation> createCertificateAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return this.createCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificatePolicy, certificateAttributes, tags).map((Func1)new Func1<ServiceResponse<CertificateOperation>, CertificateOperation>(){

            public CertificateOperation call(ServiceResponse<CertificateOperation> response) {
                return (CertificateOperation)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<CertificateOperation>> createCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)certificatePolicy);
        Validator.validate((Object)certificateAttributes);
        Validator.validate(tags);
        CertificateCreateParameters parameters = new CertificateCreateParameters();
        parameters.withCertificatePolicy(certificatePolicy);
        parameters.withCertificateAttributes(certificateAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.createCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateOperation>>>(){

            public Observable<ServiceResponse<CertificateOperation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.createCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateOperation> createCertificateDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(202, new TypeToken<CertificateOperation>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public CertificateBundle importCertificate(String vaultBaseUrl, String certificateName, String base64EncodedCertificate) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (CertificateBundle)((ServiceResponse)this.importCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, base64EncodedCertificate).toBlocking().single()).getBody();
    }

    public ServiceCall<CertificateBundle> importCertificateAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, ServiceCallback<CertificateBundle> serviceCallback) {
        return ServiceCall.create(this.importCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, base64EncodedCertificate), serviceCallback);
    }

    public Observable<CertificateBundle> importCertificateAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate) {
        return this.importCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, base64EncodedCertificate).map((Func1)new Func1<ServiceResponse<CertificateBundle>, CertificateBundle>(){

            public CertificateBundle call(ServiceResponse<CertificateBundle> response) {
                return (CertificateBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<CertificateBundle>> importCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (base64EncodedCertificate == null) {
            throw new IllegalArgumentException("Parameter base64EncodedCertificate is required and cannot be null.");
        }
        Object password = null;
        Object certificatePolicy = null;
        Object certificateAttributes = null;
        Object tags = null;
        CertificateImportParameters parameters = new CertificateImportParameters();
        parameters.withBase64EncodedCertificate(base64EncodedCertificate);
        parameters.withPassword(null);
        parameters.withCertificatePolicy(null);
        parameters.withCertificateAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.importCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateBundle>>>(){

            public Observable<ServiceResponse<CertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.importCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public CertificateBundle importCertificate(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (CertificateBundle)((ServiceResponse)this.importCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, base64EncodedCertificate, password, certificatePolicy, certificateAttributes, tags).toBlocking().single()).getBody();
    }

    public ServiceCall<CertificateBundle> importCertificateAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, ServiceCallback<CertificateBundle> serviceCallback) {
        return ServiceCall.create(this.importCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, base64EncodedCertificate, password, certificatePolicy, certificateAttributes, tags), serviceCallback);
    }

    public Observable<CertificateBundle> importCertificateAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return this.importCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, base64EncodedCertificate, password, certificatePolicy, certificateAttributes, tags).map((Func1)new Func1<ServiceResponse<CertificateBundle>, CertificateBundle>(){

            public CertificateBundle call(ServiceResponse<CertificateBundle> response) {
                return (CertificateBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<CertificateBundle>> importCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, String base64EncodedCertificate, String password, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (base64EncodedCertificate == null) {
            throw new IllegalArgumentException("Parameter base64EncodedCertificate is required and cannot be null.");
        }
        Validator.validate((Object)certificatePolicy);
        Validator.validate((Object)certificateAttributes);
        Validator.validate(tags);
        CertificateImportParameters parameters = new CertificateImportParameters();
        parameters.withBase64EncodedCertificate(base64EncodedCertificate);
        parameters.withPassword(password);
        parameters.withCertificatePolicy(certificatePolicy);
        parameters.withCertificateAttributes(certificateAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.importCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateBundle>>>(){

            public Observable<ServiceResponse<CertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.importCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateBundle> importCertificateDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<CertificateBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public PagedList<CertificateItem> getCertificateVersions(String vaultBaseUrl, String certificateName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getCertificateVersionsSinglePageAsync(vaultBaseUrl, certificateName).toBlocking().single();
        return new PagedList<CertificateItem>((Page)response.getBody()){

            public Page<CertificateItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getCertificateVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<CertificateItem>> getCertificateVersionsAsync(String vaultBaseUrl, String certificateName, ListOperationCallback<CertificateItem> serviceCallback) {
        return AzureServiceCall.create(this.getCertificateVersionsSinglePageAsync(vaultBaseUrl, certificateName), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getCertificateVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CertificateItem>> getCertificateVersionsAsync(String vaultBaseUrl, String certificateName) {
        return this.getCertificateVersionsWithServiceResponseAsync(vaultBaseUrl, certificateName).map((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Page<CertificateItem>>(){

            public Page<CertificateItem> call(ServiceResponse<Page<CertificateItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificateVersionsWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        return this.getCertificateVersionsSinglePageAsync(vaultBaseUrl, certificateName).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(ServiceResponse<Page<CertificateItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getCertificateVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificateVersionsSinglePageAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificateVersions(certificateName, maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getCertificateVersionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<CertificateItem> getCertificateVersions(String vaultBaseUrl, String certificateName, Integer maxresults) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getCertificateVersionsSinglePageAsync(vaultBaseUrl, certificateName, maxresults).toBlocking().single();
        return new PagedList<CertificateItem>((Page)response.getBody()){

            public Page<CertificateItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getCertificateVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<CertificateItem>> getCertificateVersionsAsync(String vaultBaseUrl, String certificateName, Integer maxresults, ListOperationCallback<CertificateItem> serviceCallback) {
        return AzureServiceCall.create(this.getCertificateVersionsSinglePageAsync(vaultBaseUrl, certificateName, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getCertificateVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CertificateItem>> getCertificateVersionsAsync(String vaultBaseUrl, String certificateName, Integer maxresults) {
        return this.getCertificateVersionsWithServiceResponseAsync(vaultBaseUrl, certificateName, maxresults).map((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Page<CertificateItem>>(){

            public Page<CertificateItem> call(ServiceResponse<Page<CertificateItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificateVersionsWithServiceResponseAsync(String vaultBaseUrl, String certificateName, Integer maxresults) {
        return this.getCertificateVersionsSinglePageAsync(vaultBaseUrl, certificateName, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(ServiceResponse<Page<CertificateItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getCertificateVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificateVersionsSinglePageAsync(String vaultBaseUrl, String certificateName, Integer maxresults) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificateVersions(certificateName, maxresults, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getCertificateVersionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CertificateItem>> getCertificateVersionsDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<PageImpl<CertificateItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public CertificatePolicy getCertificatePolicy(String vaultBaseUrl, String certificateName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (CertificatePolicy)((ServiceResponse)this.getCertificatePolicyWithServiceResponseAsync(vaultBaseUrl, certificateName).toBlocking().single()).getBody();
    }

    public ServiceCall<CertificatePolicy> getCertificatePolicyAsync(String vaultBaseUrl, String certificateName, ServiceCallback<CertificatePolicy> serviceCallback) {
        return ServiceCall.create(this.getCertificatePolicyWithServiceResponseAsync(vaultBaseUrl, certificateName), serviceCallback);
    }

    public Observable<CertificatePolicy> getCertificatePolicyAsync(String vaultBaseUrl, String certificateName) {
        return this.getCertificatePolicyWithServiceResponseAsync(vaultBaseUrl, certificateName).map((Func1)new Func1<ServiceResponse<CertificatePolicy>, CertificatePolicy>(){

            public CertificatePolicy call(ServiceResponse<CertificatePolicy> response) {
                return (CertificatePolicy)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<CertificatePolicy>> getCertificatePolicyWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificatePolicy(certificateName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificatePolicy>>>(){

            public Observable<ServiceResponse<CertificatePolicy>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.getCertificatePolicyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificatePolicy> getCertificatePolicyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<CertificatePolicy>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public CertificatePolicy updateCertificatePolicy(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (CertificatePolicy)((ServiceResponse)this.updateCertificatePolicyWithServiceResponseAsync(vaultBaseUrl, certificateName, certificatePolicy).toBlocking().single()).getBody();
    }

    public ServiceCall<CertificatePolicy> updateCertificatePolicyAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy, ServiceCallback<CertificatePolicy> serviceCallback) {
        return ServiceCall.create(this.updateCertificatePolicyWithServiceResponseAsync(vaultBaseUrl, certificateName, certificatePolicy), serviceCallback);
    }

    public Observable<CertificatePolicy> updateCertificatePolicyAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy) {
        return this.updateCertificatePolicyWithServiceResponseAsync(vaultBaseUrl, certificateName, certificatePolicy).map((Func1)new Func1<ServiceResponse<CertificatePolicy>, CertificatePolicy>(){

            public CertificatePolicy call(ServiceResponse<CertificatePolicy> response) {
                return (CertificatePolicy)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<CertificatePolicy>> updateCertificatePolicyWithServiceResponseAsync(String vaultBaseUrl, String certificateName, CertificatePolicy certificatePolicy) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (certificatePolicy == null) {
            throw new IllegalArgumentException("Parameter certificatePolicy is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)certificatePolicy);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateCertificatePolicy(certificateName, certificatePolicy, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificatePolicy>>>(){

            public Observable<ServiceResponse<CertificatePolicy>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.updateCertificatePolicyDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificatePolicy> updateCertificatePolicyDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<CertificatePolicy>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public CertificateBundle updateCertificate(String vaultBaseUrl, String certificateName, String certificateVersion) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (CertificateBundle)((ServiceResponse)this.updateCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion).toBlocking().single()).getBody();
    }

    public ServiceCall<CertificateBundle> updateCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion, ServiceCallback<CertificateBundle> serviceCallback) {
        return ServiceCall.create(this.updateCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion), serviceCallback);
    }

    public Observable<CertificateBundle> updateCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion) {
        return this.updateCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion).map((Func1)new Func1<ServiceResponse<CertificateBundle>, CertificateBundle>(){

            public CertificateBundle call(ServiceResponse<CertificateBundle> response) {
                return (CertificateBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<CertificateBundle>> updateCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, String certificateVersion) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (certificateVersion == null) {
            throw new IllegalArgumentException("Parameter certificateVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Object certificatePolicy = null;
        Object certificateAttributes = null;
        Object tags = null;
        CertificateUpdateParameters parameters = new CertificateUpdateParameters();
        parameters.withCertificatePolicy(null);
        parameters.withCertificateAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateCertificate(certificateName, certificateVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateBundle>>>(){

            public Observable<ServiceResponse<CertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.updateCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public CertificateBundle updateCertificate(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (CertificateBundle)((ServiceResponse)this.updateCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion, certificatePolicy, certificateAttributes, tags).toBlocking().single()).getBody();
    }

    public ServiceCall<CertificateBundle> updateCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags, ServiceCallback<CertificateBundle> serviceCallback) {
        return ServiceCall.create(this.updateCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion, certificatePolicy, certificateAttributes, tags), serviceCallback);
    }

    public Observable<CertificateBundle> updateCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return this.updateCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion, certificatePolicy, certificateAttributes, tags).map((Func1)new Func1<ServiceResponse<CertificateBundle>, CertificateBundle>(){

            public CertificateBundle call(ServiceResponse<CertificateBundle> response) {
                return (CertificateBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<CertificateBundle>> updateCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, String certificateVersion, CertificatePolicy certificatePolicy, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (certificateVersion == null) {
            throw new IllegalArgumentException("Parameter certificateVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)certificatePolicy);
        Validator.validate((Object)certificateAttributes);
        Validator.validate(tags);
        CertificateUpdateParameters parameters = new CertificateUpdateParameters();
        parameters.withCertificatePolicy(certificatePolicy);
        parameters.withCertificateAttributes(certificateAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateCertificate(certificateName, certificateVersion, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateBundle>>>(){

            public Observable<ServiceResponse<CertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.updateCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateBundle> updateCertificateDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<CertificateBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public CertificateBundle getCertificate(String vaultBaseUrl, String certificateName, String certificateVersion) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (CertificateBundle)((ServiceResponse)this.getCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion).toBlocking().single()).getBody();
    }

    public ServiceCall<CertificateBundle> getCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion, ServiceCallback<CertificateBundle> serviceCallback) {
        return ServiceCall.create(this.getCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion), serviceCallback);
    }

    public Observable<CertificateBundle> getCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion) {
        return this.getCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, certificateVersion).map((Func1)new Func1<ServiceResponse<CertificateBundle>, CertificateBundle>(){

            public CertificateBundle call(ServiceResponse<CertificateBundle> response) {
                return (CertificateBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<CertificateBundle>> getCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, String certificateVersion) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (certificateVersion == null) {
            throw new IllegalArgumentException("Parameter certificateVersion is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificate(certificateName, certificateVersion, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateBundle>>>(){

            public Observable<ServiceResponse<CertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.getCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateBundle> getCertificateDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<CertificateBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public CertificateOperation updateCertificateOperation(String vaultBaseUrl, String certificateName, boolean cancellationRequested) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (CertificateOperation)((ServiceResponse)this.updateCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName, cancellationRequested).toBlocking().single()).getBody();
    }

    public ServiceCall<CertificateOperation> updateCertificateOperationAsync(String vaultBaseUrl, String certificateName, boolean cancellationRequested, ServiceCallback<CertificateOperation> serviceCallback) {
        return ServiceCall.create(this.updateCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName, cancellationRequested), serviceCallback);
    }

    public Observable<CertificateOperation> updateCertificateOperationAsync(String vaultBaseUrl, String certificateName, boolean cancellationRequested) {
        return this.updateCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName, cancellationRequested).map((Func1)new Func1<ServiceResponse<CertificateOperation>, CertificateOperation>(){

            public CertificateOperation call(ServiceResponse<CertificateOperation> response) {
                return (CertificateOperation)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<CertificateOperation>> updateCertificateOperationWithServiceResponseAsync(String vaultBaseUrl, String certificateName, boolean cancellationRequested) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        CertificateOperationUpdateParameter certificateOperation = new CertificateOperationUpdateParameter();
        certificateOperation.withCancellationRequested(cancellationRequested);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.updateCertificateOperation(certificateName, this.apiVersion(), this.acceptLanguage(), certificateOperation, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateOperation>>>(){

            public Observable<ServiceResponse<CertificateOperation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.updateCertificateOperationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateOperation> updateCertificateOperationDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<CertificateOperation>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public CertificateOperation getCertificateOperation(String vaultBaseUrl, String certificateName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (CertificateOperation)((ServiceResponse)this.getCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName).toBlocking().single()).getBody();
    }

    public ServiceCall<CertificateOperation> getCertificateOperationAsync(String vaultBaseUrl, String certificateName, ServiceCallback<CertificateOperation> serviceCallback) {
        return ServiceCall.create(this.getCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName), serviceCallback);
    }

    public Observable<CertificateOperation> getCertificateOperationAsync(String vaultBaseUrl, String certificateName) {
        return this.getCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName).map((Func1)new Func1<ServiceResponse<CertificateOperation>, CertificateOperation>(){

            public CertificateOperation call(ServiceResponse<CertificateOperation> response) {
                return (CertificateOperation)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<CertificateOperation>> getCertificateOperationWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getCertificateOperation(certificateName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateOperation>>>(){

            public Observable<ServiceResponse<CertificateOperation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.getCertificateOperationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateOperation> getCertificateOperationDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<CertificateOperation>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public CertificateOperation deleteCertificateOperation(String vaultBaseUrl, String certificateName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (CertificateOperation)((ServiceResponse)this.deleteCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName).toBlocking().single()).getBody();
    }

    public ServiceCall<CertificateOperation> deleteCertificateOperationAsync(String vaultBaseUrl, String certificateName, ServiceCallback<CertificateOperation> serviceCallback) {
        return ServiceCall.create(this.deleteCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName), serviceCallback);
    }

    public Observable<CertificateOperation> deleteCertificateOperationAsync(String vaultBaseUrl, String certificateName) {
        return this.deleteCertificateOperationWithServiceResponseAsync(vaultBaseUrl, certificateName).map((Func1)new Func1<ServiceResponse<CertificateOperation>, CertificateOperation>(){

            public CertificateOperation call(ServiceResponse<CertificateOperation> response) {
                return (CertificateOperation)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<CertificateOperation>> deleteCertificateOperationWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.deleteCertificateOperation(certificateName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateOperation>>>(){

            public Observable<ServiceResponse<CertificateOperation>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.deleteCertificateOperationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateOperation> deleteCertificateOperationDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<CertificateOperation>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public CertificateBundle mergeCertificate(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (CertificateBundle)((ServiceResponse)this.mergeCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, x509Certificates).toBlocking().single()).getBody();
    }

    public ServiceCall<CertificateBundle> mergeCertificateAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, ServiceCallback<CertificateBundle> serviceCallback) {
        return ServiceCall.create(this.mergeCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, x509Certificates), serviceCallback);
    }

    public Observable<CertificateBundle> mergeCertificateAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates) {
        return this.mergeCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, x509Certificates).map((Func1)new Func1<ServiceResponse<CertificateBundle>, CertificateBundle>(){

            public CertificateBundle call(ServiceResponse<CertificateBundle> response) {
                return (CertificateBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<CertificateBundle>> mergeCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (x509Certificates == null) {
            throw new IllegalArgumentException("Parameter x509Certificates is required and cannot be null.");
        }
        Validator.validate(x509Certificates);
        Object certificateAttributes = null;
        Object tags = null;
        CertificateMergeParameters parameters = new CertificateMergeParameters();
        parameters.withX509Certificates(x509Certificates);
        parameters.withCertificateAttributes(null);
        parameters.withTags(null);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.mergeCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateBundle>>>(){

            public Observable<ServiceResponse<CertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.mergeCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public CertificateBundle mergeCertificate(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (CertificateBundle)((ServiceResponse)this.mergeCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, x509Certificates, certificateAttributes, tags).toBlocking().single()).getBody();
    }

    public ServiceCall<CertificateBundle> mergeCertificateAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags, ServiceCallback<CertificateBundle> serviceCallback) {
        return ServiceCall.create(this.mergeCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, x509Certificates, certificateAttributes, tags), serviceCallback);
    }

    public Observable<CertificateBundle> mergeCertificateAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        return this.mergeCertificateWithServiceResponseAsync(vaultBaseUrl, certificateName, x509Certificates, certificateAttributes, tags).map((Func1)new Func1<ServiceResponse<CertificateBundle>, CertificateBundle>(){

            public CertificateBundle call(ServiceResponse<CertificateBundle> response) {
                return (CertificateBundle)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<CertificateBundle>> mergeCertificateWithServiceResponseAsync(String vaultBaseUrl, String certificateName, List<byte[]> x509Certificates, CertificateAttributes certificateAttributes, Map<String, String> tags) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (x509Certificates == null) {
            throw new IllegalArgumentException("Parameter x509Certificates is required and cannot be null.");
        }
        Validator.validate(x509Certificates);
        Validator.validate((Object)certificateAttributes);
        Validator.validate(tags);
        CertificateMergeParameters parameters = new CertificateMergeParameters();
        parameters.withX509Certificates(x509Certificates);
        parameters.withCertificateAttributes(certificateAttributes);
        parameters.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.mergeCertificate(certificateName, this.apiVersion(), this.acceptLanguage(), parameters, parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CertificateBundle>>>(){

            public Observable<ServiceResponse<CertificateBundle>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = KeyVaultClientImpl.this.mergeCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CertificateBundle> mergeCertificateDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(201, new TypeToken<CertificateBundle>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public PagedList<KeyItem> getKeyVersionsNext(String nextPageLink) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getKeyVersionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<KeyItem>((Page)response.getBody()){

            public Page<KeyItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getKeyVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<KeyItem>> getKeyVersionsNextAsync(String nextPageLink, ServiceCall<List<KeyItem>> serviceCall, ListOperationCallback<KeyItem> serviceCallback) {
        return AzureServiceCall.create(this.getKeyVersionsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getKeyVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<KeyItem>> getKeyVersionsNextAsync(String nextPageLink) {
        return this.getKeyVersionsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Page<KeyItem>>(){

            public Page<KeyItem> call(ServiceResponse<Page<KeyItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeyVersionsNextWithServiceResponseAsync(String nextPageLink) {
        return this.getKeyVersionsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(ServiceResponse<Page<KeyItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getKeyVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeyVersionsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.getKeyVersionsNext(nextPageLink, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getKeyVersionsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<KeyItem>> getKeyVersionsNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<PageImpl<KeyItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public PagedList<KeyItem> getKeysNext(String nextPageLink) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getKeysNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<KeyItem>((Page)response.getBody()){

            public Page<KeyItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getKeysNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<KeyItem>> getKeysNextAsync(String nextPageLink, ServiceCall<List<KeyItem>> serviceCall, ListOperationCallback<KeyItem> serviceCallback) {
        return AzureServiceCall.create(this.getKeysNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getKeysNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<KeyItem>> getKeysNextAsync(String nextPageLink) {
        return this.getKeysNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Page<KeyItem>>(){

            public Page<KeyItem> call(ServiceResponse<Page<KeyItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeysNextWithServiceResponseAsync(String nextPageLink) {
        return this.getKeysNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<KeyItem>>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(ServiceResponse<Page<KeyItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getKeysNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<KeyItem>>> getKeysNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.getKeysNext(nextPageLink, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<KeyItem>>>>(){

            public Observable<ServiceResponse<Page<KeyItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getKeysNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<KeyItem>> getKeysNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<PageImpl<KeyItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public PagedList<SecretItem> getSecretsNext(String nextPageLink) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getSecretsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SecretItem>((Page)response.getBody()){

            public Page<SecretItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getSecretsNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<SecretItem>> getSecretsNextAsync(String nextPageLink, ServiceCall<List<SecretItem>> serviceCall, ListOperationCallback<SecretItem> serviceCallback) {
        return AzureServiceCall.create(this.getSecretsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getSecretsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SecretItem>> getSecretsNextAsync(String nextPageLink) {
        return this.getSecretsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Page<SecretItem>>(){

            public Page<SecretItem> call(ServiceResponse<Page<SecretItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretsNextWithServiceResponseAsync(String nextPageLink) {
        return this.getSecretsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(ServiceResponse<Page<SecretItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getSecretsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.getSecretsNext(nextPageLink, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getSecretsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SecretItem>> getSecretsNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<PageImpl<SecretItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public PagedList<SecretItem> getSecretVersionsNext(String nextPageLink) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getSecretVersionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SecretItem>((Page)response.getBody()){

            public Page<SecretItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getSecretVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<SecretItem>> getSecretVersionsNextAsync(String nextPageLink, ServiceCall<List<SecretItem>> serviceCall, ListOperationCallback<SecretItem> serviceCallback) {
        return AzureServiceCall.create(this.getSecretVersionsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getSecretVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SecretItem>> getSecretVersionsNextAsync(String nextPageLink) {
        return this.getSecretVersionsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Page<SecretItem>>(){

            public Page<SecretItem> call(ServiceResponse<Page<SecretItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretVersionsNextWithServiceResponseAsync(String nextPageLink) {
        return this.getSecretVersionsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SecretItem>>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(ServiceResponse<Page<SecretItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getSecretVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SecretItem>>> getSecretVersionsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.getSecretVersionsNext(nextPageLink, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SecretItem>>>>(){

            public Observable<ServiceResponse<Page<SecretItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getSecretVersionsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SecretItem>> getSecretVersionsNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<PageImpl<SecretItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public PagedList<CertificateItem> getCertificatesNext(String nextPageLink) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CertificateItem>((Page)response.getBody()){

            public Page<CertificateItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<CertificateItem>> getCertificatesNextAsync(String nextPageLink, ServiceCall<List<CertificateItem>> serviceCall, ListOperationCallback<CertificateItem> serviceCallback) {
        return AzureServiceCall.create(this.getCertificatesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getCertificatesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CertificateItem>> getCertificatesNextAsync(String nextPageLink) {
        return this.getCertificatesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Page<CertificateItem>>(){

            public Page<CertificateItem> call(ServiceResponse<Page<CertificateItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificatesNextWithServiceResponseAsync(String nextPageLink) {
        return this.getCertificatesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(ServiceResponse<Page<CertificateItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getCertificatesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificatesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.getCertificatesNext(nextPageLink, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getCertificatesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CertificateItem>> getCertificatesNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<PageImpl<CertificateItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public PagedList<CertificateIssuerItem> getCertificateIssuersNext(String nextPageLink) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getCertificateIssuersNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CertificateIssuerItem>((Page)response.getBody()){

            public Page<CertificateIssuerItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getCertificateIssuersNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<CertificateIssuerItem>> getCertificateIssuersNextAsync(String nextPageLink, ServiceCall<List<CertificateIssuerItem>> serviceCall, ListOperationCallback<CertificateIssuerItem> serviceCallback) {
        return AzureServiceCall.create(this.getCertificateIssuersNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getCertificateIssuersNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CertificateIssuerItem>> getCertificateIssuersNextAsync(String nextPageLink) {
        return this.getCertificateIssuersNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<CertificateIssuerItem>>, Page<CertificateIssuerItem>>(){

            public Page<CertificateIssuerItem> call(ServiceResponse<Page<CertificateIssuerItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateIssuerItem>>> getCertificateIssuersNextWithServiceResponseAsync(String nextPageLink) {
        return this.getCertificateIssuersNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateIssuerItem>>, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(ServiceResponse<Page<CertificateIssuerItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getCertificateIssuersNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateIssuerItem>>> getCertificateIssuersNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.getCertificateIssuersNext(nextPageLink, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateIssuerItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateIssuerItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getCertificateIssuersNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CertificateIssuerItem>> getCertificateIssuersNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<PageImpl<CertificateIssuerItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    public PagedList<CertificateItem> getCertificateVersionsNext(String nextPageLink) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        ServiceResponse response = (ServiceResponse)this.getCertificateVersionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<CertificateItem>((Page)response.getBody()){

            public Page<CertificateItem> nextPage(String nextPageLink) throws RestException, IOException {
                return (Page)((ServiceResponse)KeyVaultClientImpl.this.getCertificateVersionsNextSinglePageAsync(nextPageLink).toBlocking().single()).getBody();
            }
        };
    }

    public ServiceCall<List<CertificateItem>> getCertificateVersionsNextAsync(String nextPageLink, ServiceCall<List<CertificateItem>> serviceCall, ListOperationCallback<CertificateItem> serviceCallback) {
        return AzureServiceCall.create(this.getCertificateVersionsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(String nextPageLink) {
                return KeyVaultClientImpl.this.getCertificateVersionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<CertificateItem>> getCertificateVersionsNextAsync(String nextPageLink) {
        return this.getCertificateVersionsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Page<CertificateItem>>(){

            public Page<CertificateItem> call(ServiceResponse<Page<CertificateItem>> response) {
                return (Page)response.getBody();
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificateVersionsNextWithServiceResponseAsync(String nextPageLink) {
        return this.getCertificateVersionsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<CertificateItem>>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(ServiceResponse<Page<CertificateItem>> page) {
                String nextPageLink = ((Page)page.getBody()).getNextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(KeyVaultClientImpl.this.getCertificateVersionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<CertificateItem>>> getCertificateVersionsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        return this.service.getCertificateVersionsNext(nextPageLink, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<CertificateItem>>>>(){

            public Observable<ServiceResponse<Page<CertificateItem>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = KeyVaultClientImpl.this.getCertificateVersionsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.getBody(), result.getResponse()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CertificateItem>> getCertificateVersionsNextDelegate(Response<ResponseBody> response) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return new AzureServiceResponseBuilder(this.mapperAdapter()).register(200, new TypeToken<PageImpl<CertificateItem>>(){}.getType()).registerError(KeyVaultErrorException.class).build(response);
    }

    static interface KeyVaultClientService {
        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="keys/{key-name}/create")
        public Observable<Response<ResponseBody>> createKey(@Path(value="key-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body KeyCreateParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PUT(value="keys/{key-name}")
        public Observable<Response<ResponseBody>> importKey(@Path(value="key-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body KeyImportParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="keys/{key-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteKey(@Path(value="key-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PATCH(value="keys/{key-name}/{key-version}")
        public Observable<Response<ResponseBody>> updateKey(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyUpdateParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="keys/{key-name}/{key-version}")
        public Observable<Response<ResponseBody>> getKey(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="keys/{key-name}/versions")
        public Observable<Response<ResponseBody>> getKeyVersions(@Path(value="key-name") String var1, @Query(value="maxresults") Integer var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="keys")
        public Observable<Response<ResponseBody>> getKeys(@Query(value="maxresults") Integer var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="keys/{key-name}/backup")
        public Observable<Response<ResponseBody>> backupKey(@Path(value="key-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="keys/restore")
        public Observable<Response<ResponseBody>> restoreKey(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Body KeyRestoreParameters var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="keys/{key-name}/{key-version}/encrypt")
        public Observable<Response<ResponseBody>> encrypt(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyOperationsParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="keys/{key-name}/{key-version}/decrypt")
        public Observable<Response<ResponseBody>> decrypt(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyOperationsParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="keys/{key-name}/{key-version}/sign")
        public Observable<Response<ResponseBody>> sign(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeySignParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="keys/{key-name}/{key-version}/verify")
        public Observable<Response<ResponseBody>> verify(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyVerifyParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="keys/{key-name}/{key-version}/wrapkey")
        public Observable<Response<ResponseBody>> wrapKey(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyOperationsParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="keys/{key-name}/{key-version}/unwrapkey")
        public Observable<Response<ResponseBody>> unwrapKey(@Path(value="key-name") String var1, @Path(value="key-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body KeyOperationsParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PUT(value="secrets/{secret-name}")
        public Observable<Response<ResponseBody>> setSecret(@Path(value="secret-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body SecretSetParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="secrets/{secret-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteSecret(@Path(value="secret-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PATCH(value="secrets/{secret-name}/{secret-version}")
        public Observable<Response<ResponseBody>> updateSecret(@Path(value="secret-name") String var1, @Path(value="secret-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body SecretUpdateParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="secrets/{secret-name}/{secret-version}")
        public Observable<Response<ResponseBody>> getSecret(@Path(value="secret-name") String var1, @Path(value="secret-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="secrets")
        public Observable<Response<ResponseBody>> getSecrets(@Query(value="maxresults") Integer var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="secrets/{secret-name}/versions")
        public Observable<Response<ResponseBody>> getSecretVersions(@Path(value="secret-name") String var1, @Query(value="maxresults") Integer var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="certificates")
        public Observable<Response<ResponseBody>> getCertificates(@Query(value="maxresults") Integer var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="certificates/{certificate-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCertificate(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PUT(value="certificates/contacts")
        public Observable<Response<ResponseBody>> setCertificateContacts(@Body Contacts var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="certificates/contacts")
        public Observable<Response<ResponseBody>> getCertificateContacts(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="x-ms-parameterized-host") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="certificates/contacts", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCertificateContacts(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="x-ms-parameterized-host") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="certificates/issuers")
        public Observable<Response<ResponseBody>> getCertificateIssuers(@Query(value="maxresults") Integer var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PUT(value="certificates/issuers/{issuer-name}")
        public Observable<Response<ResponseBody>> setCertificateIssuer(@Path(value="issuer-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateIssuerSetParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PATCH(value="certificates/issuers/{issuer-name}")
        public Observable<Response<ResponseBody>> updateCertificateIssuer(@Path(value="issuer-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateIssuerUpdateParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="certificates/issuers/{issuer-name}")
        public Observable<Response<ResponseBody>> getCertificateIssuer(@Path(value="issuer-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="certificates/issuers/{issuer-name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCertificateIssuer(@Path(value="issuer-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="certificates/{certificate-name}/create")
        public Observable<Response<ResponseBody>> createCertificate(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateCreateParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="certificates/{certificate-name}/import")
        public Observable<Response<ResponseBody>> importCertificate(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateImportParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="certificates/{certificate-name}/versions")
        public Observable<Response<ResponseBody>> getCertificateVersions(@Path(value="certificate-name") String var1, @Query(value="maxresults") Integer var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="certificates/{certificate-name}/policy")
        public Observable<Response<ResponseBody>> getCertificatePolicy(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PATCH(value="certificates/{certificate-name}/policy")
        public Observable<Response<ResponseBody>> updateCertificatePolicy(@Path(value="certificate-name") String var1, @Body CertificatePolicy var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PATCH(value="certificates/{certificate-name}/{certificate-version}")
        public Observable<Response<ResponseBody>> updateCertificate(@Path(value="certificate-name") String var1, @Path(value="certificate-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Body CertificateUpdateParameters var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="certificates/{certificate-name}/{certificate-version}")
        public Observable<Response<ResponseBody>> getCertificate(@Path(value="certificate-name") String var1, @Path(value="certificate-version") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @PATCH(value="certificates/{certificate-name}/pending")
        public Observable<Response<ResponseBody>> updateCertificateOperation(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateOperationUpdateParameter var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET(value="certificates/{certificate-name}/pending")
        public Observable<Response<ResponseBody>> getCertificateOperation(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @HTTP(path="certificates/{certificate-name}/pending", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCertificateOperation(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @POST(value="certificates/{certificate-name}/pending/merge")
        public Observable<Response<ResponseBody>> mergeCertificate(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body CertificateMergeParameters var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET
        public Observable<Response<ResponseBody>> getKeyVersionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET
        public Observable<Response<ResponseBody>> getKeysNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET
        public Observable<Response<ResponseBody>> getSecretsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET
        public Observable<Response<ResponseBody>> getSecretVersionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET
        public Observable<Response<ResponseBody>> getCertificatesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET
        public Observable<Response<ResponseBody>> getCertificateIssuersNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8"})
        @GET
        public Observable<Response<ResponseBody>> getCertificateVersionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

