/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault;

import com.google.common.base.Joiner;
import com.microsoft.azure.AzureClient;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.RestClient;
import com.microsoft.azure.keyvault.CertificateIdentifier;
import com.microsoft.azure.keyvault.KeyIdentifier;
import com.microsoft.azure.keyvault.KeyVaultClientImpl;
import com.microsoft.azure.keyvault.SecretIdentifier;
import com.microsoft.azure.keyvault.models.BackupKeyResult;
import com.microsoft.azure.keyvault.models.CertificateBundle;
import com.microsoft.azure.keyvault.models.CertificateIssuerItem;
import com.microsoft.azure.keyvault.models.CertificateItem;
import com.microsoft.azure.keyvault.models.CertificateOperation;
import com.microsoft.azure.keyvault.models.CertificatePolicy;
import com.microsoft.azure.keyvault.models.Contacts;
import com.microsoft.azure.keyvault.models.IssuerBundle;
import com.microsoft.azure.keyvault.models.KeyBundle;
import com.microsoft.azure.keyvault.models.KeyItem;
import com.microsoft.azure.keyvault.models.KeyOperationResult;
import com.microsoft.azure.keyvault.models.KeyVaultErrorException;
import com.microsoft.azure.keyvault.models.KeyVerifyResult;
import com.microsoft.azure.keyvault.models.SecretBundle;
import com.microsoft.azure.keyvault.models.SecretItem;
import com.microsoft.azure.keyvault.requests.CreateCertificateRequest;
import com.microsoft.azure.keyvault.requests.CreateKeyRequest;
import com.microsoft.azure.keyvault.requests.ImportCertificateRequest;
import com.microsoft.azure.keyvault.requests.ImportKeyRequest;
import com.microsoft.azure.keyvault.requests.MergeCertificateRequest;
import com.microsoft.azure.keyvault.requests.SetCertificateIssuerRequest;
import com.microsoft.azure.keyvault.requests.SetSecretRequest;
import com.microsoft.azure.keyvault.requests.UpdateCertificateIssuerRequest;
import com.microsoft.azure.keyvault.requests.UpdateCertificateOperationRequest;
import com.microsoft.azure.keyvault.requests.UpdateCertificatePolicyRequest;
import com.microsoft.azure.keyvault.requests.UpdateCertificateRequest;
import com.microsoft.azure.keyvault.requests.UpdateKeyRequest;
import com.microsoft.azure.keyvault.requests.UpdateSecretRequest;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyEncryptionAlgorithm;
import com.microsoft.azure.keyvault.webkey.JsonWebKeySignatureAlgorithm;
import com.microsoft.rest.ServiceCall;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public final class KeyVaultClient {
    private KeyVaultClientImpl innerKeyVaultClient;
    private KeyVaultClientService service;

    public AzureClient getAzureClient() {
        return this.innerKeyVaultClient.getAzureClient();
    }

    public String apiVersion() {
        return this.innerKeyVaultClient.apiVersion();
    }

    public String acceptLanguage() {
        return this.innerKeyVaultClient.acceptLanguage();
    }

    public void withAcceptLanguage(String acceptLanguage) {
        this.innerKeyVaultClient.withAcceptLanguage(acceptLanguage);
    }

    public int longRunningOperationRetryTimeout() {
        return this.innerKeyVaultClient.longRunningOperationRetryTimeout();
    }

    public void withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.innerKeyVaultClient.withLongRunningOperationRetryTimeout(longRunningOperationRetryTimeout);
    }

    public boolean getGenerateClientRequestId() {
        return this.innerKeyVaultClient.generateClientRequestId();
    }

    public void withGenerateClientRequestId(boolean generateClientRequestId) {
        this.innerKeyVaultClient.withGenerateClientRequestId(generateClientRequestId);
    }

    public KeyVaultClient(ServiceClientCredentials credentials) {
        this.innerKeyVaultClient = new KeyVaultClientImpl(credentials);
        this.initializeService();
    }

    public KeyVaultClient(RestClient restClient) {
        this.innerKeyVaultClient = new KeyVaultClientImpl(restClient);
        this.initializeService();
    }

    public String userAgent() {
        return this.innerKeyVaultClient.userAgent();
    }

    private void initializeService() {
        this.service = (KeyVaultClientService)this.innerKeyVaultClient.restClient().retrofit().create(KeyVaultClientService.class);
    }

    public KeyBundle createKey(CreateKeyRequest createKeyRequest) throws KeyVaultErrorException, IllegalArgumentException, IOException {
        return this.innerKeyVaultClient.createKey(createKeyRequest.vaultBaseUrl(), createKeyRequest.keyName(), createKeyRequest.keyType(), createKeyRequest.keySize(), createKeyRequest.keyOperations(), createKeyRequest.keyAttributes(), createKeyRequest.tags());
    }

    public ServiceCall<KeyBundle> createKeyAsync(CreateKeyRequest createKeyRequest, ServiceCallback<KeyBundle> serviceCallback) {
        return this.innerKeyVaultClient.createKeyAsync(createKeyRequest.vaultBaseUrl(), createKeyRequest.keyName(), createKeyRequest.keyType(), createKeyRequest.keySize(), createKeyRequest.keyOperations(), createKeyRequest.keyAttributes(), createKeyRequest.tags(), serviceCallback);
    }

    public KeyBundle importKey(ImportKeyRequest importKeyRequest) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.importKey(importKeyRequest.vaultBaseUrl(), importKeyRequest.keyName(), importKeyRequest.key(), importKeyRequest.isHsm(), importKeyRequest.keyAttributes(), importKeyRequest.tags());
    }

    public ServiceCall<KeyBundle> importKeyAsync(ImportKeyRequest importKeyRequest, ServiceCallback<KeyBundle> serviceCallback) {
        return this.innerKeyVaultClient.importKeyAsync(importKeyRequest.vaultBaseUrl(), importKeyRequest.keyName(), importKeyRequest.key(), importKeyRequest.isHsm(), importKeyRequest.keyAttributes(), importKeyRequest.tags(), serviceCallback);
    }

    public KeyBundle deleteKey(String vaultBaseUrl, String keyName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.deleteKey(vaultBaseUrl, keyName);
    }

    public ServiceCall<KeyBundle> deleteKeyAsync(String vaultBaseUrl, String keyName, ServiceCallback<KeyBundle> serviceCallback) {
        return this.innerKeyVaultClient.deleteKeyAsync(vaultBaseUrl, keyName, serviceCallback);
    }

    public KeyBundle updateKey(UpdateKeyRequest updateKeyRequest) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.updateKey(updateKeyRequest.vaultBaseUrl(), updateKeyRequest.keyName(), updateKeyRequest.keyVersion(), updateKeyRequest.keyOperations(), updateKeyRequest.keyAttributes(), updateKeyRequest.tags());
    }

    public ServiceCall<KeyBundle> updateKeyAsync(UpdateKeyRequest updateKeyRequest, ServiceCallback<KeyBundle> serviceCallback) {
        return this.innerKeyVaultClient.updateKeyAsync(updateKeyRequest.vaultBaseUrl(), updateKeyRequest.keyName(), updateKeyRequest.keyVersion(), updateKeyRequest.keyOperations(), updateKeyRequest.keyAttributes(), updateKeyRequest.tags(), serviceCallback);
    }

    public KeyBundle getKey(String keyIdentifier) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.innerKeyVaultClient.getKey(id.vault, id.name, id.version == null ? "" : id.version);
    }

    public ServiceCall<KeyBundle> getKeyAsync(String keyIdentifier, ServiceCallback<KeyBundle> serviceCallback) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.innerKeyVaultClient.getKeyAsync(id.vault, id.name, id.version == null ? "" : id.version, serviceCallback);
    }

    public KeyBundle getKey(String vaultBaseUrl, String keyName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getKey(vaultBaseUrl, keyName, "");
    }

    public ServiceCall<KeyBundle> getKeyAsync(String vaultBaseUrl, String keyName, ServiceCallback<KeyBundle> serviceCallback) {
        return this.innerKeyVaultClient.getKeyAsync(vaultBaseUrl, keyName, "", serviceCallback);
    }

    public KeyBundle getKey(String vaultBaseUrl, String keyName, String keyVersion) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getKey(vaultBaseUrl, keyName, keyVersion);
    }

    public ServiceCall<KeyBundle> getKeyAsync(String vaultBaseUrl, String keyName, String keyVersion, ServiceCallback<KeyBundle> serviceCallback) {
        return this.innerKeyVaultClient.getKeyAsync(vaultBaseUrl, keyName, keyVersion, serviceCallback);
    }

    public PagedList<KeyItem> listKeyVersions(String vaultBaseUrl, String keyName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getKeyVersions(vaultBaseUrl, keyName);
    }

    public ServiceCall<List<KeyItem>> listKeyVersionsAsync(String vaultBaseUrl, String keyName, ListOperationCallback<KeyItem> serviceCallback) {
        return this.innerKeyVaultClient.getKeyVersionsAsync(vaultBaseUrl, keyName, serviceCallback);
    }

    public PagedList<KeyItem> listKeyVersions(String vaultBaseUrl, String keyName, Integer maxresults) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getKeyVersions(vaultBaseUrl, keyName, maxresults);
    }

    public ServiceCall<List<KeyItem>> listKeyVersionsAsync(String vaultBaseUrl, String keyName, Integer maxresults, ListOperationCallback<KeyItem> serviceCallback) {
        return this.innerKeyVaultClient.getKeyVersionsAsync(vaultBaseUrl, keyName, maxresults, serviceCallback);
    }

    public PagedList<KeyItem> listKeys(String vaultBaseUrl) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getKeys(vaultBaseUrl);
    }

    public ServiceCall<List<KeyItem>> listKeysAsync(String vaultBaseUrl, ListOperationCallback<KeyItem> serviceCallback) {
        return this.innerKeyVaultClient.getKeysAsync(vaultBaseUrl, serviceCallback);
    }

    public PagedList<KeyItem> listKeys(String vaultBaseUrl, Integer maxresults) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getKeys(vaultBaseUrl, maxresults);
    }

    public ServiceCall<List<KeyItem>> listKeysAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<KeyItem> serviceCallback) {
        return this.innerKeyVaultClient.getKeysAsync(vaultBaseUrl, maxresults, serviceCallback);
    }

    public BackupKeyResult backupKey(String vaultBaseUrl, String keyName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.backupKey(vaultBaseUrl, keyName);
    }

    public ServiceCall<BackupKeyResult> backupKeyAsync(String vaultBaseUrl, String keyName, ServiceCallback<BackupKeyResult> serviceCallback) {
        return this.innerKeyVaultClient.backupKeyAsync(vaultBaseUrl, keyName, serviceCallback);
    }

    public KeyBundle restoreKey(String vaultBaseUrl, byte[] keyBundleBackup) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.restoreKey(vaultBaseUrl, keyBundleBackup);
    }

    public ServiceCall<KeyBundle> restoreKeyAsync(String vaultBaseUrl, byte[] keyBundleBackup, ServiceCallback<KeyBundle> serviceCallback) {
        return this.innerKeyVaultClient.restoreKeyAsync(vaultBaseUrl, keyBundleBackup, serviceCallback);
    }

    public KeyOperationResult encrypt(String keyIdentifier, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.innerKeyVaultClient.encrypt(id.vault, id.name, id.version == null ? "" : id.version, algorithm, value);
    }

    public ServiceCall<KeyOperationResult> encryptAsync(String keyIdentifier, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.innerKeyVaultClient.encryptAsync(id.vault, id.name, id.version == null ? "" : id.version, algorithm, value, serviceCallback);
    }

    public KeyOperationResult decrypt(String keyIdentifier, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.innerKeyVaultClient.decrypt(id.vault, id.name, id.version == null ? "" : id.version, algorithm, value);
    }

    public ServiceCall<KeyOperationResult> decryptAsync(String keyIdentifier, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.innerKeyVaultClient.decryptAsync(id.vault, id.name, id.version == null ? "" : id.version, algorithm, value, serviceCallback);
    }

    public KeyOperationResult sign(String keyIdentifier, JsonWebKeySignatureAlgorithm algorithm, byte[] value) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.innerKeyVaultClient.sign(id.vault, id.name, id.version == null ? "" : id.version, algorithm, value);
    }

    public ServiceCall<KeyOperationResult> signAsync(String keyIdentifier, JsonWebKeySignatureAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.innerKeyVaultClient.signAsync(id.vault, id.name, id.version == null ? "" : id.version, algorithm, value, serviceCallback);
    }

    public KeyVerifyResult verify(String keyIdentifier, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.innerKeyVaultClient.verify(id.vault, id.name, id.version == null ? "" : id.version, algorithm, digest, signature);
    }

    public ServiceCall<KeyVerifyResult> verifyAsync(String keyIdentifier, JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature, ServiceCallback<KeyVerifyResult> serviceCallback) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.innerKeyVaultClient.verifyAsync(id.vault, id.name, id.version == null ? "" : id.version, algorithm, digest, signature, serviceCallback);
    }

    public KeyOperationResult wrapKey(String keyIdentifier, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.innerKeyVaultClient.wrapKey(id.vault, id.name, id.version == null ? "" : id.version, algorithm, value);
    }

    public ServiceCall<KeyOperationResult> wrapKeyAsync(String keyIdentifier, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.innerKeyVaultClient.wrapKeyAsync(id.vault, id.name, id.version == null ? "" : id.version, algorithm, value, serviceCallback);
    }

    public KeyOperationResult unwrapKey(String keyIdentifier, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.innerKeyVaultClient.unwrapKey(id.vault, id.name, id.version == null ? "" : id.version, algorithm, value);
    }

    public ServiceCall<KeyOperationResult> unwrapKeyAsync(String keyIdentifier, JsonWebKeyEncryptionAlgorithm algorithm, byte[] value, ServiceCallback<KeyOperationResult> serviceCallback) {
        KeyIdentifier id = new KeyIdentifier(keyIdentifier);
        return this.innerKeyVaultClient.unwrapKeyAsync(id.vault, id.name, id.version == null ? "" : id.version, algorithm, value, serviceCallback);
    }

    public SecretBundle setSecret(SetSecretRequest setSecretRequest) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.setSecret(setSecretRequest.vaultBaseUrl(), setSecretRequest.secretName(), setSecretRequest.value(), setSecretRequest.tags(), setSecretRequest.contentType(), setSecretRequest.secretAttributes());
    }

    public ServiceCall<SecretBundle> setSecretAsync(SetSecretRequest setSecretRequest, ServiceCallback<SecretBundle> serviceCallback) {
        return this.innerKeyVaultClient.setSecretAsync(setSecretRequest.vaultBaseUrl(), setSecretRequest.secretName(), setSecretRequest.value(), setSecretRequest.tags(), setSecretRequest.contentType(), setSecretRequest.secretAttributes(), serviceCallback);
    }

    public SecretBundle deleteSecret(String vaultBaseUrl, String secretName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.deleteSecret(vaultBaseUrl, secretName);
    }

    public ServiceCall<SecretBundle> deleteSecretAsync(String vaultBaseUrl, String secretName, ServiceCallback<SecretBundle> serviceCallback) {
        return this.innerKeyVaultClient.deleteSecretAsync(vaultBaseUrl, secretName, serviceCallback);
    }

    public SecretBundle updateSecret(UpdateSecretRequest updateSecretRequest) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.updateSecret(updateSecretRequest.vaultBaseUrl(), updateSecretRequest.secretName(), updateSecretRequest.secretVersion(), updateSecretRequest.contentType(), updateSecretRequest.secretAttributes(), updateSecretRequest.tags());
    }

    public ServiceCall<SecretBundle> updateSecretAsync(UpdateSecretRequest updateSecretRequest, ServiceCallback<SecretBundle> serviceCallback) {
        return this.innerKeyVaultClient.updateSecretAsync(updateSecretRequest.vaultBaseUrl(), updateSecretRequest.secretName(), updateSecretRequest.secretVersion(), updateSecretRequest.contentType(), updateSecretRequest.secretAttributes(), updateSecretRequest.tags(), serviceCallback);
    }

    public SecretBundle getSecret(String secretIdentifier) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        SecretIdentifier id = new SecretIdentifier(secretIdentifier);
        return this.innerKeyVaultClient.getSecret(id.vault, id.name, id.version == null ? "" : id.version);
    }

    public ServiceCall<SecretBundle> getSecretAsync(String secretIdentifier, ServiceCallback<SecretBundle> serviceCallback) {
        SecretIdentifier id = new SecretIdentifier(secretIdentifier);
        return this.innerKeyVaultClient.getSecretAsync(id.vault, id.name, id.version == null ? "" : id.version, serviceCallback);
    }

    public SecretBundle getSecret(String vaultBaseUrl, String secretName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getSecret(vaultBaseUrl, secretName, "");
    }

    public ServiceCall<SecretBundle> getSecretAsync(String vaultBaseUrl, String secretName, ServiceCallback<SecretBundle> serviceCallback) {
        return this.innerKeyVaultClient.getSecretAsync(vaultBaseUrl, secretName, "", serviceCallback);
    }

    public SecretBundle getSecret(String vaultBaseUrl, String secretName, String secretVersion) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getSecret(vaultBaseUrl, secretName, secretVersion == null ? "" : secretVersion);
    }

    public ServiceCall<SecretBundle> getSecretAsync(String vaultBaseUrl, String secretName, String secretVersion, ServiceCallback<SecretBundle> serviceCallback) {
        return this.innerKeyVaultClient.getSecretAsync(vaultBaseUrl, secretName, secretVersion == null ? "" : secretVersion, serviceCallback);
    }

    public PagedList<SecretItem> listSecrets(String vaultBaseUrl) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getSecrets(vaultBaseUrl);
    }

    public ServiceCall<List<SecretItem>> listSecretsAsync(String vaultBaseUrl, ListOperationCallback<SecretItem> serviceCallback) {
        return this.innerKeyVaultClient.getSecretsAsync(vaultBaseUrl, serviceCallback);
    }

    public PagedList<SecretItem> listSecrets(String vaultBaseUrl, Integer maxresults) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getSecrets(vaultBaseUrl, maxresults);
    }

    public ServiceCall<List<SecretItem>> listSecretsAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<SecretItem> serviceCallback) {
        return this.innerKeyVaultClient.getSecretsAsync(vaultBaseUrl, maxresults, serviceCallback);
    }

    public PagedList<SecretItem> listSecretVersions(String vaultBaseUrl, String secretName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getSecretVersions(vaultBaseUrl, secretName);
    }

    public ServiceCall<List<SecretItem>> listSecretVersionsAsync(String vaultBaseUrl, String secretName, ListOperationCallback<SecretItem> serviceCallback) {
        return this.innerKeyVaultClient.getSecretVersionsAsync(vaultBaseUrl, secretName, serviceCallback);
    }

    public PagedList<SecretItem> listSecretVersions(String vaultBaseUrl, String secretName, Integer maxresults) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getSecretVersions(vaultBaseUrl, secretName, maxresults);
    }

    public ServiceCall<List<SecretItem>> listSecretVersionsAsync(String vaultBaseUrl, String secretName, Integer maxresults, ListOperationCallback<SecretItem> serviceCallback) {
        return this.innerKeyVaultClient.getSecretVersionsAsync(vaultBaseUrl, secretName, maxresults, serviceCallback);
    }

    public PagedList<CertificateItem> listCertificates(String vaultBaseUrl) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getCertificates(vaultBaseUrl);
    }

    public ServiceCall<List<CertificateItem>> listCertificatesAsync(String vaultBaseUrl, ListOperationCallback<CertificateItem> serviceCallback) {
        return this.innerKeyVaultClient.getCertificatesAsync(vaultBaseUrl, serviceCallback);
    }

    public PagedList<CertificateItem> listCertificates(String vaultBaseUrl, Integer maxresults) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getCertificates(vaultBaseUrl, maxresults);
    }

    public ServiceCall<List<CertificateItem>> listCertificatesAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<CertificateItem> serviceCallback) {
        return this.innerKeyVaultClient.getCertificatesAsync(vaultBaseUrl, maxresults, serviceCallback);
    }

    public CertificateBundle deleteCertificate(String vaultBaseUrl, String certificateName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.deleteCertificate(vaultBaseUrl, certificateName);
    }

    public ServiceCall<CertificateBundle> deleteCertificateAsync(String vaultBaseUrl, String certificateName, ServiceCallback<CertificateBundle> serviceCallback) {
        return this.innerKeyVaultClient.deleteCertificateAsync(vaultBaseUrl, certificateName, serviceCallback);
    }

    public Contacts setCertificateContacts(String vaultBaseUrl, Contacts contacts) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.setCertificateContacts(vaultBaseUrl, contacts);
    }

    public ServiceCall<Contacts> setCertificateContactsAsync(String vaultBaseUrl, Contacts contacts, ServiceCallback<Contacts> serviceCallback) {
        return this.innerKeyVaultClient.setCertificateContactsAsync(vaultBaseUrl, contacts, serviceCallback);
    }

    public Contacts getCertificateContacts(String vaultBaseUrl) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getCertificateContacts(vaultBaseUrl);
    }

    public ServiceCall<Contacts> getCertificateContactsAsync(String vaultBaseUrl, ServiceCallback<Contacts> serviceCallback) {
        return this.innerKeyVaultClient.getCertificateContactsAsync(vaultBaseUrl, serviceCallback);
    }

    public Contacts deleteCertificateContacts(String vaultBaseUrl) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.deleteCertificateContacts(vaultBaseUrl);
    }

    public ServiceCall<Contacts> deleteCertificateContactsAsync(String vaultBaseUrl, ServiceCallback<Contacts> serviceCallback) {
        return this.innerKeyVaultClient.deleteCertificateContactsAsync(vaultBaseUrl, serviceCallback);
    }

    public PagedList<CertificateIssuerItem> listCertificateIssuers(String vaultBaseUrl) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getCertificateIssuers(vaultBaseUrl);
    }

    public ServiceCall<List<CertificateIssuerItem>> listCertificateIssuersAsync(String vaultBaseUrl, ListOperationCallback<CertificateIssuerItem> serviceCallback) {
        return this.innerKeyVaultClient.getCertificateIssuersAsync(vaultBaseUrl, serviceCallback);
    }

    public PagedList<CertificateIssuerItem> listCertificateIssuers(String vaultBaseUrl, Integer maxresults) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getCertificateIssuers(vaultBaseUrl, maxresults);
    }

    public ServiceCall<List<CertificateIssuerItem>> listCertificateIssuersAsync(String vaultBaseUrl, Integer maxresults, ListOperationCallback<CertificateIssuerItem> serviceCallback) {
        return this.innerKeyVaultClient.getCertificateIssuersAsync(vaultBaseUrl, maxresults, serviceCallback);
    }

    public IssuerBundle setCertificateIssuer(SetCertificateIssuerRequest setCertificateIssuerRequest) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.setCertificateIssuer(setCertificateIssuerRequest.vaultBaseUrl(), setCertificateIssuerRequest.issuerName(), setCertificateIssuerRequest.provider(), setCertificateIssuerRequest.credentials(), setCertificateIssuerRequest.organizationDetails(), setCertificateIssuerRequest.attributes());
    }

    public ServiceCall<IssuerBundle> setCertificateIssuerAsync(SetCertificateIssuerRequest setCertificateIssuerRequest, ServiceCallback<IssuerBundle> serviceCallback) {
        return this.innerKeyVaultClient.setCertificateIssuerAsync(setCertificateIssuerRequest.vaultBaseUrl(), setCertificateIssuerRequest.issuerName(), setCertificateIssuerRequest.provider(), setCertificateIssuerRequest.credentials(), setCertificateIssuerRequest.organizationDetails(), setCertificateIssuerRequest.attributes(), serviceCallback);
    }

    public IssuerBundle updateCertificateIssuer(UpdateCertificateIssuerRequest updateCertificateIssuerRequest) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.updateCertificateIssuer(updateCertificateIssuerRequest.vaultBaseUrl(), updateCertificateIssuerRequest.issuerName(), updateCertificateIssuerRequest.provider(), updateCertificateIssuerRequest.credentials(), updateCertificateIssuerRequest.organizationDetails(), updateCertificateIssuerRequest.attributes());
    }

    public ServiceCall<IssuerBundle> updateCertificateIssuerAsync(UpdateCertificateIssuerRequest updateCertificateIssuerRequest, ServiceCallback<IssuerBundle> serviceCallback) {
        return this.innerKeyVaultClient.updateCertificateIssuerAsync(updateCertificateIssuerRequest.vaultBaseUrl(), updateCertificateIssuerRequest.issuerName(), updateCertificateIssuerRequest.provider(), updateCertificateIssuerRequest.credentials(), updateCertificateIssuerRequest.organizationDetails(), updateCertificateIssuerRequest.attributes(), serviceCallback);
    }

    public IssuerBundle getCertificateIssuer(String vaultBaseUrl, String issuerName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getCertificateIssuer(vaultBaseUrl, issuerName);
    }

    public ServiceCall<IssuerBundle> getCertificateIssuerAsync(String vaultBaseUrl, String issuerName, ServiceCallback<IssuerBundle> serviceCallback) {
        return this.innerKeyVaultClient.getCertificateIssuerAsync(vaultBaseUrl, issuerName, serviceCallback);
    }

    public IssuerBundle deleteCertificateIssuer(String vaultBaseUrl, String issuerName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.deleteCertificateIssuer(vaultBaseUrl, issuerName);
    }

    public ServiceCall<IssuerBundle> deleteCertificateIssuerAsync(String vaultBaseUrl, String issuerName, ServiceCallback<IssuerBundle> serviceCallback) {
        return this.innerKeyVaultClient.deleteCertificateIssuerAsync(vaultBaseUrl, issuerName, serviceCallback);
    }

    public CertificateOperation createCertificate(CreateCertificateRequest createCertificateRequest) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.createCertificate(createCertificateRequest.vaultBaseUrl(), createCertificateRequest.certificateName(), createCertificateRequest.certificatePolicy(), createCertificateRequest.certificateAttributes(), createCertificateRequest.tags());
    }

    public ServiceCall<CertificateOperation> createCertificateAsync(CreateCertificateRequest createCertificateRequest, ServiceCallback<CertificateOperation> serviceCallback) {
        return this.innerKeyVaultClient.createCertificateAsync(createCertificateRequest.vaultBaseUrl(), createCertificateRequest.certificateName(), createCertificateRequest.certificatePolicy(), createCertificateRequest.certificateAttributes(), createCertificateRequest.tags(), serviceCallback);
    }

    public CertificateBundle importCertificate(ImportCertificateRequest importCertificateRequest) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.importCertificate(importCertificateRequest.vaultBaseUrl(), importCertificateRequest.certificateName(), importCertificateRequest.base64EncodedCertificate(), importCertificateRequest.password(), importCertificateRequest.certificatePolicy(), importCertificateRequest.certificateAttributes(), importCertificateRequest.tags());
    }

    public ServiceCall<CertificateBundle> importCertificateAsync(ImportCertificateRequest importCertificateRequest, ServiceCallback<CertificateBundle> serviceCallback) {
        return this.innerKeyVaultClient.importCertificateAsync(importCertificateRequest.vaultBaseUrl(), importCertificateRequest.certificateName(), importCertificateRequest.base64EncodedCertificate(), importCertificateRequest.password(), importCertificateRequest.certificatePolicy(), importCertificateRequest.certificateAttributes(), importCertificateRequest.tags(), serviceCallback);
    }

    public PagedList<CertificateItem> listCertificateVersions(String vaultBaseUrl, String certificateName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getCertificateVersions(vaultBaseUrl, certificateName);
    }

    public ServiceCall<List<CertificateItem>> listCertificateVersionsAsync(String vaultBaseUrl, String certificateName, ListOperationCallback<CertificateItem> serviceCallback) {
        return this.innerKeyVaultClient.getCertificateVersionsAsync(vaultBaseUrl, certificateName, serviceCallback);
    }

    public PagedList<CertificateItem> listCertificateVersions(String vaultBaseUrl, String certificateName, Integer maxresults) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getCertificateVersions(vaultBaseUrl, certificateName, maxresults);
    }

    public ServiceCall<List<CertificateItem>> listCertificateVersionsAsync(String vaultBaseUrl, String certificateName, Integer maxresults, ListOperationCallback<CertificateItem> serviceCallback) {
        return this.innerKeyVaultClient.getCertificateVersionsAsync(vaultBaseUrl, certificateName, maxresults, serviceCallback);
    }

    public CertificatePolicy getCertificatePolicy(String vaultBaseUrl, String certificateName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getCertificatePolicy(vaultBaseUrl, certificateName);
    }

    public ServiceCall<CertificatePolicy> getCertificatePolicyAsync(String vaultBaseUrl, String certificateName, ServiceCallback<CertificatePolicy> serviceCallback) {
        return this.innerKeyVaultClient.getCertificatePolicyAsync(vaultBaseUrl, certificateName, serviceCallback);
    }

    public CertificatePolicy updateCertificatePolicy(UpdateCertificatePolicyRequest updateCertificatePolicyRequest) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.updateCertificatePolicy(updateCertificatePolicyRequest.vaultBaseUrl(), updateCertificatePolicyRequest.certificateName(), updateCertificatePolicyRequest.certificatePolicy());
    }

    public ServiceCall<CertificatePolicy> updateCertificatePolicyAsync(UpdateCertificatePolicyRequest updateCertificatePolicyRequest, ServiceCallback<CertificatePolicy> serviceCallback) {
        return this.innerKeyVaultClient.updateCertificatePolicyAsync(updateCertificatePolicyRequest.vaultBaseUrl(), updateCertificatePolicyRequest.certificateName(), updateCertificatePolicyRequest.certificatePolicy(), serviceCallback);
    }

    public CertificateBundle updateCertificate(UpdateCertificateRequest updateCertificateRequest) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.updateCertificate(updateCertificateRequest.vaultBaseUrl(), updateCertificateRequest.certificateName(), updateCertificateRequest.certificateVersion(), updateCertificateRequest.certificatePolicy(), updateCertificateRequest.certificateAttributes(), updateCertificateRequest.tags());
    }

    public ServiceCall<CertificateBundle> updateCertificateAsync(UpdateCertificateRequest updateCertificateRequest, ServiceCallback<CertificateBundle> serviceCallback) {
        return this.innerKeyVaultClient.updateCertificateAsync(updateCertificateRequest.vaultBaseUrl(), updateCertificateRequest.certificateName(), updateCertificateRequest.certificateVersion(), updateCertificateRequest.certificatePolicy(), updateCertificateRequest.certificateAttributes(), updateCertificateRequest.tags(), serviceCallback);
    }

    public CertificateBundle getCertificate(String certificateIdentifier) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        CertificateIdentifier id = new CertificateIdentifier(certificateIdentifier);
        return this.innerKeyVaultClient.getCertificate(id.vault, id.name, id.version == null ? "" : id.version);
    }

    public ServiceCall<CertificateBundle> getCertificateAsync(String certificateIdentifier, ServiceCallback<CertificateBundle> serviceCallback) {
        CertificateIdentifier id = new CertificateIdentifier(certificateIdentifier);
        return this.innerKeyVaultClient.getCertificateAsync(id.vault, id.name, id.version == null ? "" : id.version, serviceCallback);
    }

    public CertificateBundle getCertificate(String vaultBaseUrl, String certificateName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getCertificate(vaultBaseUrl, certificateName, "");
    }

    public ServiceCall<CertificateBundle> getCertificateAsync(String vaultBaseUrl, String certificateName, ServiceCallback<CertificateBundle> serviceCallback) {
        return this.innerKeyVaultClient.getCertificateAsync(vaultBaseUrl, certificateName, "", serviceCallback);
    }

    public CertificateBundle getCertificate(String vaultBaseUrl, String certificateName, String certificateVersion) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getCertificate(vaultBaseUrl, certificateName, certificateVersion);
    }

    public ServiceCall<CertificateBundle> getCertificateAsync(String vaultBaseUrl, String certificateName, String certificateVersion, ServiceCallback<CertificateBundle> serviceCallback) {
        return this.innerKeyVaultClient.getCertificateAsync(vaultBaseUrl, certificateName, certificateVersion, serviceCallback);
    }

    public CertificateOperation updateCertificateOperation(UpdateCertificateOperationRequest updateCertificateOperationRequest) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.updateCertificateOperation(updateCertificateOperationRequest.vaultBaseUrl(), updateCertificateOperationRequest.certificateName(), updateCertificateOperationRequest.cancellationRequested());
    }

    public ServiceCall<CertificateOperation> updateCertificateOperationAsync(UpdateCertificateOperationRequest updateCertificateOperationRequest, ServiceCallback<CertificateOperation> serviceCallback) {
        return this.innerKeyVaultClient.updateCertificateOperationAsync(updateCertificateOperationRequest.vaultBaseUrl(), updateCertificateOperationRequest.certificateName(), updateCertificateOperationRequest.cancellationRequested(), serviceCallback);
    }

    public CertificateOperation getCertificateOperation(String vaultBaseUrl, String certificateName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.getCertificateOperation(vaultBaseUrl, certificateName);
    }

    public ServiceCall<CertificateOperation> getCertificateOperationAsync(String vaultBaseUrl, String certificateName, ServiceCallback<CertificateOperation> serviceCallback) {
        return this.innerKeyVaultClient.getCertificateOperationAsync(vaultBaseUrl, certificateName, serviceCallback);
    }

    public CertificateOperation deleteCertificateOperation(String vaultBaseUrl, String certificateName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.deleteCertificateOperation(vaultBaseUrl, certificateName);
    }

    public ServiceCall<CertificateOperation> deleteCertificateOperationAsync(String vaultBaseUrl, String certificateName, ServiceCallback<CertificateOperation> serviceCallback) {
        return this.innerKeyVaultClient.deleteCertificateOperationAsync(vaultBaseUrl, certificateName, serviceCallback);
    }

    public CertificateBundle mergeCertificate(MergeCertificateRequest mergeCertificateRequest) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return this.innerKeyVaultClient.mergeCertificate(mergeCertificateRequest.vaultBaseUrl(), mergeCertificateRequest.certificateName(), mergeCertificateRequest.x509Certificates(), mergeCertificateRequest.certificateAttributes(), mergeCertificateRequest.tags());
    }

    public ServiceCall<CertificateBundle> mergeCertificateAsync(MergeCertificateRequest mergeCertificateRequest, ServiceCallback<CertificateBundle> serviceCallback) {
        return this.innerKeyVaultClient.mergeCertificateAsync(mergeCertificateRequest.vaultBaseUrl(), mergeCertificateRequest.certificateName(), mergeCertificateRequest.x509Certificates(), mergeCertificateRequest.certificateAttributes(), mergeCertificateRequest.tags(), serviceCallback);
    }

    public String getPendingCertificateSigningRequest(String vaultBaseUrl, String certificateName) throws KeyVaultErrorException, IOException, IllegalArgumentException {
        return (String)((ServiceResponse)this.getPendingCertificateSigningRequestWithServiceResponseAsync(vaultBaseUrl, certificateName).toBlocking().single()).getBody();
    }

    public ServiceCall<String> getPendingCertificateSigningRequestAsync(String vaultBaseUrl, String certificateName, ServiceCallback<String> serviceCallback) {
        return ServiceCall.create(this.getPendingCertificateSigningRequestWithServiceResponseAsync(vaultBaseUrl, certificateName), serviceCallback);
    }

    private Observable<ServiceResponse<String>> getPendingCertificateSigningRequestWithServiceResponseAsync(String vaultBaseUrl, String certificateName) {
        if (vaultBaseUrl == null) {
            throw new IllegalArgumentException("Parameter vaultBaseUrl is required and cannot be null.");
        }
        if (certificateName == null) {
            throw new IllegalArgumentException("Parameter certificateName is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{vaultBaseUrl}", (Object)vaultBaseUrl, new Object[0]);
        return this.service.getPendingCertificateSigningRequest(certificateName, this.apiVersion(), this.acceptLanguage(), parameterizedHost, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<String>>>(){

            public Observable<ServiceResponse<String>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = new ServiceResponse((Object)((ResponseBody)response.body()).string(), response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    static interface KeyVaultClientService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "Accept: application/pkcs10"})
        @GET(value="certificates/{certificate-name}/pending")
        public Observable<Response<ResponseBody>> getPendingCertificateSigningRequest(@Path(value="certificate-name") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);
    }
}

