/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault;

import com.microsoft.azure.keyvault.KeyOpRequestMessageWithRawJsonContent;
import com.microsoft.azure.keyvault.SecretRequestMessageWithRawJsonContent;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectReader;
import org.codehaus.jackson.map.ObjectWriter;

final class JsonSupport {
    private JsonSupport() {
    }

    static <T> ObjectReader getJsonReader(Class<T> clazz) {
        return new ObjectMapper().reader(clazz);
    }

    static ObjectWriter getJsonWriter() {
        return new ObjectMapper().writer();
    }

    static <T> KeyOpRequestMessageWithRawJsonContent serializeKeyOpRequest(T object) {
        KeyOpRequestMessageWithRawJsonContent result = new KeyOpRequestMessageWithRawJsonContent();
        try {
            String json = JsonSupport.getJsonWriter().writeValueAsString(object);
            result.setRawJsonRequest(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    static <T> SecretRequestMessageWithRawJsonContent serializeSecretOpRequest(T object) {
        SecretRequestMessageWithRawJsonContent result = new SecretRequestMessageWithRawJsonContent();
        try {
            String json = JsonSupport.getJsonWriter().writeValueAsString(object);
            result.setRawJsonRequest(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

