/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.authentication;

import com.microsoft.azure.keyvault.authentication.BearerAuthentication;
import com.microsoft.azure.keyvault.authentication.BearerCredentialsSupport;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestContext;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.credentials.CloudCredentials;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.http.Header;

public abstract class KeyVaultCredentials
extends CloudCredentials
implements BearerCredentialsSupport {
    private static final String AUTH_FILTERS_KEY = "AuthFilters";
    private final HashMap<String, Map<String, String>> cachedChallenges = new HashMap();

    public <T> void applyConfig(String profile, Map<String, Object> properties) {
        ArrayList filters;
        if (!properties.containsKey(AUTH_FILTERS_KEY)) {
            filters = new ArrayList();
            properties.put(AUTH_FILTERS_KEY, filters);
        } else {
            filters = (ArrayList)properties.get(AUTH_FILTERS_KEY);
        }
        filters.add(new ServiceRequestFilter(){

            public void filter(ServiceRequestContext request) {
                String authority = KeyVaultCredentials.getAuthority(request);
                Map challenge = KeyVaultCredentials.this.getCachedChallenge(authority);
                if (challenge == null) {
                    return;
                }
                Header header = KeyVaultCredentials.this.doAuthenticate(request, challenge);
                if (header == null) {
                    return;
                }
                request.setHeader(header.getName(), header.getValue());
            }
        });
    }

    @Override
    public Header authenticate(ServiceRequestContext request, BearerAuthentication authentication) {
        Map<String, String> challenge = authentication.getParameters();
        challenge = new HashMap<String, String>(challenge);
        challenge = Collections.unmodifiableMap(challenge);
        String authority = KeyVaultCredentials.getAuthority(request);
        this.addCachedChallenge(authority, challenge);
        return this.doAuthenticate(request, challenge);
    }

    public abstract Header doAuthenticate(ServiceRequestContext var1, Map<String, String> var2);

    private Map<String, String> getCachedChallenge(String authority) {
        authority = authority.toLowerCase(Locale.ENGLISH);
        return this.cachedChallenges.get(authority);
    }

    private void addCachedChallenge(String authority, Map<String, String> challenge) {
        authority = authority.toLowerCase(Locale.ENGLISH);
        this.cachedChallenges.put(authority, challenge);
    }

    private static String getAuthority(ServiceRequestContext request) {
        return KeyVaultCredentials.getAuthority(request.getFullURI());
    }

    private static String getAuthority(URI uri) {
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        StringBuilder builder = new StringBuilder();
        if (scheme != null) {
            builder.append(scheme).append("://");
        }
        builder.append(host);
        if (port >= 0) {
            builder.append(':').append(port);
        }
        return builder.toString();
    }
}

