/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.gradle.temeletry;

import com.microsoft.azure.gradle.temeletry.TelemetryConfiguration;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemeter;
import com.microsoft.azure.toolkit.lib.common.telemetry.AzureTelemetryClient;
import com.microsoft.azure.toolkit.lib.common.utils.InstallationIdUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TelemetryAgent
implements TelemetryConfiguration {
    private static final String CONFIGURATION_PATH = Paths.get(System.getProperty("user.home"), ".azure", "gradleplugins.properties").toString();
    private static final String FIRST_RUN_KEY = "first.run";
    private static final String PRIVACY_STATEMENT = "\nData/Telemetry\n---------\nThis project collects usage data and sends it to Microsoft to help improve our products and services.\nRead Microsoft's privacy statement to learn more: https://privacy.microsoft.com/en-us/privacystatement.\n\nYou can change your telemetry configuration through 'allowTelemetry' property.\nFor more information, please go to https://aka.ms/azure-gradle-config.\n";
    private static final String ERROR_MESSAGE = "error.message";
    private static final String ERROR_STACK = "error.stack";
    private static final String ERROR_CLASSNAME = "error.class_name";
    private String pluginName;
    private String pluginVersion;
    private boolean allowTelemetry;
    private String subscriptionId;
    private String authType;
    private String authMethod;
    private AzureTelemetryClient telemetryProxy;
    private final String sessionId = UUID.randomUUID().toString();
    private final String installationId = InstallationIdUtils.getHashMac();
    private static TelemetryAgent instance = new TelemetryAgent();

    public static TelemetryAgent getInstance() {
        return instance;
    }

    public String getUserAgent() {
        return this.allowTelemetry ? String.format("%s/%s %s:%s %s:%s", this.pluginName, this.pluginVersion, "installationId", this.installationId, "sessionId", this.sessionId) : String.format("%s/%s", this.pluginName, this.pluginVersion);
    }

    public void initTelemetry(@Nonnull String pluginName, @Nonnull String pluginVersion, boolean allowTelemetry) {
        this.pluginName = pluginName;
        this.pluginVersion = pluginVersion;
        this.allowTelemetry = allowTelemetry;
        this.telemetryProxy = new AzureTelemetryClient(this.getTelemetryProperties());
        if (!allowTelemetry) {
            this.telemetryProxy.trackEvent("TelemetryNotAllowed");
            this.telemetryProxy.disable();
        } else {
            AzureTelemeter.setClient((AzureTelemetryClient)this.telemetryProxy);
            AzureTelemeter.setCommonProperties(this.getTelemetryProperties());
            AzureTelemeter.setEventNamePrefix((String)"AzurePlugin.Gradle");
        }
    }

    public void addDefaultProperty(String key, String value) {
        this.telemetryProxy.addDefaultProperty(key, value);
    }

    public void addDefaultProperties(Map<String, String> properties) {
        Optional.ofNullable(properties).ifPresent(values -> values.forEach(this::addDefaultProperty));
    }

    @Override
    public Map<String, String> getTelemetryProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("installationId", this.installationId);
        map.put("pluginName", this.pluginName);
        map.put("pluginVersion", this.pluginVersion);
        map.put("subscriptionId", this.subscriptionId);
        map.put("sessionId", this.sessionId);
        map.put("authType", this.authType);
        map.put("authMethod", this.authMethod);
        return map;
    }

    public void trackEvent(String event) {
        if (this.allowTelemetry) {
            this.telemetryProxy.trackEvent(event);
        }
    }

    public void trackEvent(String eventName, Map<String, String> customProperties) {
        if (this.allowTelemetry) {
            this.telemetryProxy.trackEvent(eventName, customProperties);
        }
    }

    public void showPrivacyStatement() {
        Properties prop = new Properties();
        if (this.isFirstRun(prop)) {
            AzureMessager.getMessager().confirm(PRIVACY_STATEMENT);
            this.updateConfigurationFile(prop);
        }
    }

    public void trackTaskSkip(Class taskClass) {
        this.trackEvent(taskClass.getSimpleName() + ".skip");
    }

    public void trackTaskStart(Class taskClass) {
        this.trackEvent(taskClass.getSimpleName() + ".start");
    }

    public void trackTaskSuccess(Class taskClass) {
        this.trackEvent(taskClass.getSimpleName() + ".success");
    }

    public void traceException(Class taskClass, Exception exception) {
        HashMap<String, String> failureReason = new HashMap<String, String>();
        String errorMessage = Optional.ofNullable(exception.getMessage()).filter(StringUtils::isNotEmpty).orElseGet(() -> exception.toString());
        failureReason.put(ERROR_MESSAGE, errorMessage);
        failureReason.put(ERROR_STACK, ExceptionUtils.getStackTrace((Throwable)exception));
        failureReason.put(ERROR_CLASSNAME, exception.getClass().getName());
        this.trackEvent(taskClass.getSimpleName() + ".failure", failureReason);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isFirstRun(Properties prop) {
        try {
            File configurationFile = new File(CONFIGURATION_PATH);
            if (!configurationFile.exists()) {
                configurationFile.getParentFile().mkdirs();
                configurationFile.createNewFile();
                return true;
            }
            try (FileInputStream input = new FileInputStream(CONFIGURATION_PATH);){
                prop.load(input);
                String firstRunValue = prop.getProperty(FIRST_RUN_KEY);
                if (firstRunValue == null) return true;
                if (firstRunValue.isEmpty()) return true;
                if (!firstRunValue.equalsIgnoreCase("false")) return true;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            AzureMessager.getMessager().warning(e.getMessage());
        }
        return true;
    }

    private void updateConfigurationFile(Properties prop) {
        try (FileOutputStream output = new FileOutputStream(CONFIGURATION_PATH);){
            prop.setProperty(FIRST_RUN_KEY, "false");
            prop.store(output, "Azure Gradle Plugin configurations");
        }
        catch (Exception e) {
            AzureMessager.getMessager().warning(e.getMessage());
        }
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }
}

