/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.common.function.handlers.CommandHandler;
import com.microsoft.azure.common.function.handlers.CommandHandlerImpl;
import com.microsoft.azure.common.function.utils.CommandUtils;
import com.microsoft.azure.common.logging.Log;
import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="run")
public class RunMojo
extends AbstractFunctionMojo {
    public static final String STAGE_DIR_FOUND = "Azure Function App's staging directory found at: ";
    public static final String STAGE_DIR_NOT_FOUND = "Stage directory not found. Please run mvn package first.";
    public static final String RUNTIME_FOUND = "Azure Functions Core Tools found.";
    public static final String RUNTIME_NOT_FOUND = "Azure Functions Core Tools not found. Please go to https://aka.ms/azfunc-install to install Azure Functions Core Tools first.";
    public static final String RUN_FUNCTIONS_FAILURE = "Failed to run Azure Functions. Please checkout console output.";
    public static final String FUNC_HOST_START_CMD = "func host start";
    public static final String FUNC_HOST_START_WITH_DEBUG_CMD = "func host start --language-worker -- \"-agentlib:jdwp=%s\"";
    public static final String FUNC_CMD = "func";
    @Parameter(property="localDebugConfig", defaultValue="transport=dt_socket,server=y,suspend=n,address=5005")
    protected String localDebugConfig;

    public String getLocalDebugConfig() {
        return this.localDebugConfig;
    }

    public void setLocalDebugConfig(String localDebugConfig) {
        this.localDebugConfig = localDebugConfig;
    }

    protected void doExecute() throws AzureExecutionException {
        CommandHandlerImpl commandHandler = new CommandHandlerImpl();
        this.checkStageDirectoryExistence();
        this.checkRuntimeExistence((CommandHandler)commandHandler);
        this.runFunctions((CommandHandler)commandHandler);
    }

    protected void checkStageDirectoryExistence() throws AzureExecutionException {
        File file = new File(this.getDeploymentStagingDirectoryPath());
        if (!file.exists() || !file.isDirectory()) {
            throw new AzureExecutionException(STAGE_DIR_NOT_FOUND);
        }
        Log.info((String)(STAGE_DIR_FOUND + this.getDeploymentStagingDirectoryPath()));
    }

    protected void checkRuntimeExistence(CommandHandler handler) throws AzureExecutionException {
        handler.runCommandWithReturnCodeCheck(this.getCheckRuntimeCommand(), false, null, CommandUtils.getDefaultValidReturnCodes(), RUNTIME_NOT_FOUND);
        Log.info((String)RUNTIME_FOUND);
    }

    protected void runFunctions(CommandHandler handler) throws AzureExecutionException {
        handler.runCommandWithReturnCodeCheck(this.getStartFunctionHostCommand(), true, this.getDeploymentStagingDirectoryPath(), CommandUtils.getValidReturnCodes(), RUN_FUNCTIONS_FAILURE);
    }

    protected String getCheckRuntimeCommand() {
        return FUNC_CMD;
    }

    protected String getStartFunctionHostCommand() {
        String enableDebug = System.getProperty("enableDebug");
        if (StringUtils.isNotEmpty((CharSequence)enableDebug) && enableDebug.equalsIgnoreCase("true")) {
            return this.getStartFunctionHostWithDebugCommand();
        }
        return FUNC_HOST_START_CMD;
    }

    protected String getStartFunctionHostWithDebugCommand() {
        return String.format(FUNC_HOST_START_WITH_DEBUG_CMD, this.getLocalDebugConfig());
    }
}

