/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function.handlers.runtime;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.maven.function.configurations.FunctionExtensionVersion;
import com.microsoft.azure.maven.function.configurations.RuntimeConfiguration;
import com.microsoft.azure.maven.handlers.runtime.BaseRuntimeHandler;

public abstract class FunctionRuntimeHandler
extends BaseRuntimeHandler<FunctionApp> {
    protected FunctionExtensionVersion functionExtensionVersion;
    protected RuntimeConfiguration runtimeConfiguration;

    protected FunctionRuntimeHandler(Builder<?> builder) {
        super(builder);
        this.functionExtensionVersion = builder.functionExtensionVersion;
        this.runtimeConfiguration = builder.runtimeConfiguration;
    }

    public abstract FunctionApp.DefinitionStages.WithCreate defineAppWithRuntime() throws AzureExecutionException;

    public abstract FunctionApp.Update updateAppRuntime(FunctionApp var1) throws AzureExecutionException;

    protected void changeAppServicePlan(FunctionApp app, AppServicePlan appServicePlan) throws AzureExecutionException {
        ((FunctionApp.Update)app.update()).withExistingAppServicePlan(appServicePlan).apply();
    }

    protected FunctionApp.DefinitionStages.Blank defineFunction() {
        return (FunctionApp.DefinitionStages.Blank)this.azure.appServices().functionApps().define(this.appName);
    }

    protected ResourceGroup getResourceGroup() {
        return (ResourceGroup)this.azure.resourceGroups().getByName(this.resourceGroup);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseRuntimeHandler.Builder<T> {
        protected FunctionExtensionVersion functionExtensionVersion;
        protected RuntimeConfiguration runtimeConfiguration;

        public T functionExtensionVersion(FunctionExtensionVersion value) {
            this.functionExtensionVersion = value;
            return (T)this.self();
        }

        public T runtime(RuntimeConfiguration value) {
            this.runtimeConfiguration = value;
            return (T)this.self();
        }

        public abstract FunctionRuntimeHandler build();

        protected abstract T self();
    }
}

