/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function.handlers.artifact;

import com.microsoft.azure.common.exceptions.AzureExecutionException;
import com.microsoft.azure.management.appservice.AppSetting;
import com.microsoft.azure.management.appservice.FunctionApp;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.maven.deploytarget.DeployTarget;
import com.microsoft.azure.storage.CloudStorageAccount;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.zeroturnaround.zip.ZipUtil;

public class FunctionArtifactHelper {
    private static final String STAGE_DIR_NOT_FOUND = "Azure Functions stage directory not found. Please run 'mvn clean azure-functions:package' first.";
    private static final String INTERNAL_STORAGE_NOT_FOUND = "Application setting 'AzureWebJobsStorage' not found.";
    private static final String UNSUPPORTED_DEPLOYMENT_TARGET = "Unsupported deployment target, only function is supported";

    public static File createFunctionArtifact(String stagingDirectoryPath) throws Exception {
        File stageDirectory = new File(stagingDirectoryPath);
        File zipPackage = new File(stagingDirectoryPath.concat(".zip"));
        if (!stageDirectory.exists() || !stageDirectory.isDirectory()) {
            throw new Exception(STAGE_DIR_NOT_FOUND);
        }
        ZipUtil.pack((File)stageDirectory, (File)zipPackage);
        ZipUtil.removeEntry((File)zipPackage, (String)"local.settings.json");
        return zipPackage;
    }

    public static void updateAppSetting(DeployTarget deployTarget, String key, String value) throws AzureExecutionException {
        WebAppBase targetApp = deployTarget.getApp();
        if (!(targetApp instanceof FunctionApp)) {
            throw new AzureExecutionException(UNSUPPORTED_DEPLOYMENT_TARGET);
        }
        FunctionApp functionApp = (FunctionApp)targetApp;
        ((FunctionApp.Update)functionApp.update()).withAppSetting(key, value).apply();
    }

    public static CloudStorageAccount getCloudStorageAccount(DeployTarget target) throws Exception {
        String value;
        AppSetting setting;
        Map settingsMap = target.getAppSettings();
        if (settingsMap != null && (setting = (AppSetting)settingsMap.get("AzureWebJobsStorage")) != null && StringUtils.isNotEmpty((CharSequence)(value = setting.value()))) {
            return CloudStorageAccount.parse((String)value);
        }
        throw new Exception(INTERNAL_STORAGE_NOT_FOUND);
    }
}

