/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import com.microsoft.azure.maven.function.template.BindingTemplate;
import com.microsoft.azure.maven.function.template.BindingsTemplate;
import com.microsoft.azure.maven.function.template.FunctionSettingTemplate;
import com.microsoft.azure.maven.function.template.FunctionTemplate;
import com.microsoft.azure.maven.function.template.FunctionTemplates;
import com.microsoft.azure.maven.function.template.TemplateResources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.lang.model.SourceVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="add")
public class AddMojo
extends AbstractFunctionMojo {
    public static final String LOAD_TEMPLATES = "Step 1 of 4: Load all function templates";
    public static final String LOAD_TEMPLATES_DONE = "Successfully loaded all function templates";
    public static final String LOAD_TEMPLATES_FAIL = "Failed to load all function templates.";
    public static final String FIND_TEMPLATE = "Step 2 of 4: Select function template";
    public static final String FIND_TEMPLATE_DONE = "Successfully found function template: ";
    public static final String FIND_TEMPLATE_FAIL = "Function template not found: ";
    public static final String LOAD_BINDING_TEMPLATES_FAIL = "Failed to load function binding template.";
    public static final String PREPARE_PARAMS = "Step 3 of 4: Prepare required parameters";
    public static final String FOUND_VALID_VALUE = "Found valid value. Skip user input.";
    public static final String SAVE_FILE = "Step 4 of 4: Saving function to file";
    public static final String SAVE_FILE_DONE = "Successfully saved new function at ";
    public static final String FILE_EXIST = "Function already exists at %s. Please specify a different function name.";
    public static final String DEFAULT_INPUT_ERROR_MESSAGE = "Invalid input, please check and try again.";
    public static final String PROMPT_STRING_WITH_DEFAULTVALUE = "Enter value for %s(Default: %s): ";
    public static final String PROMPT_STRING_WITHOUT_DEFAULTVALUE = "Enter value for %s: ";
    private static final String FUNCTION_NAME_REGEXP = "^[a-zA-Z][a-zA-Z\\d_\\-]*$";
    @Parameter(defaultValue="${project.basedir}", readonly=true, required=true)
    protected File basedir;
    @Parameter(defaultValue="${project.compileSourceRoots}", readonly=true, required=true)
    protected List<String> compileSourceRoots;
    @Parameter(property="functions.package")
    protected String functionPackageName;
    @Parameter(property="functions.name")
    protected String functionName;
    @Parameter(property="functions.template")
    protected String functionTemplate;

    public String getFunctionPackageName() {
        return this.functionPackageName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getClassName() {
        return this.getFunctionName().replace('-', '_');
    }

    public String getFunctionTemplate() {
        return this.functionTemplate;
    }

    protected String getBasedir() {
        return this.basedir.getAbsolutePath();
    }

    protected String getSourceRoot() {
        return this.compileSourceRoots == null || this.compileSourceRoots.isEmpty() ? Paths.get(this.getBasedir(), "src", "main", "java").toString() : this.compileSourceRoots.get(0);
    }

    protected void setFunctionPackageName(String functionPackageName) {
        this.functionPackageName = StringUtils.lowerCase((String)functionPackageName);
    }

    protected void setFunctionName(String functionName) {
        this.functionName = StringUtils.capitalize((String)functionName);
    }

    protected void setFunctionTemplate(String functionTemplate) {
        this.functionTemplate = functionTemplate;
    }

    protected void doExecute() throws Exception {
        List<FunctionTemplate> templates = this.loadAllFunctionTemplates();
        FunctionTemplate template = this.getFunctionTemplate(templates);
        BindingTemplate bindingTemplate = this.loadBindingTemplate(template.getTriggerType());
        Map<String, String> params = this.prepareRequiredParameters(template, bindingTemplate);
        String newFunctionClass = this.substituteParametersInTemplate(template, params);
        this.saveNewFunctionToFile(newFunctionClass);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BindingTemplate loadBindingTemplate(String type) {
        try (InputStream is = AddMojo.class.getResourceAsStream("/bindings.json");){
            String bindingsJsonStr = IOUtil.toString((InputStream)is);
            BindingsTemplate bindingsTemplate = (BindingsTemplate)new ObjectMapper().readValue(bindingsJsonStr, BindingsTemplate.class);
            BindingTemplate bindingTemplate = bindingsTemplate.getBindingTemplateByName(type);
            return bindingTemplate;
        }
        catch (IOException e) {
            this.warning(LOAD_BINDING_TEMPLATES_FAIL);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<FunctionTemplate> loadAllFunctionTemplates() throws Exception {
        this.info("");
        this.info(LOAD_TEMPLATES);
        try (InputStream is = AddMojo.class.getResourceAsStream("/templates.json");){
            String templatesJsonStr = IOUtil.toString((InputStream)is);
            List<FunctionTemplate> templates = this.parseTemplateJson(templatesJsonStr);
            this.info(LOAD_TEMPLATES_DONE);
            List<FunctionTemplate> list = templates;
            return list;
        }
        catch (Exception e) {
            this.error(LOAD_TEMPLATES_FAIL);
            throw e;
        }
    }

    protected List<FunctionTemplate> parseTemplateJson(String templateJson) throws Exception {
        FunctionTemplates templates = (FunctionTemplates)new ObjectMapper().readValue(templateJson, FunctionTemplates.class);
        return templates.getTemplates();
    }

    protected FunctionTemplate getFunctionTemplate(List<FunctionTemplate> templates) throws Exception {
        this.info("");
        this.info(FIND_TEMPLATE);
        if (this.settings != null && !this.settings.isInteractiveMode()) {
            this.assureInputInBatchMode(this.getFunctionTemplate(), str -> this.getTemplateNames(templates).stream().filter(Objects::nonNull).anyMatch(o -> o.equalsIgnoreCase((String)str)), this::setFunctionTemplate, true);
        } else {
            this.assureInputFromUser("template for new function", this.getFunctionTemplate(), this.getTemplateNames(templates), this::setFunctionTemplate);
        }
        return this.findTemplateByName(templates, this.getFunctionTemplate());
    }

    protected List<String> getTemplateNames(List<FunctionTemplate> templates) {
        return templates.stream().map(t -> t.getMetadata().getName()).collect(Collectors.toList());
    }

    protected FunctionTemplate findTemplateByName(List<FunctionTemplate> templates, String templateName) throws Exception {
        this.info("Selected function template: " + templateName);
        Optional<FunctionTemplate> template = templates.stream().filter(t -> t.getMetadata().getName().equalsIgnoreCase(templateName)).findFirst();
        if (template.isPresent()) {
            this.info(FIND_TEMPLATE_DONE + templateName);
            return template.get();
        }
        throw new Exception(FIND_TEMPLATE_FAIL + templateName);
    }

    protected Map<String, String> prepareRequiredParameters(FunctionTemplate template, BindingTemplate bindingTemplate) throws MojoFailureException {
        this.info("");
        this.info(PREPARE_PARAMS);
        this.prepareFunctionName();
        this.preparePackageName();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("functionName", this.getFunctionName());
        params.put("className", this.getClassName());
        params.put("packageName", this.getFunctionPackageName());
        this.prepareTemplateParameters(template, bindingTemplate, params);
        this.displayParameters(params);
        return params;
    }

    protected void prepareFunctionName() throws MojoFailureException {
        this.info("Common parameter [Function Name]: name for both the new function and Java class");
        if (this.settings != null && !this.settings.isInteractiveMode()) {
            this.assureInputInBatchMode(this.getFunctionName(), str -> StringUtils.isNotEmpty((CharSequence)str) && str.matches(FUNCTION_NAME_REGEXP), this::setFunctionName, true);
        } else {
            this.assureInputFromUser("Enter value for Function Name: ", this.getFunctionName(), str -> StringUtils.isNotEmpty((CharSequence)str) && str.matches(FUNCTION_NAME_REGEXP), "Function name must start with a letter and can contain letters, digits, '_' and '-'", this::setFunctionName);
        }
    }

    protected void preparePackageName() throws MojoFailureException {
        this.info("Common parameter [Package Name]: package name of the new Java class");
        if (this.settings != null && !this.settings.isInteractiveMode()) {
            this.assureInputInBatchMode(this.getFunctionPackageName(), str -> StringUtils.isNotEmpty((CharSequence)str) && SourceVersion.isName(str), this::setFunctionPackageName, true);
        } else {
            this.assureInputFromUser("Enter value for Package Name: ", this.getFunctionPackageName(), str -> StringUtils.isNotEmpty((CharSequence)str) && SourceVersion.isName(str), "Input should be a valid Java package name.", this::setFunctionPackageName);
        }
    }

    protected Map<String, String> prepareTemplateParameters(FunctionTemplate template, BindingTemplate bindingTemplate, Map<String, String> params) throws MojoFailureException {
        for (String property : template.getMetadata().getUserPrompt()) {
            String initValue = System.getProperty(property);
            List<String> options = this.getOptionsForUserPrompt(property);
            FunctionSettingTemplate settingTemplate = bindingTemplate == null ? null : bindingTemplate.getSettingTemplateByName(property);
            String helpMessage = settingTemplate != null && settingTemplate.getHelp() != null ? settingTemplate.getHelp() : "";
            this.info(String.format("Trigger specific parameter [%s]:%s", property, TemplateResources.getResource(helpMessage)));
            if (this.settings != null && !this.settings.isInteractiveMode()) {
                if (options != null && options.size() > 0) {
                    String foundElement = this.findElementInOptions(options, initValue);
                    initValue = foundElement == null ? options.get(0) : foundElement;
                }
                this.assureInputInBatchMode(initValue, StringUtils::isNotEmpty, str -> params.put(property, (String)str), false);
                continue;
            }
            if (options == null) {
                params.put(property, this.getStringInputFromUser(property, initValue, settingTemplate));
                continue;
            }
            this.assureInputFromUser(String.format("the value for %s: ", property), System.getProperty(property), options, str -> params.put(property, (String)str));
        }
        return params;
    }

    protected String getStringInputFromUser(String attributeName, String initValue, FunctionSettingTemplate template) {
        String defaultValue = template == null ? null : template.getDefaultValue();
        Function<String, Boolean> validator = this.getStringInputValidator(template);
        if (validator.apply(initValue).booleanValue()) {
            this.info(FOUND_VALID_VALUE);
            return initValue;
        }
        Scanner scanner = this.getScanner();
        while (true) {
            System.out.printf(this.getStringInputPromptString(attributeName, defaultValue), new Object[0]);
            System.out.flush();
            String input = scanner.nextLine();
            if (validator.apply(input).booleanValue()) {
                return input;
            }
            if (StringUtils.isNotEmpty((CharSequence)defaultValue) && StringUtils.isEmpty((CharSequence)input)) {
                return defaultValue;
            }
            this.warning(this.getStringInputErrorMessage(template));
        }
    }

    protected String getStringInputErrorMessage(FunctionSettingTemplate template) {
        return template != null && template.getErrorText() != null ? TemplateResources.getResource(template.getErrorText()) : DEFAULT_INPUT_ERROR_MESSAGE;
    }

    protected String getStringInputPromptString(String attributeName, String defaultValue) {
        return StringUtils.isBlank((CharSequence)defaultValue) ? String.format(PROMPT_STRING_WITHOUT_DEFAULTVALUE, attributeName) : String.format(PROMPT_STRING_WITH_DEFAULTVALUE, attributeName, defaultValue);
    }

    protected Function<String, Boolean> getStringInputValidator(FunctionSettingTemplate template) {
        String regex;
        String string = regex = template == null ? null : template.getSettingRegex();
        if (regex == null) {
            return StringUtils::isNotEmpty;
        }
        return attribute -> StringUtils.isNotEmpty((CharSequence)attribute) && attribute.matches(regex);
    }

    protected void displayParameters(Map<String, String> params) {
        this.info("");
        this.info("Summary of parameters for function template:");
        params.entrySet().stream().forEach(e -> this.info(String.format("%s: %s", e.getKey(), e.getValue())));
    }

    protected String substituteParametersInTemplate(FunctionTemplate template, Map<String, String> params) {
        String ret = template.getFiles().get("function.java");
        for (Map.Entry<String, String> entry : params.entrySet()) {
            ret = ret.replace(String.format("$%s$", entry.getKey()), entry.getValue());
        }
        return ret;
    }

    protected void saveNewFunctionToFile(String newFunctionClass) throws Exception {
        this.info("");
        this.info(SAVE_FILE);
        File packageDir = this.getPackageDir();
        File targetFile = this.getTargetFile(packageDir);
        this.createPackageDirIfNotExist(packageDir);
        this.saveToTargetFile(targetFile, newFunctionClass);
        this.info(SAVE_FILE_DONE + targetFile.getAbsolutePath());
    }

    protected File getPackageDir() {
        String sourceRoot = this.getSourceRoot();
        String[] packageName = this.getFunctionPackageName().split("\\.");
        return Paths.get(sourceRoot, packageName).toFile();
    }

    protected File getTargetFile(File packageDir) throws Exception {
        String javaFileName = this.getClassName() + ".java";
        File targetFile = new File(packageDir, javaFileName);
        if (targetFile.exists()) {
            throw new FileAlreadyExistsException(String.format(FILE_EXIST, targetFile.getAbsolutePath()));
        }
        return targetFile;
    }

    protected void createPackageDirIfNotExist(File packageDir) {
        if (!packageDir.exists()) {
            packageDir.mkdirs();
        }
    }

    protected void saveToTargetFile(File targetFile, String newFunctionClass) throws Exception {
        try (FileOutputStream os = new FileOutputStream(targetFile);){
            IOUtil.copy((String)newFunctionClass, (OutputStream)os);
        }
    }

    protected void assureInputFromUser(String prompt, String initValue, List<String> options, Consumer<String> setter) {
        String option = this.findElementInOptions(options, initValue);
        if (option != null) {
            this.info(FOUND_VALID_VALUE);
            setter.accept(option);
            return;
        }
        System.out.printf("Choose from below options as %s %n", prompt);
        for (int i = 0; i < options.size(); ++i) {
            System.out.printf("%d. %s%n", i, options.get(i));
        }
        this.assureInputFromUser("Enter index to use: ", null, str -> {
            try {
                int index = Integer.parseInt(str);
                return 0 <= index && index < options.size();
            }
            catch (Exception e) {
                return false;
            }
        }, "Invalid index.", str -> {
            int index = Integer.parseInt(str);
            setter.accept((String)options.get(index));
        });
    }

    protected void assureInputFromUser(String prompt, String initValue, Function<String, Boolean> validator, String errorMessage, Consumer<String> setter) {
        if (validator.apply(initValue).booleanValue()) {
            this.info(FOUND_VALID_VALUE);
            setter.accept(initValue);
            return;
        }
        Scanner scanner = this.getScanner();
        while (true) {
            System.out.printf(prompt, new Object[0]);
            System.out.flush();
            try {
                String input = scanner.nextLine();
                if (validator.apply(input).booleanValue()) {
                    setter.accept(input);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.warning(errorMessage);
        }
    }

    protected void assureInputInBatchMode(String input, Function<String, Boolean> validator, Consumer<String> setter, boolean required) throws MojoFailureException {
        if (validator.apply(input).booleanValue()) {
            this.info(FOUND_VALID_VALUE);
            setter.accept(input);
            return;
        }
        if (required) {
            throw new MojoFailureException(String.format("invalid input: %s", input));
        }
        System.out.printf("The input is invalid. Use empty string.%n", new Object[0]);
        setter.accept("");
    }

    protected Scanner getScanner() {
        return new Scanner(System.in, "UTF-8");
    }

    @Nullable
    private String findElementInOptions(List<String> options, String item) {
        return options.stream().filter(o -> o != null && o.equalsIgnoreCase(item)).findFirst().orElse(null);
    }

    @Nullable
    private List<String> getOptionsForUserPrompt(String promptName) {
        if ("authlevel".equalsIgnoreCase(promptName.trim())) {
            return Arrays.asList("ANONYMOUS", "FUNCTION", "ADMIN");
        }
        if ("createLeaseCollectionIfNotExists".equalsIgnoreCase(promptName.trim())) {
            return Arrays.asList("true", "false");
        }
        return null;
    }
}

