/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function.handlers;

import com.github.zafarkhaja.semver.Version;
import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import com.microsoft.azure.maven.function.handlers.CommandHandler;
import com.microsoft.azure.maven.function.handlers.FunctionCoreToolsHandler;
import com.microsoft.azure.maven.function.utils.CommandUtils;

public class FunctionCoreToolsHandlerImpl
implements FunctionCoreToolsHandler {
    public static final String FUNC_EXTENSIONS_INSTALL_TEMPLATE = "func extensions install -c \"%s\"";
    public static final String INSTALL_FUNCTION_EXTENSIONS_FAIL = "Failed to install the Function extensions";
    public static final String CANNOT_AUTO_INSTALL = "Local Azure Functions Core Tools does not exist or is too old to support function extension installation, skip package phase. To install or update it, see: https://aka.ms/azfunc-install";
    public static final String NEED_UPDATE_FUNCTION_CORE_TOOLS = "Local version of Azure Functions Core Tools (%s) does not match the latest (%s). Please update it for the best experience. See: https://aka.ms/azfunc-install";
    public static final String GET_LATEST_VERSION_CMD = "npm view azure-functions-core-tools dist-tags.core";
    public static final String GET_LATEST_VERSION_FAIL = "Failed to check update for Azure Functions Core Tools";
    public static final String GET_LOCAL_VERSION_CMD = "func --version";
    public static final String GET_LOCAL_VERSION_FAIL = "Failed to get Azure Functions Core Tools version locally";
    public static final Version LEAST_SUPPORTED_VERSION = Version.valueOf((String)"2.0.1-beta.26");
    private AbstractFunctionMojo mojo;
    private CommandHandler commandHandler;

    public FunctionCoreToolsHandlerImpl(AbstractFunctionMojo mojo, CommandHandler commandHandler) {
        this.mojo = mojo;
        this.commandHandler = commandHandler;
    }

    @Override
    public void installExtension() throws Exception {
        this.assureRequirementAddressed();
        this.installFunctionExtension();
    }

    protected void installFunctionExtension() throws Exception {
        this.commandHandler.runCommandWithReturnCodeCheck(String.format(FUNC_EXTENSIONS_INSTALL_TEMPLATE, this.getProjectBasePath()), true, this.mojo.getDeploymentStagingDirectoryPath(), CommandUtils.getDefaultValidReturnCodes(), INSTALL_FUNCTION_EXTENSIONS_FAIL);
    }

    protected void assureRequirementAddressed() throws Exception {
        String localVersion = this.getLocalFunctionCoreToolsVersion();
        String latestCoreVersion = this.getLatestFunctionCoreToolsVersion();
        if (localVersion == null || LEAST_SUPPORTED_VERSION.greaterThan(Version.valueOf((String)localVersion))) {
            throw new Exception(CANNOT_AUTO_INSTALL);
        }
        if (latestCoreVersion == null) {
            this.mojo.warning(GET_LATEST_VERSION_FAIL);
        } else if (Version.valueOf((String)localVersion).lessThan(Version.valueOf((String)latestCoreVersion))) {
            this.mojo.warning(String.format(NEED_UPDATE_FUNCTION_CORE_TOOLS, localVersion, latestCoreVersion));
        }
    }

    protected String getLatestFunctionCoreToolsVersion() {
        try {
            String latestCoreVersion = this.commandHandler.runCommandAndGetOutput(GET_LATEST_VERSION_CMD, false, null);
            Version.valueOf((String)latestCoreVersion);
            return latestCoreVersion;
        }
        catch (Exception e) {
            this.mojo.getLog().warn((CharSequence)GET_LATEST_VERSION_FAIL);
            return null;
        }
    }

    protected String getLocalFunctionCoreToolsVersion() {
        try {
            String localVersion = this.commandHandler.runCommandAndGetOutput(GET_LOCAL_VERSION_CMD, false, null);
            Version.valueOf((String)localVersion);
            return localVersion;
        }
        catch (Exception e) {
            this.mojo.getLog().warn((CharSequence)GET_LOCAL_VERSION_FAIL);
            return null;
        }
    }

    protected String getProjectBasePath() {
        return this.mojo.getProject().getBasedir().getAbsolutePath();
    }
}

