/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.function;

import com.microsoft.azure.maven.function.AbstractFunctionMojo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="list")
public class ListMojo
extends AbstractFunctionMojo {
    protected static final String TEMPLATES_START = ">> templates begin <<";
    protected static final String TEMPLATES_END = ">> templates end <<";
    protected static final String BINDINGS_START = ">> bindings begin <<";
    protected static final String BINDINGS_END = ">> bindings end <<";
    protected static final String RESOURCES_START = ">> resources begin <<";
    protected static final String RESOURCES_END = ">> resources end <<";
    protected static final String TEMPLATES_FILE = "/templates.json";
    protected static final String BINDINGS_FILE = "/bindings.json";
    protected static final String RESOURCES_FILE = "/resources.json";

    protected void doExecute() throws Exception {
        this.info(TEMPLATES_START);
        this.printToSystemOut(TEMPLATES_FILE);
        this.info(TEMPLATES_END);
        this.info(BINDINGS_START);
        this.printToSystemOut(BINDINGS_FILE);
        this.info(BINDINGS_END);
        this.info(RESOURCES_START);
        this.printToSystemOut(RESOURCES_FILE);
        this.info(RESOURCES_END);
    }

    protected void printToSystemOut(String file) throws IOException {
        try (InputStream is = ListMojo.class.getResourceAsStream(file);){
            IOUtils.copy((InputStream)is, (OutputStream)System.out);
        }
    }
}

