/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.plugin.functions.gradle.util;

import com.microsoft.azure.plugin.functions.gradle.JavaProject;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public class GradleProjectUtils {
    private static final String MAIN_SOURCE_SET_NAME = "main";

    public static JavaProject convert(Project project) {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        Objects.requireNonNull(javaPluginConvention, "Project " + project.getName() + " is not java project.");
        SourceSet mainSourceSet = (SourceSet)javaPluginConvention.getSourceSets().getByName(MAIN_SOURCE_SET_NAME);
        FileCollection classesOutputDirectories = mainSourceSet.getOutput().getClassesDirs().filter(File::exists);
        Path resourcesOutputDirectory = Objects.requireNonNull(mainSourceSet.getOutput().getResourcesDir()).toPath();
        FileCollection allFiles = mainSourceSet.getRuntimeClasspath().filter(File::exists);
        FileCollection allDependencies = allFiles.minus(classesOutputDirectories).filter(file -> !file.toPath().equals(resourcesOutputDirectory));
        JavaProject func = new JavaProject();
        func.setBaseDirectory(project.getProjectDir().toPath());
        func.setBuildDirectory(project.getBuildDir().toPath());
        ArrayList<Path> dependencies = new ArrayList<Path>();
        func.setDependencies(dependencies);
        for (File dependency : allDependencies) {
            dependencies.add(dependency.toPath());
        }
        BasePluginConvention basePlugin = (BasePluginConvention)project.getConvention().getPlugin(BasePluginConvention.class);
        func.setArtifactFile(Paths.get(project.getBuildDir().getAbsolutePath(), basePlugin.getLibsDirName(), basePlugin.getArchivesBaseName() + "-" + project.getVersion() + ".jar"));
        return func;
    }
}

