/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.plugin.functions.gradle;

import com.microsoft.azure.gradle.auth.GradleAuthConfig;
import com.microsoft.azure.gradle.auth.GradleAuthHelper;
import com.microsoft.azure.gradle.configuration.GradleDeploymentSlotConfig;
import com.microsoft.azure.gradle.configuration.GradleRuntimeConfig;
import com.microsoft.azure.plugin.functions.gradle.AzureFunctionsExtension;
import com.microsoft.azure.plugin.functions.gradle.JavaProject;
import com.microsoft.azure.plugin.functions.gradle.util.GradleProjectUtils;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.appservice.function.AzureFunctions;
import com.microsoft.azure.toolkit.lib.appservice.function.FunctionAppModule;
import com.microsoft.azure.toolkit.lib.common.IProject;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;

public class GradleFunctionContext {
    private static final String FUNCTION_JAVA_VERSION_KEY = "functionJavaVersion";
    private static final String DISABLE_APP_INSIGHTS_KEY = "disableAppInsights";
    private static final String FUNCTION_RUNTIME_KEY = "os";
    private static final String FUNCTION_IS_DOCKER_KEY = "isDockerFunction";
    private static final String FUNCTION_REGION_KEY = "region";
    private static final String FUNCTION_PRICING_KEY = "pricingTier";
    private static final String DEPLOY_TO_SLOT_KEY = "isDeployToFunctionSlot";
    private static final String GRADLE_PLUGIN_POSTFIX = "-gradle-plugin";
    private volatile File stagingDirectory;
    private final JavaProject javaProject;
    private final AzureFunctionsExtension functionsExtension;
    private Map<String, String> appSettings;
    private FunctionAppModule appServiceClient;

    public GradleFunctionContext(Project project, AzureFunctionsExtension functionsExtension) {
        this.functionsExtension = functionsExtension;
        this.javaProject = GradleProjectUtils.convert(project);
    }

    public IProject getProject() {
        return this.javaProject;
    }

    public FunctionAppModule getOrCreateAzureAppServiceClient() {
        if (this.appServiceClient == null) {
            try {
                String subscriptionId = GradleAuthHelper.login((GradleAuthConfig)this.functionsExtension.getAuth(), (String)this.functionsExtension.getSubscription());
                this.appServiceClient = ((AzureFunctions)Azure.az(AzureFunctions.class)).functionApps(subscriptionId);
            }
            catch (AzureToolkitRuntimeException e) {
                throw new AzureToolkitRuntimeException(String.format("Cannot authenticate due to error %s", e.getMessage()), (Throwable)e);
            }
        }
        return this.appServiceClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeploymentStagingDirectoryPath() {
        if (this.stagingDirectory == null) {
            GradleFunctionContext gradleFunctionContext = this;
            synchronized (gradleFunctionContext) {
                if (this.stagingDirectory == null) {
                    String outputFolder = "azure-functions-gradle-plugin".replaceAll(GRADLE_PLUGIN_POSTFIX, "");
                    String stagingDirectoryPath = Paths.get(this.javaProject.getBuildDirectory().toString(), outputFolder, this.functionsExtension.getAppName()).toString();
                    this.stagingDirectory = new File(stagingDirectoryPath);
                    if (!this.stagingDirectory.exists()) {
                        this.stagingDirectory.mkdirs();
                    }
                }
            }
        }
        return this.stagingDirectory.getPath();
    }

    public String getSubscription() {
        return this.functionsExtension.getSubscription();
    }

    public String getAppName() {
        return this.functionsExtension.getAppName();
    }

    public String getResourceGroup() {
        return this.functionsExtension.getResourceGroup();
    }

    public GradleRuntimeConfig getRuntime() {
        return this.functionsExtension.getRuntime();
    }

    public String getRegion() {
        return this.functionsExtension.getRegion();
    }

    public String getPricingTier() {
        return this.functionsExtension.getPricingTier();
    }

    public String getAppServicePlanResourceGroup() {
        return this.functionsExtension.getAppServicePlanResourceGroup();
    }

    public String getAppServicePlanName() {
        return this.functionsExtension.getAppServicePlanName();
    }

    public Map<String, String> getAppSettings() {
        if (this.appSettings == null) {
            Map<Object, Object> map = this.functionsExtension.getAppSettings() != null ? this.functionsExtension.getAppSettings() : new HashMap();
            this.appSettings = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Objects.toString(e.getValue(), null)));
        }
        return this.appSettings;
    }

    public GradleAuthConfig getAuth() {
        return this.functionsExtension.getAuth();
    }

    public String getDeploymentType() {
        if (this.functionsExtension.getDeployment() == null) {
            return null;
        }
        return this.functionsExtension.getDeployment().getType();
    }

    public String getAppInsightsInstance() {
        return this.functionsExtension.getAppInsightsInstance();
    }

    public String getAppInsightsKey() {
        return this.functionsExtension.getAppInsightsKey();
    }

    public String getDeploymentSlotName() {
        return Optional.ofNullable(this.functionsExtension.getDeploymentSlot()).map(GradleDeploymentSlotConfig::name).orElse(null);
    }

    public String getDeploymentSlotConfigurationSource() {
        return Optional.ofNullable(this.functionsExtension.getDeploymentSlot()).map(GradleDeploymentSlotConfig::configurationSource).orElse(null);
    }

    public boolean isDisableAppInsights() {
        return BooleanUtils.isTrue((Boolean)this.functionsExtension.isDisableAppInsights());
    }

    public String getLocalDebugConfig() {
        return this.functionsExtension.getLocalDebug();
    }

    public Map<String, String> getTelemetryProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        GradleRuntimeConfig runtime = this.getRuntime();
        String javaVersion = runtime == null ? null : runtime.javaVersion();
        String os = runtime == null ? null : runtime.os();
        boolean isDockerFunction = runtime != null && StringUtils.isNotEmpty((CharSequence)runtime.image());
        result.put(FUNCTION_JAVA_VERSION_KEY, StringUtils.isEmpty((CharSequence)javaVersion) ? "" : javaVersion);
        result.put(FUNCTION_RUNTIME_KEY, StringUtils.isEmpty((CharSequence)os) ? "" : os);
        result.put(FUNCTION_IS_DOCKER_KEY, String.valueOf(isDockerFunction));
        result.put(FUNCTION_REGION_KEY, this.getRegion());
        result.put(FUNCTION_PRICING_KEY, this.getPricingTier());
        result.put(DISABLE_APP_INSIGHTS_KEY, String.valueOf(this.isDisableAppInsights()));
        result.put(DEPLOY_TO_SLOT_KEY, String.valueOf(StringUtils.isEmpty((CharSequence)this.getDeploymentSlotName())));
        return result;
    }
}

