/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.plugin.functions.gradle;

import com.microsoft.azure.gradle.auth.GradleAuthConfig;
import com.microsoft.azure.gradle.configuration.GradleDeploymentSlotConfig;
import com.microsoft.azure.gradle.configuration.GradleRuntimeConfig;
import com.microsoft.azure.plugin.functions.gradle.configuration.deploy.Deployment;
import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class AzureFunctionsExtension {
    @Nullable
    private Boolean allowTelemetry;
    @Nullable
    private String localDebug;
    @Nullable
    private String subscription;
    @Nullable
    private String resourceGroup;
    private String appName;
    @Nullable
    private String region;
    @Nullable
    private String pricingTier;
    @Nullable
    private String appServicePlanResourceGroup;
    @Nullable
    private String appServicePlanName;
    @Nullable
    private GradleAuthConfig auth;
    @Nullable
    private Deployment deployment;
    @Nullable
    private GradleRuntimeConfig runtime;
    @Nullable
    private GradleDeploymentSlotConfig deploymentSlot;
    private Map<String, String> appSettings;
    private final Project project;
    @Nullable
    private String appInsightsInstance;
    @Nullable
    private String appInsightsKey;
    @Nullable
    private Boolean disableAppInsights;

    public AzureFunctionsExtension(Project project) {
        this.project = project;
    }

    @Input
    @Optional
    public String getLocalDebug() {
        return this.localDebug;
    }

    @Input
    @Optional
    public String getResourceGroup() {
        return this.resourceGroup;
    }

    @Input
    public String getAppName() {
        return this.appName;
    }

    @Input
    @Optional
    public String getRegion() {
        return this.region;
    }

    @Input
    @Optional
    public String getSubscription() {
        return this.subscription;
    }

    @Input
    @Optional
    public String getPricingTier() {
        return this.pricingTier;
    }

    @Input
    @Optional
    public String getAppServicePlanName() {
        return this.appServicePlanName;
    }

    @Input
    @Optional
    public String getAppServicePlanResourceGroup() {
        return this.appServicePlanResourceGroup;
    }

    @Input
    @Optional
    public GradleAuthConfig getAuth() {
        return this.auth;
    }

    @Input
    @Optional
    public Deployment getDeployment() {
        return this.deployment;
    }

    @Input
    @Optional
    public Map<String, String> getAppSettings() {
        return this.appSettings;
    }

    @Input
    @Optional
    public GradleRuntimeConfig getRuntime() {
        return this.runtime;
    }

    @Input
    @Optional
    public Boolean getAllowTelemetry() {
        return this.allowTelemetry;
    }

    @Input
    @Optional
    public String getAppInsightsInstance() {
        return this.appInsightsInstance;
    }

    @Input
    @Optional
    public String getAppInsightsKey() {
        return this.appInsightsKey;
    }

    @Input
    @Optional
    public Boolean isDisableAppInsights() {
        return this.disableAppInsights;
    }

    @Input
    @Optional
    public GradleDeploymentSlotConfig getDeploymentSlot() {
        return this.deploymentSlot;
    }

    public void setAllowTelemetry(Boolean allowTelemetry) {
        this.allowTelemetry = allowTelemetry;
    }

    public void setResourceGroup(String resourceGroup) {
        this.resourceGroup = resourceGroup;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public void setPricingTier(String pricingTier) {
        this.pricingTier = pricingTier;
    }

    public void setAuth(Closure closure) {
        this.auth = new GradleAuthConfig();
        this.project.configure((Object)this.auth, closure);
    }

    @Deprecated
    public void setAuthentication(Closure closure) {
        this.auth = new GradleAuthConfig();
        this.project.configure((Object)this.auth, closure);
    }

    public void setDeployment(Closure closure) {
        this.deployment = new Deployment();
        this.project.configure((Object)this.deployment, closure);
    }

    public void setRuntime(Closure closure) {
        this.runtime = new GradleRuntimeConfig();
        this.project.configure((Object)this.runtime, closure);
    }

    public void setDeploymentSlot(Closure closure) {
        this.deploymentSlot = new GradleDeploymentSlotConfig();
        this.project.configure((Object)this.deploymentSlot, closure);
    }

    public void setAppServicePlanName(String appServicePlanName) {
        this.appServicePlanName = appServicePlanName;
    }

    public void setAppServicePlanResourceGroup(String appServicePlanResourceGroup) {
        this.appServicePlanResourceGroup = appServicePlanResourceGroup;
    }

    public void setAppSettings(Closure closure) {
        this.appSettings = new HashMap<String, String>();
        this.project.configure(this.appSettings, closure);
    }

    public void setLocalDebug(String localDebug) {
        this.localDebug = localDebug;
    }

    public void setAppInsightsInstance(@Nullable String appInsightsInstance) {
        this.appInsightsInstance = appInsightsInstance;
    }

    public void setAppInsightsKey(@Nullable String appInsightsKey) {
        this.appInsightsKey = appInsightsKey;
    }

    public void setDisableAppInsights(@Nullable Boolean disableAppInsights) {
        this.disableAppInsights = disableAppInsights;
    }
}

