/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.routing;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.documentdb.JsonSerializable;
import java.util.Comparator;
import org.json.JSONObject;

@JsonIgnoreProperties(value={"empty", "singleValue", "hashMap"})
public final class Range<T extends Comparable<T>>
extends JsonSerializable {
    private static final String MIN_PROPERTY = "min";
    private static final String MAX_PROPERTY = "max";
    private static final String IS_MIN_INCLUSIVE_PROPERTY = "isMinInclusive";
    private static final String IS_MAX_INCLUSIVE_PROPERTY = "isMaxInclusive";
    private T minValue;
    private T maxValue;

    public Range() {
    }

    public Range(String jsonString) {
        super(jsonString);
    }

    public Range(JSONObject jsonObject) {
        super(jsonObject);
    }

    public Range(T min, T max, boolean isMinInclusive, boolean isMaxInclusive) {
        this.setMin(min);
        this.setMax(max);
        this.setMinInclusive(isMinInclusive);
        this.setMaxInclusive(isMaxInclusive);
    }

    public static <T extends Comparable<T>> Range<T> getPointRange(T value) {
        return new Range<T>(value, value, true, true);
    }

    public static <T extends Comparable<T>> Range<T> getEmptyRange(T value) {
        return new Range<T>(value, value, true, false);
    }

    public static <T extends Comparable<T>> boolean checkOverlapping(Range<T> range1, Range<T> range2) {
        if (range1 == null || range2 == null || range1.isEmpty() || range2.isEmpty()) {
            return false;
        }
        int cmp1 = range1.getMin().compareTo(range2.getMax());
        int cmp2 = range2.getMin().compareTo(range1.getMax());
        if (cmp1 <= 0 && cmp2 <= 0) {
            return (cmp1 != 0 || range1.isMinInclusive() && range2.isMaxInclusive()) && (cmp2 != 0 || range2.isMinInclusive() && range1.isMaxInclusive());
        }
        return false;
    }

    public T getMin() {
        if (this.minValue == null) {
            this.minValue = (Comparable)super.get(MIN_PROPERTY);
        }
        return this.minValue;
    }

    public void setMin(T min) {
        this.minValue = min;
    }

    public T getMax() {
        if (this.maxValue == null) {
            this.maxValue = (Comparable)super.get(MAX_PROPERTY);
        }
        return this.maxValue;
    }

    public void setMax(T max) {
        this.maxValue = max;
    }

    @JsonProperty(value="isMinInclusive")
    public boolean isMinInclusive() {
        return super.getBoolean(IS_MIN_INCLUSIVE_PROPERTY);
    }

    public void setMinInclusive(boolean isMinInclusive) {
        super.set(IS_MIN_INCLUSIVE_PROPERTY, isMinInclusive);
    }

    @JsonProperty(value="isMaxInclusive")
    public boolean isMaxInclusive() {
        return super.getBoolean(IS_MAX_INCLUSIVE_PROPERTY);
    }

    public void setMaxInclusive(boolean isMaxInclusive) {
        super.set(IS_MAX_INCLUSIVE_PROPERTY, isMaxInclusive);
    }

    public boolean isSingleValue() {
        return this.isMinInclusive() && this.isMaxInclusive() && this.getMin().compareTo(this.getMax()) == 0;
    }

    public boolean isEmpty() {
        return this.getMin().compareTo(this.getMax()) == 0 && (!this.isMinInclusive() || !this.isMaxInclusive());
    }

    public boolean contains(T value) {
        int minToValueRelation = this.getMin().compareTo(value);
        int maxToValueRelation = this.getMax().compareTo(value);
        return (this.isMinInclusive() && minToValueRelation <= 0 || !this.isMinInclusive() && minToValueRelation < 0) && (this.isMaxInclusive() && maxToValueRelation >= 0 || !this.isMaxInclusive() && maxToValueRelation > 0);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Range)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Range otherRange = (Range)obj;
        return this.getMin().compareTo(otherRange.getMin()) == 0 && this.getMax().compareTo(otherRange.getMax()) == 0 && this.isMinInclusive() == otherRange.isMinInclusive() && this.isMaxInclusive() == otherRange.isMaxInclusive();
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 397 ^ this.getMin().hashCode();
        hash = hash * 397 ^ this.getMax().hashCode();
        hash = hash * 397 ^ Boolean.compare(this.isMinInclusive(), false);
        hash = hash * 397 ^ Boolean.compare(this.isMaxInclusive(), false);
        return hash;
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    @Override
    public String toJson() {
        return "" + (this.isMinInclusive() ? (char)'[' : ')') + this.getMin() + ',' + this.getMax() + (this.isMaxInclusive() ? (char)']' : ')');
    }

    public static class MaxComparator<T extends Comparable<T>>
    implements Comparator<Range<T>> {
        @Override
        public int compare(Range<T> range1, Range<T> range2) {
            int result = range1.getMax().compareTo(range2.getMax());
            if (result != 0 || range1.isMaxInclusive() == range2.isMaxInclusive()) {
                return result;
            }
            return range1.isMaxInclusive() ? 1 : -1;
        }
    }

    public static class MinComparator<T extends Comparable<T>>
    implements Comparator<Range<T>> {
        @Override
        public int compare(Range<T> range1, Range<T> range2) {
            int result = range1.getMin().compareTo(range2.getMin());
            if (result != 0 || range1.isMinInclusive() == range2.isMinInclusive()) {
                return result;
            }
            return range1.isMinInclusive() ? -1 : 1;
        }
    }
}

