/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.routing;

import com.fasterxml.jackson.core.JsonGenerator;
import com.microsoft.azure.documentdb.internal.routing.IPartitionKeyComponent;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyComponentType;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class NumberPartitionKeyComponent
implements IPartitionKeyComponent {
    public static final NumberPartitionKeyComponent Zero = new NumberPartitionKeyComponent(0.0);
    private final double value;

    public NumberPartitionKeyComponent(double value) {
        this.value = value;
    }

    private static byte[] doubleToByteArray(double d) {
        byte[] output = new byte[8];
        long lng = Double.doubleToLongBits(d);
        for (int i = 0; i < 8; ++i) {
            output[i] = (byte)(lng >> i * 8 & 0xFFL);
        }
        return output;
    }

    private static long EncodeDoubleAsUInt64(double value) {
        BigInteger maskLongValue;
        long rawLongBits = Double.doubleToRawLongBits(value);
        long mask = Long.MIN_VALUE;
        BigInteger longValue = new BigInteger(Long.toBinaryString(rawLongBits), 2);
        return longValue.compareTo(maskLongValue = new BigInteger(Long.toBinaryString(mask), 2)) < 0 ? rawLongBits ^ mask : (rawLongBits ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
    }

    @Override
    public int CompareTo(IPartitionKeyComponent other) {
        if (!(other instanceof NumberPartitionKeyComponent)) {
            throw new IllegalArgumentException("other");
        }
        return Double.compare(this.value, ((NumberPartitionKeyComponent)other).value);
    }

    @Override
    public int GetTypeOrdinal() {
        return PartitionKeyComponentType.NUMBER.type;
    }

    @Override
    public void JsonEncode(JsonGenerator writer) {
        try {
            writer.writeNumber(String.valueOf(this.value));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void WriteForHashing(OutputStream outputStream) {
        try {
            outputStream.write((byte)PartitionKeyComponentType.NUMBER.type);
            outputStream.write(NumberPartitionKeyComponent.doubleToByteArray(this.value));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void WriteForBinaryEncoding(OutputStream outputStream) {
        try {
            outputStream.write((byte)PartitionKeyComponentType.NUMBER.type);
            long payload = NumberPartitionKeyComponent.EncodeDoubleAsUInt64(this.value);
            outputStream.write((byte)(payload >> 56));
            payload <<= 8;
            int byteToWrite = 0;
            boolean firstIteration = true;
            do {
                if (!firstIteration) {
                    outputStream.write(byteToWrite);
                } else {
                    firstIteration = false;
                }
                byteToWrite = (byte)(payload >> 56 | 1L);
            } while ((payload <<= 7) != 0L);
            outputStream.write((byte)(byteToWrite & 0xFE));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void WriteForHashingV2(OutputStream outputStream) {
        try {
            outputStream.write((byte)PartitionKeyComponentType.NUMBER.type);
            outputStream.write(NumberPartitionKeyComponent.doubleToByteArray(this.value));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public IPartitionKeyComponent Truncate() {
        return this;
    }
}

