/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal.directconnectivity;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.internal.BridgeInternal;
import com.microsoft.azure.documentdb.internal.DocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoneAndRetryWithRetryPolicy
implements RetryPolicy {
    private static final int SECONDS_TO_MILLIS = 1000;
    private static final int INITIALI_BACKOFF_SEONDS = 1;
    public static final int WAIT_TIME_IN_SECONDS = 30;
    public static final int INITIALI_BACKOFF_MILLISEONDS = 1000;
    public static final int BACKOFF_MULTIPLIER = 2;
    private final Logger LOGGER = LoggerFactory.getLogger(GoneAndRetryWithRetryPolicy.class);
    private int attemptCount = 1;
    private DocumentClientException lastRetryWithException;
    private long currentBackOffMilliSeconds = 1000L;
    private DocumentServiceRequest request;
    private long startTimeMilliSeconds;
    private long retryAfterMilliSeconds;
    private boolean retryPartitionKeyRangeIdentity = true;
    private long retryWithInitialBackoffMilliseconds;
    private int retryWithBackoffMultiplier;

    public GoneAndRetryWithRetryPolicy(DocumentServiceRequest request, long retryWithInitialBackoffMilliseconds, int retryWithBackoffMultiplier) {
        this.request = request;
        this.startTimeMilliSeconds = System.currentTimeMillis();
        this.retryWithBackoffMultiplier = retryWithBackoffMultiplier > 0 ? retryWithBackoffMultiplier : 2;
        this.retryWithInitialBackoffMilliseconds = retryWithInitialBackoffMilliseconds > 0L ? retryWithInitialBackoffMilliseconds : 1000L;
    }

    @Override
    public boolean shouldRetry(DocumentClientException exception) throws DocumentClientException {
        if (exception.getStatusCode() != 410 && exception.getStatusCode() != 449) {
            return false;
        }
        Integer substatusCode = exception.getSubStatusCode();
        if (substatusCode != null && substatusCode == 1002 && BridgeInternal.isUserProvidedPartitionKeyRangeIdentity(this.request)) {
            if (this.retryPartitionKeyRangeIdentity) {
                this.request.setForcePartitionKeyRangeRefresh(true);
                this.retryPartitionKeyRangeIdentity = false;
            } else {
                this.LOGGER.warn("Received invalid partition id from user, retry won't happen, failing the request", (Throwable)exception);
                return false;
            }
        }
        if (exception.getStatusCode() == 449) {
            this.lastRetryWithException = exception;
        }
        this.retryAfterMilliSeconds = 0L;
        if (this.attemptCount++ > 1) {
            long remainingSeconds = 30 - (int)((double)(System.currentTimeMillis() - this.startTimeMilliSeconds) * 1.0 / 1000.0);
            if (remainingSeconds <= 0L) {
                if (exception.getStatusCode() == 410) {
                    String exceptionName;
                    String string = exceptionName = substatusCode != null && substatusCode == 1000 ? "invalid partition exception" : "gone exception";
                    if (this.lastRetryWithException != null) {
                        this.LOGGER.warn("Received {} after backoff/retry including at least one RetryWithException. Will fail the request with RetryWithException", (Object)exceptionName, (Object)this.lastRetryWithException);
                        throw this.lastRetryWithException;
                    }
                    this.LOGGER.warn("Received {} after backoff/retry. Will fail the request", (Object)exceptionName, (Object)exception);
                    throw new DocumentClientException(503, exception);
                }
                this.LOGGER.warn("Received retryWith exception after backoff/retry. Will fail the request", (Throwable)exception);
                return false;
            }
            int multiplierToUse = 2;
            if (exception.getStatusCode() == 449) {
                multiplierToUse = this.retryWithBackoffMultiplier;
                if (this.currentBackOffMilliSeconds == 1000L) {
                    this.currentBackOffMilliSeconds = this.retryWithInitialBackoffMilliseconds;
                }
            }
            this.retryAfterMilliSeconds = Math.min(this.currentBackOffMilliSeconds, remainingSeconds * 1000L);
            this.currentBackOffMilliSeconds *= (long)multiplierToUse;
        }
        if (exception.getStatusCode() == 410) {
            if (substatusCode != null && substatusCode == 1000) {
                this.request.setQuorumSelectedLSN(-1L);
                this.request.setQuorumSelectedStoreResponse(null);
                this.request.setForceNameCacheRefresh(true);
                this.LOGGER.debug("Received Gone exception with sub status name_cach_ is_stale " + substatusCode + ", will retry with name cache refresh");
            } else if (substatusCode != null && (substatusCode == 1007 || substatusCode == 1008 || substatusCode == 1002)) {
                this.request.setForcePartitionKeyRangeRefresh(true);
                this.LOGGER.debug("Received Gone exception with sub status " + substatusCode + ", will retry with partition key range cache refresh");
            }
            this.request.setForceAddressRefresh(true);
            this.LOGGER.debug("Received Gone exception, will retry with address cache refresh");
        } else {
            this.LOGGER.debug("Received retryWith exception, will retry", (Throwable)exception);
        }
        return true;
    }

    @Override
    public long getRetryAfterInMilliseconds() {
        return this.retryAfterMilliSeconds;
    }
}

