/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.Resource;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.documentdb.internal.AbstractDocumentServiceRequest;
import com.microsoft.azure.documentdb.internal.OperationType;
import com.microsoft.azure.documentdb.internal.PathsHelper;
import com.microsoft.azure.documentdb.internal.QueryCompatibilityMode;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.Utils;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;

public class DocumentServiceRequest
extends AbstractDocumentServiceRequest {
    private HttpEntity body;

    private DocumentServiceRequest(OperationType operationType, String resourceId, ResourceType resourceType, HttpEntity body, String path, Map<String, String> headers) {
        super(operationType, resourceId, resourceType, path, headers);
        this.body = body;
    }

    private DocumentServiceRequest(OperationType operationType, ResourceType resourceType, String path, HttpEntity body, Map<String, String> headers) {
        this(operationType, DocumentServiceRequest.extractIdFromUri(path), resourceType, body, path, headers);
    }

    public HttpEntity getBody() {
        return this.body;
    }

    public static DocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, InputStream stream, Map<String, String> headers) {
        InputStreamEntity body = new InputStreamEntity(stream, -1L);
        return new DocumentServiceRequest(operation, resourceType, relativePath, (HttpEntity)body, headers);
    }

    public static DocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, Resource resource, Map<String, String> headers) {
        StringEntity body = new StringEntity(resource.toJson(), StandardCharsets.UTF_8);
        return new DocumentServiceRequest(operation, resourceType, relativePath, (HttpEntity)body, headers);
    }

    public static DocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, String query, Map<String, String> headers) {
        StringEntity body = new StringEntity(query, StandardCharsets.UTF_8);
        return new DocumentServiceRequest(operation, resourceType, relativePath, (HttpEntity)body, headers);
    }

    public static DocumentServiceRequest create(ResourceType resourceType, String relativePath, SqlQuerySpec querySpec, QueryCompatibilityMode queryCompatibilityMode, Map<String, String> headers) {
        String queryText;
        OperationType operation;
        switch (queryCompatibilityMode) {
            case SqlQuery: {
                if (querySpec.getParameters() != null && querySpec.getParameters().size() > 0) {
                    throw new IllegalArgumentException(String.format("Unsupported argument in query compatibility mode '{%s}'", queryCompatibilityMode.name()));
                }
                operation = OperationType.SqlQuery;
                queryText = querySpec.getQueryText();
                break;
            }
            default: {
                operation = OperationType.Query;
                queryText = querySpec.toJson();
            }
        }
        StringEntity body = new StringEntity(queryText, StandardCharsets.UTF_8);
        return new DocumentServiceRequest(operation, resourceType, relativePath, (HttpEntity)body, headers);
    }

    public static DocumentServiceRequest create(OperationType operation, ResourceType resourceType, String relativePath, Map<String, String> headers) {
        return new DocumentServiceRequest(operation, resourceType, relativePath, null, headers);
    }

    public static DocumentServiceRequest create(OperationType operation, String resourceId, ResourceType resourceType, Map<String, String> headers) {
        String path = PathsHelper.generatePath(resourceType, resourceId, Utils.isFeedRequest(operation));
        return new DocumentServiceRequest(operation, resourceId, resourceType, null, path, headers);
    }
}

