/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb.internal;

import com.microsoft.azure.documentdb.internal.AuthorizationTokenProvider;
import com.microsoft.azure.documentdb.internal.PathsHelper;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.Utils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class BaseAuthorizationTokenProvider
implements AuthorizationTokenProvider {
    private String masterKey;
    private Map<String, String> resourceTokens;
    private Mac macInstance;

    public BaseAuthorizationTokenProvider(String masterKey, Map<String, String> resourceTokens) {
        this.masterKey = masterKey;
        this.resourceTokens = resourceTokens;
        if (this.masterKey != null) {
            byte[] masterKeyDecodedBytes = Base64.decodeBase64((byte[])this.masterKey.getBytes());
            SecretKeySpec signingKey = new SecretKeySpec(masterKeyDecodedBytes, "HMACSHA256");
            try {
                this.macInstance = Mac.getInstance("HMACSHA256");
                this.macInstance.init(signingKey);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public String generateKeyAuthorizationSignature(String verb, String resourceIdOrFullName, ResourceType resourceType, Map<String, String> headers) {
        return this.generateKeyAuthorizationSignature(verb, resourceIdOrFullName, Utils.getResourceSegement(resourceType).toLowerCase(), headers);
    }

    public String generateKeyAuthorizationSignature(String verb, String resourceIdOrFullName, String resourceSegment, Map<String, String> headers) {
        if (verb == null || verb.isEmpty()) {
            throw new IllegalArgumentException("verb");
        }
        if (resourceIdOrFullName == null) {
            resourceIdOrFullName = "";
        }
        if (resourceSegment == null) {
            throw new IllegalArgumentException("resourceSegment");
        }
        if (headers == null) {
            throw new IllegalArgumentException("headers");
        }
        if (this.masterKey == null || this.masterKey.isEmpty()) {
            throw new IllegalArgumentException("masterKey");
        }
        if (!PathsHelper.isNameBased(resourceIdOrFullName)) {
            resourceIdOrFullName = resourceIdOrFullName.toLowerCase(Locale.ROOT);
        }
        String body = String.format("%s\n%s\n%s\n", verb.toLowerCase(), resourceSegment, resourceIdOrFullName);
        if (headers.containsKey("x-ms-date")) {
            body = body + headers.get("x-ms-date").toLowerCase();
        }
        body = body + '\n';
        if (headers.containsKey("date")) {
            body = body + headers.get("date").toLowerCase();
        }
        body = body + '\n';
        Mac mac = null;
        try {
            mac = (Mac)this.macInstance.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
        byte[] digest = mac.doFinal(body.getBytes());
        String auth = Utils.encodeBase64String(digest);
        String authtoken = "type=master&ver=1.0&sig=" + auth;
        return authtoken;
    }

    @Override
    public String getAuthorizationTokenUsingResourceTokens(String path, String resourceId) {
        if (this.resourceTokens == null) {
            throw new IllegalArgumentException("resourceTokens");
        }
        String resourceToken = null;
        if (this.resourceTokens.containsKey(resourceId) && this.resourceTokens.get(resourceId) != null) {
            resourceToken = this.resourceTokens.get(resourceId);
        } else if (StringUtils.isEmpty((CharSequence)path) || StringUtils.isEmpty((CharSequence)resourceId)) {
            if (this.resourceTokens.size() > 0) {
                resourceToken = this.resourceTokens.values().iterator().next();
            }
        } else {
            String[] pathParts = StringUtils.split((String)path, (char)'/');
            String[] resourceTypes = new String[]{"dbs", "colls", "docs", "sprocs", "udfs", "triggers", "users", "permissions", "attachments", "media", "conflicts"};
            HashSet<String> resourceTypesSet = new HashSet<String>();
            for (String resourceType : resourceTypes) {
                resourceTypesSet.add(resourceType);
            }
            for (int i = pathParts.length - 1; i >= 0; --i) {
                if (resourceTypesSet.contains(pathParts[i]) || !this.resourceTokens.containsKey(pathParts[i])) continue;
                resourceToken = this.resourceTokens.get(pathParts[i]);
            }
        }
        return resourceToken;
    }

    @Override
    public String getMasterKey() {
        return this.masterKey;
    }

    @Override
    public Map<String, String> getResourceTokens() {
        return this.resourceTokens;
    }
}

