/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.documentdb;

import com.microsoft.azure.documentdb.ConflictResolutionMode;
import com.microsoft.azure.documentdb.JsonSerializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class ConflictResolutionPolicy
extends JsonSerializable {
    public ConflictResolutionPolicy() {
    }

    public static ConflictResolutionPolicy createLastWriterWinsPolicy() {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.setConflictResolutionMode(ConflictResolutionMode.LastWriterWins);
        return policy;
    }

    public static ConflictResolutionPolicy createLastWriterWinsPolicy(String path) {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.setConflictResolutionMode(ConflictResolutionMode.LastWriterWins);
        if (path != null) {
            policy.setConflictResolutionPath(path);
        }
        return policy;
    }

    public static ConflictResolutionPolicy createCustomPolicy(String sprocLink) {
        ConflictResolutionPolicy policy = new ConflictResolutionPolicy();
        policy.setConflictResolutionMode(ConflictResolutionMode.Custom);
        if (sprocLink != null) {
            policy.setConflictResolutionProcedure(sprocLink);
        }
        return policy;
    }

    public ConflictResolutionPolicy(String jsonString) {
        super(jsonString);
    }

    public ConflictResolutionMode getConflictResolutionMode() {
        String strValue = super.getString("mode");
        if (!StringUtils.isEmpty((CharSequence)strValue)) {
            try {
                return ConflictResolutionMode.valueOf(WordUtils.capitalize((String)super.getString("mode")));
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warn("Invalid ConflictResolutionMode value {}.", (Object)super.getString("mode"));
                return ConflictResolutionMode.Invalid;
            }
        }
        return ConflictResolutionMode.Invalid;
    }

    private void setConflictResolutionMode(ConflictResolutionMode mode) {
        super.set("mode", mode.name());
    }

    public String getConflictResolutionPath() {
        return super.getString("conflictResolutionPath");
    }

    private void setConflictResolutionPath(String value) {
        super.set("conflictResolutionPath", value);
    }

    public String getConflictResolutionProcedure() {
        return super.getString("conflictResolutionProcedure");
    }

    private void setConflictResolutionProcedure(String value) {
        super.set("conflictResolutionProcedure", value);
    }
}

