package com.microsoft.azure.documentdb.internal.routing;

import java.util.Collection;

import com.microsoft.azure.documentdb.PartitionKeyRange;

/**
 * Used internally in request routing in the Azure Cosmos DB database service.
 */
public interface RoutingMapProvider {
    Collection<PartitionKeyRange> getOverlappingRanges(String collectionSelfLink, Range<String> range, boolean forceRefresh);

    PartitionKeyRange tryGetRangeByEffectivePartitionKey(String collectionSelfLink, String effectivePartitionKey);

    PartitionKeyRange getPartitionKeyRangeById(String collectionSelfLink, String partitionKeyRangeId, boolean forceRefresh);

}
