package com.microsoft.azure.documentdb.internal.routing;


import java.util.concurrent.ExecutorService;

import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.internal.CollectionCacheInternal;
import com.microsoft.azure.documentdb.internal.PathsHelper;
import com.microsoft.azure.documentdb.internal.ResourceType;
import com.microsoft.azure.documentdb.internal.Utils;

/**
 * Used internally to cache collection information in the Azure Cosmos DB database service.
 */
public class ClientCollectionCache extends CollectionCache {
    private CollectionCacheInternal documentClient;

    public ClientCollectionCache(CollectionCacheInternal documentClient, ExecutorService executorService) {
        super(executorService);
        this.documentClient = documentClient;
    }

    @Override
    protected DocumentCollection getByRid(String collectionRid) {
        return this.readCollection(
                Utils.joinPath(PathsHelper.generatePath(ResourceType.DocumentCollection, collectionRid, false), ""));
    }

    private DocumentCollection readCollection(String collectionLink) {
        String collectionName = Utils.getCollectionName(collectionLink);
        try {
            return documentClient.readCollection(collectionName, null).getResource();
        } catch (DocumentClientException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected DocumentCollection getByName(String resourceAddress) {
        return this.readCollection(resourceAddress);
    }
}
