package com.microsoft.azure.documentdb.internal.query.orderbyquery;

import java.util.*;

import org.json.JSONObject;

import com.microsoft.azure.documentdb.*;
import com.microsoft.azure.documentdb.internal.query.QueryItem;

/**
 * Represents the result of a query in the Azure Cosmos DB database service.
 */
public final class OrderByQueryResult extends Document {
    private List<QueryItem> orderByItems;
    private Document payload;

    public OrderByQueryResult(String jsonString) {
        super(jsonString);
    }

    public OrderByQueryResult(JSONObject jsonObject) {
        super(jsonObject);
    }

    public List<QueryItem> getOrderByItems() {
        return this.orderByItems != null ? this.orderByItems
                : (this.orderByItems = (List<QueryItem>) super.getCollection("orderByItems", QueryItem.class));
    }

    public Document getPayload() {
        return this.payload != null ? this.payload : (this.payload = super.getObject("payload", Document.class));
    }
}