package com.microsoft.azure.documentdb.internal.directconnectivity;

import com.microsoft.azure.documentdb.internal.RequestChargeTracker;

class ReadQuorumResult extends ReadResult {
    private ReadQuorumResultKind quorumResult;
    private long selectedLsn;
    private long globalCommittedLSN;

    protected ReadQuorumResult(ReadQuorumResultKind quorumResult,
                               long selectedLSN,
                               long globalCommittedLSN,
                               StoreReadResult response,
                               RequestChargeTracker requestChargeTracker) {
        super(response, requestChargeTracker);
        this.quorumResult = quorumResult;
        this.selectedLsn = selectedLSN;
        this.globalCommittedLSN = globalCommittedLSN;
    }

    public ReadQuorumResultKind getQuorumResult() {
        return quorumResult;
    }

    public long getSelectedLsn() {
        return selectedLsn;
    }

    public long getGlobalCommittedLSN() {
        return globalCommittedLSN;
    }

    @Override
    protected boolean isValidResult() {
        return this.quorumResult == ReadQuorumResultKind.QuorumMet || this.quorumResult == ReadQuorumResultKind.QuorumSelected;
    }
}