package com.microsoft.azure.documentdb;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONObject;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.azure.documentdb.internal.Constants;
import com.microsoft.azure.documentdb.internal.routing.PartitionKeyInternal;

/**
 * Represents the statistics of a logical partition key in the Azure Cosmos DB service.
 */
public class PartitionKeyStatistics extends JsonSerializable {
    
    /**
     * Initialize a PartitionKeyStatistics object using the input JSON string.
     *
     * @param jsonString the json string that represents the Partition Key Statistics for the logical key within a physical partition.
     */
    public PartitionKeyStatistics(String jsonString) {
        super(jsonString);
    }
    
    /**
     * Constructor.
     *
     * @param jsonObject the json object that represents the Partition Key Statistics for the logical key within a physical partition.
     */
    public PartitionKeyStatistics(JSONObject jsonObject) {
        super(jsonObject);
    }
    
    /**
     * Gets the sizeInKB property.
     *
     * @return the size (in KB) of the logical partition key value.
     */
    public long getSizeInKB() {
        return super.getLong(Constants.Properties.SIZE_IN_KB);
    }
    
    public PartitionKey getPartitionKey() {
        List<Object> objList = new ArrayList<Object>(super.getCollection(Constants.Properties.PARTITION_KEY, Object.class));        
        return new PartitionKey(objList.get(0));
    }
    
    /**
     * Serialize the PartitionKeyStatistics object to a JSON string.
     *
     * @return the string representation of this PartitionKeyStatistics object.
     */
    public String toString() {
        JSONObject jsonObject = new JSONObject(this);
        return jsonObject.toString();
    }
}
