/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.azure.cosmosdb.AccessConditionType;
import com.microsoft.azure.cosmosdb.Attachment;
import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.ChangeFeedOptions;
import com.microsoft.azure.cosmosdb.Conflict;
import com.microsoft.azure.cosmosdb.ConnectionMode;
import com.microsoft.azure.cosmosdb.ConnectionPolicy;
import com.microsoft.azure.cosmosdb.ConsistencyLevel;
import com.microsoft.azure.cosmosdb.CosmosResourceType;
import com.microsoft.azure.cosmosdb.Database;
import com.microsoft.azure.cosmosdb.DatabaseAccount;
import com.microsoft.azure.cosmosdb.DatabaseAccountManagerInternal;
import com.microsoft.azure.cosmosdb.Document;
import com.microsoft.azure.cosmosdb.DocumentCollection;
import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedOptionsBase;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.ISessionContainer;
import com.microsoft.azure.cosmosdb.JsonSerializable;
import com.microsoft.azure.cosmosdb.MediaOptions;
import com.microsoft.azure.cosmosdb.MediaReadMode;
import com.microsoft.azure.cosmosdb.MediaResponse;
import com.microsoft.azure.cosmosdb.Offer;
import com.microsoft.azure.cosmosdb.PartitionKey;
import com.microsoft.azure.cosmosdb.PartitionKeyDefinition;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.Permission;
import com.microsoft.azure.cosmosdb.RequestOptions;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.ResourceResponse;
import com.microsoft.azure.cosmosdb.SqlQuerySpec;
import com.microsoft.azure.cosmosdb.StoredProcedure;
import com.microsoft.azure.cosmosdb.StoredProcedureResponse;
import com.microsoft.azure.cosmosdb.TokenResolver;
import com.microsoft.azure.cosmosdb.Trigger;
import com.microsoft.azure.cosmosdb.Undefined;
import com.microsoft.azure.cosmosdb.User;
import com.microsoft.azure.cosmosdb.UserDefinedFunction;
import com.microsoft.azure.cosmosdb.internal.BaseAuthorizationTokenProvider;
import com.microsoft.azure.cosmosdb.internal.LifeCycleUtils;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.PathInfo;
import com.microsoft.azure.cosmosdb.internal.PathParser;
import com.microsoft.azure.cosmosdb.internal.PathsHelper;
import com.microsoft.azure.cosmosdb.internal.QueryCompatibilityMode;
import com.microsoft.azure.cosmosdb.internal.ResourceTokenAuthorizationHelper;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.SessionContainer;
import com.microsoft.azure.cosmosdb.internal.UserAgentContainer;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GatewayServiceConfigurationReader;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.IAddressResolver;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.ServerStoreModel;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreClient;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreClientFactory;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyAndResourceTokenPair;
import com.microsoft.azure.cosmosdb.internal.routing.PartitionKeyInternal;
import com.microsoft.azure.cosmosdb.rx.AsyncDocumentClient;
import com.microsoft.azure.cosmosdb.rx.internal.AuthorizationTokenType;
import com.microsoft.azure.cosmosdb.rx.internal.ChangeFeedQueryImpl;
import com.microsoft.azure.cosmosdb.rx.internal.Configs;
import com.microsoft.azure.cosmosdb.rx.internal.GlobalEndpointManager;
import com.microsoft.azure.cosmosdb.rx.internal.HttpClientFactory;
import com.microsoft.azure.cosmosdb.rx.internal.IAuthorizationTokenProvider;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.IRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.IRetryPolicyFactory;
import com.microsoft.azure.cosmosdb.rx.internal.ObservableHelper;
import com.microsoft.azure.cosmosdb.rx.internal.PartitionKeyMismatchRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.ResetSessionTokenRetryPolicyFactory;
import com.microsoft.azure.cosmosdb.rx.internal.RetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceResponse;
import com.microsoft.azure.cosmosdb.rx.internal.RxGatewayStoreModel;
import com.microsoft.azure.cosmosdb.rx.internal.RxStoreModel;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxClientCollectionCache;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxCollectionCache;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxPartitionKeyRangeCache;
import com.microsoft.azure.cosmosdb.rx.internal.directconnectivity.GlobalAddressResolver;
import com.microsoft.azure.cosmosdb.rx.internal.query.DocumentQueryExecutionContextFactory;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryClient;
import com.microsoft.azure.cosmosdb.rx.internal.query.Paginator;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.protocol.http.client.CompositeHttpClient;
import io.reactivex.netty.protocol.http.client.CompositeHttpClientBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Single;
import rx.functions.Func1;
import rx.functions.Func2;

public class RxDocumentClientImpl
implements AsyncDocumentClient,
IAuthorizationTokenProvider {
    private static final ObjectMapper mapper = Utils.getSimpleObjectMapper();
    private final Logger logger = LoggerFactory.getLogger(RxDocumentClientImpl.class);
    private final String masterKeyOrResourceToken;
    private final URI serviceEndpoint;
    private final ConnectionPolicy connectionPolicy;
    private final ConsistencyLevel consistencyLevel;
    private final BaseAuthorizationTokenProvider authorizationTokenProvider;
    private final UserAgentContainer userAgentContainer;
    private final boolean hasAuthKeyResourceToken;
    private final Configs configs;
    private TokenResolver tokenResolver;
    private SessionContainer sessionContainer;
    private String firstResourceTokenFromPermissionFeed = "";
    private RxClientCollectionCache collectionCache;
    private RxStoreModel gatewayProxy;
    private RxStoreModel storeModel;
    private GlobalAddressResolver addressResolver;
    private RxPartitionKeyRangeCache partitionKeyRangeCache;
    private Map<String, List<PartitionKeyAndResourceTokenPair>> resourceTokensMap;
    private IRetryPolicyFactory resetSessionTokenRetryPolicy;
    private final QueryCompatibilityMode queryCompatibilityMode = QueryCompatibilityMode.Default;
    private final CompositeHttpClient<ByteBuf, ByteBuf> rxClient;
    private final GlobalEndpointManager globalEndpointManager;
    private final RetryPolicy retryPolicy;
    private volatile boolean useMultipleWriteLocations;
    private StoreClientFactory storeClientFactory;
    private GatewayServiceConfigurationReader gatewayConfigurationReader;

    public RxDocumentClientImpl(URI serviceEndpoint, String masterKeyOrResourceToken, List<Permission> permissionFeed, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, Configs configs, TokenResolver tokenResolver) {
        this(serviceEndpoint, masterKeyOrResourceToken, permissionFeed, connectionPolicy, consistencyLevel, configs);
        this.tokenResolver = tokenResolver;
    }

    public RxDocumentClientImpl(URI serviceEndpoint, String masterKeyOrResourceToken, List<Permission> permissionFeed, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, Configs configs) {
        this(serviceEndpoint, masterKeyOrResourceToken, connectionPolicy, consistencyLevel, configs);
        if (permissionFeed != null && permissionFeed.size() > 0) {
            this.resourceTokensMap = new HashMap<String, List<PartitionKeyAndResourceTokenPair>>();
            for (Permission permission : permissionFeed) {
                PartitionKey partitionKey;
                String[] segments = StringUtils.split((String)permission.getResourceLink(), (char)"/".charAt(0));
                if (segments.length <= 0) {
                    throw new IllegalArgumentException("resourceLink");
                }
                List<PartitionKeyAndResourceTokenPair> partitionKeyAndResourceTokenPairs = null;
                PathInfo pathInfo = new PathInfo(false, "", "", false);
                if (!PathsHelper.tryParsePathSegments((String)permission.getResourceLink(), (PathInfo)pathInfo, null)) {
                    throw new IllegalArgumentException(permission.getResourceLink());
                }
                partitionKeyAndResourceTokenPairs = this.resourceTokensMap.get(pathInfo.resourceIdOrFullName);
                if (partitionKeyAndResourceTokenPairs == null) {
                    partitionKeyAndResourceTokenPairs = new ArrayList<PartitionKeyAndResourceTokenPair>();
                    this.resourceTokensMap.put(pathInfo.resourceIdOrFullName, partitionKeyAndResourceTokenPairs);
                }
                partitionKeyAndResourceTokenPairs.add(new PartitionKeyAndResourceTokenPair((partitionKey = permission.getResourcePartitionKey()) != null ? partitionKey.getInternalPartitionKey() : PartitionKeyInternal.Empty, permission.getToken()));
                this.logger.debug("Initializing resource token map  , with map key [{}] , partition key [{}] and resource token", new Object[]{pathInfo.resourceIdOrFullName, partitionKey != null ? partitionKey.toString() : null, permission.getToken()});
            }
            if (this.resourceTokensMap.isEmpty()) {
                throw new IllegalArgumentException("permissionFeed");
            }
            String firstToken = permissionFeed.get(0).getToken();
            if (ResourceTokenAuthorizationHelper.isResourceToken((String)firstToken)) {
                this.firstResourceTokenFromPermissionFeed = firstToken;
            }
        }
    }

    public RxDocumentClientImpl(URI serviceEndpoint, String masterKeyOrResourceToken, ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, Configs configs) {
        this.logger.info("Initializing DocumentClient with serviceEndpoint [{}], connectionPolicy [{}], consistencyLevel [{}], protocol [{}]", new Object[]{serviceEndpoint, connectionPolicy, consistencyLevel, configs.getProtocol()});
        this.configs = configs;
        this.masterKeyOrResourceToken = masterKeyOrResourceToken;
        this.serviceEndpoint = serviceEndpoint;
        if (masterKeyOrResourceToken != null && ResourceTokenAuthorizationHelper.isResourceToken((String)masterKeyOrResourceToken)) {
            this.authorizationTokenProvider = null;
            this.hasAuthKeyResourceToken = true;
        } else if (masterKeyOrResourceToken != null && !ResourceTokenAuthorizationHelper.isResourceToken((String)masterKeyOrResourceToken)) {
            this.hasAuthKeyResourceToken = false;
            this.authorizationTokenProvider = new BaseAuthorizationTokenProvider(this.masterKeyOrResourceToken);
        } else {
            this.hasAuthKeyResourceToken = false;
            this.authorizationTokenProvider = null;
        }
        this.connectionPolicy = connectionPolicy != null ? connectionPolicy : new ConnectionPolicy();
        this.sessionContainer = new SessionContainer(this.serviceEndpoint.getHost());
        this.consistencyLevel = consistencyLevel;
        this.userAgentContainer = new UserAgentContainer();
        String userAgentSuffix = this.connectionPolicy.getUserAgentSuffix();
        if (userAgentSuffix != null && userAgentSuffix.length() > 0) {
            this.userAgentContainer.setSuffix(userAgentSuffix);
        }
        this.rxClient = (CompositeHttpClient)this.httpClientBuilder().build();
        this.globalEndpointManager = new GlobalEndpointManager(this.asDatabaseAccountManagerInternal(), this.connectionPolicy, configs);
        this.retryPolicy = new RetryPolicy(this.globalEndpointManager, this.connectionPolicy);
        this.resetSessionTokenRetryPolicy = this.retryPolicy;
    }

    private void initializeGatewayConfigurationReader() {
        String resourceToken;
        if (this.tokenResolver != null) {
            resourceToken = this.tokenResolver.getAuthorizationToken("GET", "", CosmosResourceType.System, null);
        } else if (!this.hasAuthKeyResourceToken && this.authorizationTokenProvider == null) {
            resourceToken = this.firstResourceTokenFromPermissionFeed;
        } else {
            assert (this.masterKeyOrResourceToken != null);
            resourceToken = this.masterKeyOrResourceToken;
        }
        this.gatewayConfigurationReader = new GatewayServiceConfigurationReader(this.serviceEndpoint, this.hasAuthKeyResourceToken, resourceToken, this.connectionPolicy, this.authorizationTokenProvider, this.rxClient);
        DatabaseAccount databaseAccount = (DatabaseAccount)this.gatewayConfigurationReader.initializeReaderAsync().toBlocking().value();
        this.useMultipleWriteLocations = this.connectionPolicy.isUsingMultipleWriteLocations() && BridgeInternal.isEnableMultipleWriteLocations((DatabaseAccount)databaseAccount);
        this.globalEndpointManager.refreshLocationAsync(databaseAccount, false).await();
    }

    public void init() {
        this.gatewayProxy = this.createRxGatewayProxy((ISessionContainer)this.sessionContainer, this.consistencyLevel, this.queryCompatibilityMode, this.userAgentContainer, this.globalEndpointManager, this.rxClient);
        this.globalEndpointManager.init();
        this.initializeGatewayConfigurationReader();
        this.collectionCache = new RxClientCollectionCache((ISessionContainer)this.sessionContainer, this.gatewayProxy, (IAuthorizationTokenProvider)this, (IRetryPolicyFactory)this.retryPolicy);
        this.resetSessionTokenRetryPolicy = new ResetSessionTokenRetryPolicyFactory((ISessionContainer)this.sessionContainer, this.collectionCache, (IRetryPolicyFactory)this.retryPolicy);
        this.partitionKeyRangeCache = new RxPartitionKeyRangeCache(this, (RxCollectionCache)this.collectionCache);
        if (this.connectionPolicy.getConnectionMode() == ConnectionMode.Gateway) {
            this.storeModel = this.gatewayProxy;
        } else {
            this.initializeDirectConnectivity();
        }
    }

    private void initializeDirectConnectivity() {
        this.storeClientFactory = new StoreClientFactory(this.configs, this.connectionPolicy.getRequestTimeoutInMillis() / 1000, 0, this.userAgentContainer);
        this.addressResolver = new GlobalAddressResolver(this.rxClient, this.globalEndpointManager, this.configs.getProtocol(), this, (RxCollectionCache)this.collectionCache, this.partitionKeyRangeCache, this.userAgentContainer, null, this.connectionPolicy);
        this.createStoreModel(true);
    }

    DatabaseAccountManagerInternal asDatabaseAccountManagerInternal() {
        return new DatabaseAccountManagerInternal(){

            public URI getServiceEndpoint() {
                return RxDocumentClientImpl.this.getServiceEndpoint();
            }

            public Observable<DatabaseAccount> getDatabaseAccountFromEndpoint(URI endpoint) {
                RxDocumentClientImpl.this.logger.info("Getting database account endpoint from {}", (Object)endpoint);
                return RxDocumentClientImpl.this.getDatabaseAccountFromEndpoint(endpoint);
            }

            public ConnectionPolicy getConnectionPolicy() {
                return RxDocumentClientImpl.this.getConnectionPolicy();
            }
        };
    }

    RxGatewayStoreModel createRxGatewayProxy(ISessionContainer sessionContainer, ConsistencyLevel consistencyLevel, QueryCompatibilityMode queryCompatibilityMode, UserAgentContainer userAgentContainer, GlobalEndpointManager globalEndpointManager, CompositeHttpClient<ByteBuf, ByteBuf> rxClient) {
        return new RxGatewayStoreModel(sessionContainer, consistencyLevel, queryCompatibilityMode, userAgentContainer, globalEndpointManager, rxClient);
    }

    private CompositeHttpClientBuilder<ByteBuf, ByteBuf> httpClientBuilder() {
        HttpClientFactory factory = new HttpClientFactory(this.configs).withMaxIdleConnectionTimeoutInMillis(this.connectionPolicy.getIdleConnectionTimeoutInMillis()).withPoolSize(this.connectionPolicy.getMaxPoolSize()).withHttpProxy(this.connectionPolicy.getProxy()).withRequestTimeoutInMillis(this.connectionPolicy.getRequestTimeoutInMillis());
        return factory.toHttpClientBuilder();
    }

    private void createStoreModel(boolean subscribeRntbdStatus) {
        StoreClient storeClient = this.storeClientFactory.createStoreClient((IAddressResolver)this.addressResolver, this.sessionContainer, this.gatewayConfigurationReader, (IAuthorizationTokenProvider)this, false);
        this.storeModel = new ServerStoreModel(storeClient);
    }

    @Override
    public URI getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    @Override
    public URI getWriteEndpoint() {
        return this.globalEndpointManager.getWriteEndpoints().stream().findFirst().map(loc -> {
            try {
                return loc.toURI();
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }).orElse(null);
    }

    @Override
    public URI getReadEndpoint() {
        return this.globalEndpointManager.getReadEndpoints().stream().findFirst().map(loc -> {
            try {
                return loc.toURI();
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException(e);
            }
        }).orElse(null);
    }

    @Override
    public ConnectionPolicy getConnectionPolicy() {
        return this.connectionPolicy;
    }

    @Override
    public Observable<ResourceResponse<Database>> createDatabase(Database database, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createDatabaseInternal(database, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Database>> createDatabaseInternal(Database database, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (database == null) {
                throw new IllegalArgumentException("Database");
            }
            this.logger.debug("Creating a Database. id: [{}]", (Object)database.getId());
            RxDocumentClientImpl.validateResource((Resource)database);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Create, (ResourceType)ResourceType.Database, (String)"/dbs", (Resource)database, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Database.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a database. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Database>> deleteDatabase(String databaseLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteDatabaseInternal(databaseLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Database>> deleteDatabaseInternal(String databaseLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)databaseLink)) {
                throw new IllegalArgumentException("databaseLink");
            }
            this.logger.debug("Deleting a Database. databaseLink: [{}]", (Object)databaseLink);
            String path = Utils.joinPath((String)databaseLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Delete, (ResourceType)ResourceType.Database, (String)path, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Database.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a database. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Database>> readDatabase(String databaseLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readDatabaseInternal(databaseLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Database>> readDatabaseInternal(String databaseLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)databaseLink)) {
                throw new IllegalArgumentException("databaseLink");
            }
            this.logger.debug("Reading a Database. databaseLink: [{}]", (Object)databaseLink);
            String path = Utils.joinPath((String)databaseLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Read, (ResourceType)ResourceType.Database, (String)path, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Database.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a database. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<FeedResponse<Database>> readDatabases(FeedOptions options) {
        return this.readFeed(options, ResourceType.Database, Database.class, "/dbs");
    }

    private String parentResourceLinkToQueryLink(String parentResouceLink, ResourceType resourceTypeEnum) {
        switch (resourceTypeEnum) {
            case Database: {
                return "/dbs";
            }
            case DocumentCollection: {
                return Utils.joinPath((String)parentResouceLink, (String)"colls");
            }
            case Document: {
                return Utils.joinPath((String)parentResouceLink, (String)"docs");
            }
            case Offer: {
                return "/offers/";
            }
            case User: {
                return Utils.joinPath((String)parentResouceLink, (String)"users");
            }
            case Permission: {
                return Utils.joinPath((String)parentResouceLink, (String)"permissions");
            }
            case Attachment: {
                return Utils.joinPath((String)parentResouceLink, (String)"attachments");
            }
            case StoredProcedure: {
                return Utils.joinPath((String)parentResouceLink, (String)"sprocs");
            }
            case Trigger: {
                return Utils.joinPath((String)parentResouceLink, (String)"triggers");
            }
            case UserDefinedFunction: {
                return Utils.joinPath((String)parentResouceLink, (String)"udfs");
            }
        }
        throw new IllegalArgumentException("resource type not supported");
    }

    private <T extends Resource> Observable<FeedResponse<T>> createQuery(String parentResourceLink, SqlQuerySpec sqlQuery, FeedOptions options, Class<T> klass, ResourceType resourceTypeEnum) {
        String queryResourceLink = this.parentResourceLinkToQueryLink(parentResourceLink, resourceTypeEnum);
        UUID activityId = Utils.randomUUID();
        IDocumentQueryClient queryClient = this.DocumentQueryClientImpl(this);
        Observable executionContext = DocumentQueryExecutionContextFactory.createDocumentQueryExecutionContextAsync((IDocumentQueryClient)queryClient, (ResourceType)resourceTypeEnum, klass, (SqlQuerySpec)sqlQuery, (FeedOptions)options, (String)queryResourceLink, (boolean)false, (UUID)activityId);
        return executionContext.single().flatMap(ex -> ex.executeAsync());
    }

    @Override
    public Observable<FeedResponse<Database>> queryDatabases(String query, FeedOptions options) {
        return this.queryDatabases(new SqlQuerySpec(query), options);
    }

    @Override
    public Observable<FeedResponse<Database>> queryDatabases(SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery("/dbs", querySpec, options, Database.class, ResourceType.Database);
    }

    @Override
    public Observable<ResourceResponse<DocumentCollection>> createCollection(String databaseLink, DocumentCollection collection, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createCollectionInternal(databaseLink, collection, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<DocumentCollection>> createCollectionInternal(String databaseLink, DocumentCollection collection, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)databaseLink)) {
                throw new IllegalArgumentException("databaseLink");
            }
            if (collection == null) {
                throw new IllegalArgumentException("collection");
            }
            this.logger.debug("Creating a Collection. databaseLink: [{}], Collection id: [{}]", (Object)databaseLink, (Object)collection.getId());
            RxDocumentClientImpl.validateResource((Resource)collection);
            String path = Utils.joinPath((String)databaseLink, (String)"colls");
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Create, (ResourceType)ResourceType.DocumentCollection, (String)path, (Resource)collection, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, DocumentCollection.class)).doOnNext(resourceResponse -> this.sessionContainer.setSessionToken(((DocumentCollection)resourceResponse.getResource()).getResourceId(), BridgeInternal.getAltLink((Resource)resourceResponse.getResource()), resourceResponse.getResponseHeaders()));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a collection. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<DocumentCollection>> replaceCollection(DocumentCollection collection, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceCollectionInternal(collection, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<DocumentCollection>> replaceCollectionInternal(DocumentCollection collection, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (collection == null) {
                throw new IllegalArgumentException("collection");
            }
            this.logger.debug("Replacing a Collection. id: [{}]", (Object)collection.getId());
            RxDocumentClientImpl.validateResource((Resource)collection);
            String path = Utils.joinPath((String)collection.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Replace, (ResourceType)ResourceType.DocumentCollection, (String)path, (Resource)collection, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, DocumentCollection.class)).doOnNext(resourceResponse -> {
                if (resourceResponse.getResource() != null) {
                    this.sessionContainer.setSessionToken(((DocumentCollection)resourceResponse.getResource()).getResourceId(), BridgeInternal.getAltLink((Resource)resourceResponse.getResource()), resourceResponse.getResponseHeaders());
                }
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a collection. due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<DocumentCollection>> deleteCollection(String collectionLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteCollectionInternal(collectionLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<DocumentCollection>> deleteCollectionInternal(String collectionLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)collectionLink)) {
                throw new IllegalArgumentException("collectionLink");
            }
            this.logger.debug("Deleting a Collection. collectionLink: [{}]", (Object)collectionLink);
            String path = Utils.joinPath((String)collectionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Delete, (ResourceType)ResourceType.DocumentCollection, (String)path, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, DocumentCollection.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a collection, due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    private Observable<RxDocumentServiceResponse> delete(RxDocumentServiceRequest request) {
        this.populateHeaders(request, "DELETE");
        return this.getStoreProxy(request).processMessage(request);
    }

    private Observable<RxDocumentServiceResponse> read(RxDocumentServiceRequest request) {
        this.populateHeaders(request, "GET");
        return this.getStoreProxy(request).processMessage(request);
    }

    Observable<RxDocumentServiceResponse> readFeed(RxDocumentServiceRequest request) {
        this.populateHeaders(request, "GET");
        return this.gatewayProxy.processMessage(request);
    }

    private Observable<RxDocumentServiceResponse> query(RxDocumentServiceRequest request) {
        this.populateHeaders(request, "POST");
        return this.getStoreProxy(request).processMessage(request).map(response -> {
            this.captureSessionToken(request, (RxDocumentServiceResponse)response);
            return response;
        });
    }

    @Override
    public Observable<ResourceResponse<DocumentCollection>> readCollection(String collectionLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readCollectionInternal(collectionLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<DocumentCollection>> readCollectionInternal(String collectionLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)collectionLink)) {
                throw new IllegalArgumentException("collectionLink");
            }
            this.logger.debug("Reading a Collection. collectionLink: [{}]", (Object)collectionLink);
            String path = Utils.joinPath((String)collectionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Read, (ResourceType)ResourceType.DocumentCollection, (String)path, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, DocumentCollection.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a collection, due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<FeedResponse<DocumentCollection>> readCollections(String databaseLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        return this.readFeed(options, ResourceType.DocumentCollection, DocumentCollection.class, Utils.joinPath((String)databaseLink, (String)"colls"));
    }

    @Override
    public Observable<FeedResponse<DocumentCollection>> queryCollections(String databaseLink, String query, FeedOptions options) {
        return this.createQuery(databaseLink, new SqlQuerySpec(query), options, DocumentCollection.class, ResourceType.DocumentCollection);
    }

    @Override
    public Observable<FeedResponse<DocumentCollection>> queryCollections(String databaseLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(databaseLink, querySpec, options, DocumentCollection.class, ResourceType.DocumentCollection);
    }

    private static String serializeProcedureParams(Object[] objectArray) {
        Object[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof JsonSerializable) {
                stringArray[i] = ((JsonSerializable)object).toJson();
                continue;
            }
            try {
                stringArray[i] = mapper.writeValueAsString(object);
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't serialize the object into the json string", e);
            }
        }
        return String.format("[%s]", StringUtils.join((Object[])stringArray, (String)","));
    }

    private static void validateResource(Resource resource) {
        if (!StringUtils.isEmpty((CharSequence)resource.getId())) {
            if (resource.getId().indexOf(47) != -1 || resource.getId().indexOf(92) != -1 || resource.getId().indexOf(63) != -1 || resource.getId().indexOf(35) != -1) {
                throw new IllegalArgumentException("Id contains illegal chars.");
            }
            if (resource.getId().endsWith(" ")) {
                throw new IllegalArgumentException("Id ends with a space.");
            }
        }
    }

    private Map<String, String> getRequestHeaders(RequestOptions options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.useMultipleWriteLocations) {
            headers.put("x-ms-cosmos-allow-tentative-writes", Boolean.TRUE.toString());
        }
        if (this.consistencyLevel != null) {
            headers.put("x-ms-consistency-level", this.consistencyLevel.name());
        }
        if (options == null) {
            return headers;
        }
        Map customOptions = options.getHeaders();
        if (customOptions != null) {
            headers.putAll(customOptions);
        }
        if (options.getAccessCondition() != null) {
            if (options.getAccessCondition().getType() == AccessConditionType.IfMatch) {
                headers.put("If-Match", options.getAccessCondition().getCondition());
            } else {
                headers.put("If-None-Match", options.getAccessCondition().getCondition());
            }
        }
        if (options.getConsistencyLevel() != null) {
            headers.put("x-ms-consistency-level", options.getConsistencyLevel().name());
        }
        if (options.getIndexingDirective() != null) {
            headers.put("x-ms-indexing-directive", options.getIndexingDirective().name());
        }
        if (options.getPostTriggerInclude() != null && options.getPostTriggerInclude().size() > 0) {
            String postTriggerInclude = StringUtils.join((Iterable)options.getPostTriggerInclude(), (String)",");
            headers.put("x-ms-documentdb-post-trigger-include", postTriggerInclude);
        }
        if (options.getPreTriggerInclude() != null && options.getPreTriggerInclude().size() > 0) {
            String preTriggerInclude = StringUtils.join((Iterable)options.getPreTriggerInclude(), (String)",");
            headers.put("x-ms-documentdb-pre-trigger-include", preTriggerInclude);
        }
        if (!Strings.isNullOrEmpty((String)options.getSessionToken())) {
            headers.put("x-ms-session-token", options.getSessionToken());
        }
        if (options.getResourceTokenExpirySeconds() != null) {
            headers.put("x-ms-documentdb-expiry-seconds", String.valueOf(options.getResourceTokenExpirySeconds()));
        }
        if (options.getOfferThroughput() != null && options.getOfferThroughput() >= 0) {
            headers.put("x-ms-offer-throughput", options.getOfferThroughput().toString());
        } else if (options.getOfferType() != null) {
            headers.put("x-ms-offer-type", options.getOfferType());
        }
        if (options.getPartitionKey() != null) {
            headers.put("x-ms-documentdb-partitionkey", options.getPartitionKey().toString());
        }
        if (options.isPopulateQuotaInfo()) {
            headers.put("x-ms-documentdb-populatequotainfo", String.valueOf(true));
        }
        if (options.isScriptLoggingEnabled()) {
            headers.put("x-ms-documentdb-script-enable-logging", String.valueOf(true));
        }
        return headers;
    }

    private Map<String, String> getFeedHeaders(FeedOptionsBase options) {
        return BridgeInternal.getFeedHeaders((FeedOptionsBase)options);
    }

    private Map<String, String> getMediaHeaders(MediaOptions options) {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        if (options == null || StringUtils.isEmpty((CharSequence)options.getContentType())) {
            requestHeaders.put("Content-Type", "application/octet-stream");
        }
        if (options != null) {
            if (!StringUtils.isEmpty((CharSequence)options.getContentType())) {
                requestHeaders.put("Content-Type", options.getContentType());
            }
            if (!StringUtils.isEmpty((CharSequence)options.getSlug())) {
                requestHeaders.put("Slug", options.getSlug());
            }
        }
        return requestHeaders;
    }

    private Single<RxDocumentServiceRequest> addPartitionKeyInformation(RxDocumentServiceRequest request, Document document, RequestOptions options) {
        Single collectionObs = this.collectionCache.resolveCollectionAsync(request);
        return collectionObs.map(collection -> {
            this.addPartitionKeyInformation(request, document, options, (DocumentCollection)collection);
            return request;
        });
    }

    private Single<RxDocumentServiceRequest> addPartitionKeyInformation(RxDocumentServiceRequest request, Document document, RequestOptions options, Single<DocumentCollection> collectionObs) {
        return collectionObs.map(collection -> {
            this.addPartitionKeyInformation(request, document, options, (DocumentCollection)collection);
            return request;
        });
    }

    private void addPartitionKeyInformation(RxDocumentServiceRequest request, Document document, RequestOptions options, DocumentCollection collection) {
        PartitionKeyDefinition partitionKeyDefinition = collection.getPartitionKey();
        PartitionKeyInternal partitionKeyInternal = null;
        if (options != null && options.getPartitionKey() != null) {
            partitionKeyInternal = options.getPartitionKey().getInternalPartitionKey();
        } else if (partitionKeyDefinition == null || partitionKeyDefinition.getPaths().size() == 0) {
            partitionKeyInternal = PartitionKeyInternal.getEmpty();
        } else if (document != null) {
            partitionKeyInternal = RxDocumentClientImpl.extractPartitionKeyValueFromDocument(document, partitionKeyDefinition);
        } else {
            throw new UnsupportedOperationException("PartitionKey value must be supplied for this operation.");
        }
        request.getHeaders().put("x-ms-documentdb-partitionkey", RxDocumentClientImpl.escapeNonAscii(partitionKeyInternal.toJson()));
    }

    private static String escapeNonAscii(String partitionKeyJson) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < partitionKeyJson.length(); ++i) {
            char val = partitionKeyJson.charAt(i);
            if (val > '\u007f') {
                sb.append("\\u").append(String.format("%04X", val));
                continue;
            }
            sb.append(partitionKeyJson.charAt(i));
        }
        return sb.toString();
    }

    private static PartitionKeyInternal extractPartitionKeyValueFromDocument(Document document, PartitionKeyDefinition partitionKeyDefinition) {
        String path;
        List parts;
        if (partitionKeyDefinition != null && (parts = PathParser.getPathParts((String)(path = (String)partitionKeyDefinition.getPaths().iterator().next()))).size() >= 1) {
            Object value = document.getObjectByPath(parts);
            if (value == null || value.getClass() == ObjectNode.class) {
                value = Undefined.Value();
            }
            return PartitionKeyInternal.fromObjectArray(Collections.singletonList(value), (boolean)false);
        }
        return null;
    }

    private Single<RxDocumentServiceRequest> getCreateDocumentRequest(String documentCollectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)documentCollectionLink)) {
            throw new IllegalArgumentException("documentCollectionLink");
        }
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        Document typedDocument = BridgeInternal.documentFromObject((Object)document, (ObjectMapper)mapper);
        RxDocumentClientImpl.validateResource((Resource)typedDocument);
        if (typedDocument.getId() == null && !disableAutomaticIdGeneration) {
            typedDocument.setId(UUID.randomUUID().toString());
        }
        String path = Utils.joinPath((String)documentCollectionLink, (String)"docs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)operationType, (ResourceType)ResourceType.Document, (String)path, (Resource)typedDocument, requestHeaders, (Object)options);
        Single collectionObs = this.collectionCache.resolveCollectionAsync(request);
        return this.addPartitionKeyInformation(request, typedDocument, options, (Single<DocumentCollection>)collectionObs);
    }

    private void populateHeaders(RxDocumentServiceRequest request, String httpMethod) {
        if (this.masterKeyOrResourceToken != null) {
            request.getHeaders().put("x-ms-date", Utils.nowAsRFC1123());
        }
        if (this.masterKeyOrResourceToken != null || this.resourceTokensMap != null || this.tokenResolver != null) {
            String resourceName = request.getResourceAddress();
            String authorization = this.getUserAuthorizationToken(resourceName, request.getResourceType(), httpMethod, request.getHeaders(), AuthorizationTokenType.PrimaryMasterKey, request.properties);
            try {
                authorization = URLEncoder.encode(authorization, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Failed to encode authtoken.", e);
            }
            request.getHeaders().put("authorization", authorization);
        }
        if (("POST".equals(httpMethod) || "PUT".equals(httpMethod)) && !request.getHeaders().containsKey("Content-Type")) {
            request.getHeaders().put("Content-Type", "application/json");
        }
        if (!request.getHeaders().containsKey("Accept")) {
            request.getHeaders().put("Accept", "application/json");
        }
    }

    public String getUserAuthorizationToken(String resourceName, ResourceType resourceType, String requestVerb, Map<String, String> headers, AuthorizationTokenType tokenType, Map<String, Object> properties) {
        if (this.tokenResolver != null) {
            return this.tokenResolver.getAuthorizationToken(requestVerb, resourceName, this.resolveCosmosResourceType(resourceType), properties != null ? Collections.unmodifiableMap(properties) : null);
        }
        if (this.masterKeyOrResourceToken != null && !this.hasAuthKeyResourceToken) {
            return this.authorizationTokenProvider.generateKeyAuthorizationSignature(requestVerb, resourceName, resourceType, headers);
        }
        if (this.masterKeyOrResourceToken != null && this.hasAuthKeyResourceToken && this.resourceTokensMap == null) {
            return this.masterKeyOrResourceToken;
        }
        assert (this.resourceTokensMap != null);
        if (resourceType.equals((Object)ResourceType.DatabaseAccount)) {
            return this.firstResourceTokenFromPermissionFeed;
        }
        return ResourceTokenAuthorizationHelper.getAuthorizationTokenUsingResourceTokens(this.resourceTokensMap, (String)requestVerb, (String)resourceName, headers);
    }

    private CosmosResourceType resolveCosmosResourceType(ResourceType resourceType) {
        try {
            return CosmosResourceType.valueOf((String)resourceType.name());
        }
        catch (IllegalArgumentException e) {
            return CosmosResourceType.System;
        }
    }

    void captureSessionToken(RxDocumentServiceRequest request, RxDocumentServiceResponse response) {
        this.sessionContainer.setSessionToken(request, response.getResponseHeaders());
    }

    private Observable<RxDocumentServiceResponse> create(RxDocumentServiceRequest request) {
        this.populateHeaders(request, "POST");
        RxStoreModel storeProxy = this.getStoreProxy(request);
        return storeProxy.processMessage(request);
    }

    private Observable<RxDocumentServiceResponse> upsert(RxDocumentServiceRequest request) {
        this.populateHeaders(request, "POST");
        Map headers = request.getHeaders();
        assert (headers != null);
        headers.put("x-ms-documentdb-is-upsert", "true");
        return this.getStoreProxy(request).processMessage(request).map(response -> {
            this.captureSessionToken(request, (RxDocumentServiceResponse)response);
            return response;
        });
    }

    private Observable<RxDocumentServiceResponse> replace(RxDocumentServiceRequest request) {
        this.populateHeaders(request, "PUT");
        return this.getStoreProxy(request).processMessage(request);
    }

    @Override
    public Observable<ResourceResponse<Document>> createDocument(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        if (options == null || options.getPartitionKey() == null) {
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, options);
        }
        IDocumentClientRetryPolicy finalRetryPolicyInstance = requestRetryPolicy;
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createDocumentInternal(collectionLink, document, options, disableAutomaticIdGeneration, finalRetryPolicyInstance), (IRetryPolicy)requestRetryPolicy);
    }

    private Observable<ResourceResponse<Document>> createDocumentInternal(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, IDocumentClientRetryPolicy requestRetryPolicy) {
        try {
            this.logger.debug("Creating a Document. collectionLink: [{}]", (Object)collectionLink);
            Single<RxDocumentServiceRequest> requestObs = this.getCreateDocumentRequest(collectionLink, document, options, disableAutomaticIdGeneration, OperationType.Create);
            Observable responseObservable = requestObs.toObservable().flatMap(req -> {
                if (requestRetryPolicy != null) {
                    requestRetryPolicy.onBeforeSendRequest(req);
                }
                return this.create((RxDocumentServiceRequest)req);
            });
            Observable createObservable = responseObservable.map(serviceResponse -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)serviceResponse, Document.class));
            return createObservable;
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a document due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Document>> upsertDocument(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        if (options == null || options.getPartitionKey() == null) {
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, options);
        }
        IDocumentClientRetryPolicy finalRetryPolicyInstance = requestRetryPolicy;
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertDocumentInternal(collectionLink, document, options, disableAutomaticIdGeneration, finalRetryPolicyInstance), (IRetryPolicy)requestRetryPolicy);
    }

    private Observable<ResourceResponse<Document>> upsertDocumentInternal(String collectionLink, Object document, RequestOptions options, boolean disableAutomaticIdGeneration, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a Document. collectionLink: [{}]", (Object)collectionLink);
            Observable reqObs = this.getCreateDocumentRequest(collectionLink, document, options, disableAutomaticIdGeneration, OperationType.Upsert).toObservable();
            Observable responseObservable = reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(req);
                }
                return this.upsert((RxDocumentServiceRequest)req);
            });
            return responseObservable.map(serviceResponse -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)serviceResponse, Document.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a document due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Document>> replaceDocument(String documentLink, Object document, RequestOptions options) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        if (options == null || options.getPartitionKey() == null) {
            String collectionLink = Utils.getCollectionName((String)documentLink);
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, options);
        }
        IDocumentClientRetryPolicy finalRequestRetryPolicy = requestRetryPolicy;
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceDocumentInternal(documentLink, document, options, finalRequestRetryPolicy), (IRetryPolicy)requestRetryPolicy);
    }

    private Observable<ResourceResponse<Document>> replaceDocumentInternal(String documentLink, Object document, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)documentLink)) {
                throw new IllegalArgumentException("documentLink");
            }
            if (document == null) {
                throw new IllegalArgumentException("document");
            }
            Document typedDocument = BridgeInternal.documentFromObject((Object)document, (ObjectMapper)mapper);
            return this.replaceDocumentInternal(documentLink, typedDocument, options, retryPolicyInstance);
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a document due to [{}]", (Object)e.getMessage());
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Document>> replaceDocument(Document document, RequestOptions options) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        if (options == null || options.getPartitionKey() == null) {
            String collectionLink = document.getSelfLink();
            requestRetryPolicy = new PartitionKeyMismatchRetryPolicy(this.collectionCache, requestRetryPolicy, collectionLink, options);
        }
        IDocumentClientRetryPolicy finalRequestRetryPolicy = requestRetryPolicy;
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceDocumentInternal(document, options, finalRequestRetryPolicy), (IRetryPolicy)requestRetryPolicy);
    }

    private Observable<ResourceResponse<Document>> replaceDocumentInternal(Document document, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (document == null) {
                throw new IllegalArgumentException("document");
            }
            return this.replaceDocumentInternal(document.getSelfLink(), document, options, retryPolicyInstance);
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a database due to [{}]", (Object)e.getMessage());
            return Observable.error((Throwable)e);
        }
    }

    private Observable<ResourceResponse<Document>> replaceDocumentInternal(String documentLink, Document document, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        if (document == null) {
            throw new IllegalArgumentException("document");
        }
        this.logger.debug("Replacing a Document. documentLink: [{}]", (Object)documentLink);
        String path = Utils.joinPath((String)documentLink, null);
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Replace, (ResourceType)ResourceType.Document, (String)path, (Resource)document, requestHeaders, (Object)options);
        RxDocumentClientImpl.validateResource((Resource)document);
        Single collectionObs = this.collectionCache.resolveCollectionAsync(request);
        Single<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, document, options, (Single<DocumentCollection>)collectionObs);
        return requestObs.toObservable().flatMap(req -> {
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request).map(resp -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)resp, Document.class));
        });
    }

    @Override
    public Observable<ResourceResponse<Document>> deleteDocument(String documentLink, RequestOptions options) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteDocumentInternal(documentLink, options, requestRetryPolicy), (IRetryPolicy)requestRetryPolicy);
    }

    private Observable<ResourceResponse<Document>> deleteDocumentInternal(String documentLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)documentLink)) {
                throw new IllegalArgumentException("documentLink");
            }
            this.logger.debug("Deleting a Document. documentLink: [{}]", (Object)documentLink);
            String path = Utils.joinPath((String)documentLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Delete, (ResourceType)ResourceType.Document, (String)path, requestHeaders, (Object)options);
            Single collectionObs = this.collectionCache.resolveCollectionAsync(request);
            Single<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, null, options, (Single<DocumentCollection>)collectionObs);
            return requestObs.toObservable().flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(req);
                }
                return this.delete((RxDocumentServiceRequest)req).map(serviceResponse -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)serviceResponse, Document.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a document due to [{}]", (Object)e.getMessage());
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Document>> readDocument(String documentLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readDocumentInternal(documentLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Document>> readDocumentInternal(String documentLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)documentLink)) {
                throw new IllegalArgumentException("documentLink");
            }
            this.logger.debug("Reading a Document. documentLink: [{}]", (Object)documentLink);
            String path = Utils.joinPath((String)documentLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Read, (ResourceType)ResourceType.Document, (String)path, requestHeaders, (Object)options);
            Single collectionObs = this.collectionCache.resolveCollectionAsync(request);
            Single<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation(request, null, options, (Single<DocumentCollection>)collectionObs);
            return requestObs.toObservable().flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(request);
                }
                return this.read(request).map(serviceResponse -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)serviceResponse, Document.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a document due to [{}]", (Object)e.getMessage());
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<FeedResponse<Document>> readDocuments(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.queryDocuments(collectionLink, "SELECT * FROM r", options);
    }

    @Override
    public Observable<FeedResponse<Document>> queryDocuments(String collectionLink, String query, FeedOptions options) {
        return this.queryDocuments(collectionLink, new SqlQuerySpec(query), options);
    }

    private IDocumentQueryClient DocumentQueryClientImpl(RxDocumentClientImpl rxDocumentClientImpl) {
        return new IDocumentQueryClient(){

            public RxCollectionCache getCollectionCache() {
                return RxDocumentClientImpl.this.collectionCache;
            }

            public RxPartitionKeyRangeCache getPartitionKeyRangeCache() {
                return RxDocumentClientImpl.this.partitionKeyRangeCache;
            }

            public IRetryPolicyFactory getResetSessionTokenRetryPolicy() {
                return RxDocumentClientImpl.this.resetSessionTokenRetryPolicy;
            }

            public ConsistencyLevel getDefaultConsistencyLevelAsync() {
                return RxDocumentClientImpl.this.gatewayConfigurationReader.getDefaultConsistencyLevel();
            }

            public ConsistencyLevel getDesiredConsistencyLevelAsync() {
                return RxDocumentClientImpl.this.consistencyLevel;
            }

            public Single<RxDocumentServiceResponse> executeQueryAsync(RxDocumentServiceRequest request) {
                return RxDocumentClientImpl.this.query(request).toSingle();
            }

            public IDocumentQueryClient.QueryCompatibilityMode getQueryCompatibilityMode() {
                return IDocumentQueryClient.QueryCompatibilityMode.Default;
            }

            public Single<RxDocumentServiceResponse> readFeedAsync(RxDocumentServiceRequest request) {
                return null;
            }
        };
    }

    @Override
    public Observable<FeedResponse<Document>> queryDocuments(String collectionLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(collectionLink, querySpec, options, Document.class, ResourceType.Document);
    }

    @Override
    public Observable<FeedResponse<Document>> queryDocumentChangeFeed(String collectionLink, ChangeFeedOptions changeFeedOptions) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        ChangeFeedQueryImpl<Document> changeFeedQueryImpl = new ChangeFeedQueryImpl<Document>(this, ResourceType.Document, Document.class, collectionLink, changeFeedOptions);
        return changeFeedQueryImpl.executeAsync();
    }

    @Override
    public Observable<FeedResponse<PartitionKeyRange>> readPartitionKeyRanges(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.PartitionKeyRange, PartitionKeyRange.class, Utils.joinPath((String)collectionLink, (String)"pkranges"));
    }

    private RxDocumentServiceRequest getStoredProcedureRequest(String collectionLink, StoredProcedure storedProcedure, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (storedProcedure == null) {
            throw new IllegalArgumentException("storedProcedure");
        }
        RxDocumentClientImpl.validateResource((Resource)storedProcedure);
        String path = Utils.joinPath((String)collectionLink, (String)"sprocs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)operationType, (ResourceType)ResourceType.StoredProcedure, (String)path, (Resource)storedProcedure, requestHeaders, (Object)options);
        return request;
    }

    private RxDocumentServiceRequest getUserDefinedFunctionRequest(String collectionLink, UserDefinedFunction udf, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (udf == null) {
            throw new IllegalArgumentException("udf");
        }
        RxDocumentClientImpl.validateResource((Resource)udf);
        String path = Utils.joinPath((String)collectionLink, (String)"udfs");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)operationType, (ResourceType)ResourceType.UserDefinedFunction, (String)path, (Resource)udf, requestHeaders, (Object)options);
        return request;
    }

    @Override
    public Observable<ResourceResponse<StoredProcedure>> createStoredProcedure(String collectionLink, StoredProcedure storedProcedure, RequestOptions options) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createStoredProcedureInternal(collectionLink, storedProcedure, options, requestRetryPolicy), (IRetryPolicy)requestRetryPolicy);
    }

    private Observable<ResourceResponse<StoredProcedure>> createStoredProcedureInternal(String collectionLink, StoredProcedure storedProcedure, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Creating a StoredProcedure. collectionLink: [{}], storedProcedure id [{}]", (Object)collectionLink, (Object)storedProcedure.getId());
            RxDocumentServiceRequest request = this.getStoredProcedureRequest(collectionLink, storedProcedure, options, OperationType.Create);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, StoredProcedure.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<StoredProcedure>> upsertStoredProcedure(String collectionLink, StoredProcedure storedProcedure, RequestOptions options) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertStoredProcedureInternal(collectionLink, storedProcedure, options, requestRetryPolicy), (IRetryPolicy)requestRetryPolicy);
    }

    private Observable<ResourceResponse<StoredProcedure>> upsertStoredProcedureInternal(String collectionLink, StoredProcedure storedProcedure, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a StoredProcedure. collectionLink: [{}], storedProcedure id [{}]", (Object)collectionLink, (Object)storedProcedure.getId());
            RxDocumentServiceRequest request = this.getStoredProcedureRequest(collectionLink, storedProcedure, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, StoredProcedure.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<StoredProcedure>> replaceStoredProcedure(StoredProcedure storedProcedure, RequestOptions options) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceStoredProcedureInternal(storedProcedure, options, requestRetryPolicy), (IRetryPolicy)requestRetryPolicy);
    }

    private Observable<ResourceResponse<StoredProcedure>> replaceStoredProcedureInternal(StoredProcedure storedProcedure, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (storedProcedure == null) {
                throw new IllegalArgumentException("storedProcedure");
            }
            this.logger.debug("Replacing a StoredProcedure. storedProcedure id [{}]", (Object)storedProcedure.getId());
            RxDocumentClientImpl.validateResource((Resource)storedProcedure);
            String path = Utils.joinPath((String)storedProcedure.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Replace, (ResourceType)ResourceType.StoredProcedure, (String)path, (Resource)storedProcedure, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, StoredProcedure.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<StoredProcedure>> deleteStoredProcedure(String storedProcedureLink, RequestOptions options) {
        IDocumentClientRetryPolicy requestRetryPolicy = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteStoredProcedureInternal(storedProcedureLink, options, requestRetryPolicy), (IRetryPolicy)requestRetryPolicy);
    }

    private Observable<ResourceResponse<StoredProcedure>> deleteStoredProcedureInternal(String storedProcedureLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)storedProcedureLink)) {
                throw new IllegalArgumentException("storedProcedureLink");
            }
            this.logger.debug("Deleting a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
            String path = Utils.joinPath((String)storedProcedureLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Delete, (ResourceType)ResourceType.StoredProcedure, (String)path, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, StoredProcedure.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<StoredProcedure>> readStoredProcedure(String storedProcedureLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readStoredProcedureInternal(storedProcedureLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<StoredProcedure>> readStoredProcedureInternal(String storedProcedureLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)storedProcedureLink)) {
                throw new IllegalArgumentException("storedProcedureLink");
            }
            this.logger.debug("Reading a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
            String path = Utils.joinPath((String)storedProcedureLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Read, (ResourceType)ResourceType.StoredProcedure, (String)path, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, StoredProcedure.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<FeedResponse<StoredProcedure>> readStoredProcedures(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.StoredProcedure, StoredProcedure.class, Utils.joinPath((String)collectionLink, (String)"sprocs"));
    }

    @Override
    public Observable<FeedResponse<StoredProcedure>> queryStoredProcedures(String collectionLink, String query, FeedOptions options) {
        return this.queryStoredProcedures(collectionLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Observable<FeedResponse<StoredProcedure>> queryStoredProcedures(String collectionLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(collectionLink, querySpec, options, StoredProcedure.class, ResourceType.StoredProcedure);
    }

    @Override
    public Observable<StoredProcedureResponse> executeStoredProcedure(String storedProcedureLink, Object[] procedureParams) {
        return this.executeStoredProcedure(storedProcedureLink, null, procedureParams);
    }

    @Override
    public Observable<StoredProcedureResponse> executeStoredProcedure(String storedProcedureLink, RequestOptions options, Object[] procedureParams) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.executeStoredProcedureInternal(storedProcedureLink, options, procedureParams, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<StoredProcedureResponse> executeStoredProcedureInternal(String storedProcedureLink, RequestOptions options, Object[] procedureParams, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Executing a StoredProcedure. storedProcedureLink [{}]", (Object)storedProcedureLink);
            String path = Utils.joinPath((String)storedProcedureLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            requestHeaders.put("Accept", "application/json");
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.ExecuteJavaScript, (ResourceType)ResourceType.StoredProcedure, (String)path, (String)(procedureParams != null ? RxDocumentClientImpl.serializeProcedureParams(procedureParams) : ""), requestHeaders, (Object)options);
            Observable reqObs = this.addPartitionKeyInformation(request, null, options).toObservable();
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(request);
                }
                return this.create(request).map(response -> {
                    this.captureSessionToken(request, (RxDocumentServiceResponse)response);
                    return BridgeInternal.toStoredProcedureResponse((RxDocumentServiceResponse)response);
                });
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in executing a StoredProcedure due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Trigger>> createTrigger(String collectionLink, Trigger trigger, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createTriggerInternal(collectionLink, trigger, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Trigger>> createTriggerInternal(String collectionLink, Trigger trigger, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Creating a Trigger. collectionLink [{}], trigger id [{}]", (Object)collectionLink, (Object)trigger.getId());
            RxDocumentServiceRequest request = this.getTriggerRequest(collectionLink, trigger, options, OperationType.Create);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Trigger.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Trigger>> upsertTrigger(String collectionLink, Trigger trigger, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertTriggerInternal(collectionLink, trigger, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Trigger>> upsertTriggerInternal(String collectionLink, Trigger trigger, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a Trigger. collectionLink [{}], trigger id [{}]", (Object)collectionLink, (Object)trigger.getId());
            RxDocumentServiceRequest request = this.getTriggerRequest(collectionLink, trigger, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Trigger.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    private RxDocumentServiceRequest getTriggerRequest(String collectionLink, Trigger trigger, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        if (trigger == null) {
            throw new IllegalArgumentException("trigger");
        }
        RxDocumentClientImpl.validateResource((Resource)trigger);
        String path = Utils.joinPath((String)collectionLink, (String)"triggers");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)operationType, (ResourceType)ResourceType.Trigger, (String)path, (Resource)trigger, requestHeaders, (Object)options);
        return request;
    }

    @Override
    public Observable<ResourceResponse<Trigger>> replaceTrigger(Trigger trigger, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceTriggerInternal(trigger, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Trigger>> replaceTriggerInternal(Trigger trigger, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (trigger == null) {
                throw new IllegalArgumentException("trigger");
            }
            this.logger.debug("Replacing a Trigger. trigger id [{}]", (Object)trigger.getId());
            RxDocumentClientImpl.validateResource((Resource)trigger);
            String path = Utils.joinPath((String)trigger.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Replace, (ResourceType)ResourceType.Trigger, (String)path, (Resource)trigger, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Trigger.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Trigger>> deleteTrigger(String triggerLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteTriggerInternal(triggerLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Trigger>> deleteTriggerInternal(String triggerLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)triggerLink)) {
                throw new IllegalArgumentException("triggerLink");
            }
            this.logger.debug("Deleting a Trigger. triggerLink [{}]", (Object)triggerLink);
            String path = Utils.joinPath((String)triggerLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Delete, (ResourceType)ResourceType.Trigger, (String)path, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Trigger.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Trigger>> readTrigger(String triggerLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readTriggerInternal(triggerLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Trigger>> readTriggerInternal(String triggerLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)triggerLink)) {
                throw new IllegalArgumentException("triggerLink");
            }
            this.logger.debug("Reading a Trigger. triggerLink [{}]", (Object)triggerLink);
            String path = Utils.joinPath((String)triggerLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Read, (ResourceType)ResourceType.Trigger, (String)path, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Trigger.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a Trigger due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<FeedResponse<Trigger>> readTriggers(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.Trigger, Trigger.class, Utils.joinPath((String)collectionLink, (String)"triggers"));
    }

    @Override
    public Observable<FeedResponse<Trigger>> queryTriggers(String collectionLink, String query, FeedOptions options) {
        return this.queryTriggers(collectionLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Observable<FeedResponse<Trigger>> queryTriggers(String collectionLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(collectionLink, querySpec, options, Trigger.class, ResourceType.Trigger);
    }

    @Override
    public Observable<ResourceResponse<UserDefinedFunction>> createUserDefinedFunction(String collectionLink, UserDefinedFunction udf, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createUserDefinedFunctionInternal(collectionLink, udf, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<UserDefinedFunction>> createUserDefinedFunctionInternal(String collectionLink, UserDefinedFunction udf, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Creating a UserDefinedFunction. collectionLink [{}], udf id [{}]", (Object)collectionLink, (Object)udf.getId());
            RxDocumentServiceRequest request = this.getUserDefinedFunctionRequest(collectionLink, udf, options, OperationType.Create);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.create(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<UserDefinedFunction>> upsertUserDefinedFunction(String collectionLink, UserDefinedFunction udf, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertUserDefinedFunctionInternal(collectionLink, udf, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<UserDefinedFunction>> upsertUserDefinedFunctionInternal(String collectionLink, UserDefinedFunction udf, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a UserDefinedFunction. collectionLink [{}], udf id [{}]", (Object)collectionLink, (Object)udf.getId());
            RxDocumentServiceRequest request = this.getUserDefinedFunctionRequest(collectionLink, udf, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<UserDefinedFunction>> replaceUserDefinedFunction(UserDefinedFunction udf, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceUserDefinedFunctionInternal(udf, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<UserDefinedFunction>> replaceUserDefinedFunctionInternal(UserDefinedFunction udf, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (udf == null) {
                throw new IllegalArgumentException("udf");
            }
            this.logger.debug("Replacing a UserDefinedFunction. udf id [{}]", (Object)udf.getId());
            RxDocumentClientImpl.validateResource((Resource)udf);
            String path = Utils.joinPath((String)udf.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Replace, (ResourceType)ResourceType.UserDefinedFunction, (String)path, (Resource)udf, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<UserDefinedFunction>> deleteUserDefinedFunction(String udfLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteUserDefinedFunctionInternal(udfLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<UserDefinedFunction>> deleteUserDefinedFunctionInternal(String udfLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)udfLink)) {
                throw new IllegalArgumentException("udfLink");
            }
            this.logger.debug("Deleting a UserDefinedFunction. udfLink [{}]", (Object)udfLink);
            String path = Utils.joinPath((String)udfLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Delete, (ResourceType)ResourceType.UserDefinedFunction, (String)path, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<UserDefinedFunction>> readUserDefinedFunction(String udfLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readUserDefinedFunctionInternal(udfLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<UserDefinedFunction>> readUserDefinedFunctionInternal(String udfLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)udfLink)) {
                throw new IllegalArgumentException("udfLink");
            }
            this.logger.debug("Reading a UserDefinedFunction. udfLink [{}]", (Object)udfLink);
            String path = Utils.joinPath((String)udfLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Read, (ResourceType)ResourceType.UserDefinedFunction, (String)path, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, UserDefinedFunction.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a UserDefinedFunction due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<FeedResponse<UserDefinedFunction>> readUserDefinedFunctions(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.UserDefinedFunction, UserDefinedFunction.class, Utils.joinPath((String)collectionLink, (String)"udfs"));
    }

    @Override
    public Observable<FeedResponse<UserDefinedFunction>> queryUserDefinedFunctions(String collectionLink, String query, FeedOptions options) {
        return this.queryUserDefinedFunctions(collectionLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Observable<FeedResponse<UserDefinedFunction>> queryUserDefinedFunctions(String collectionLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(collectionLink, querySpec, options, UserDefinedFunction.class, ResourceType.UserDefinedFunction);
    }

    @Override
    public Observable<ResourceResponse<Attachment>> createAttachment(String documentLink, Attachment attachment, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createAttachmentInternal(documentLink, attachment, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Attachment>> createAttachmentInternal(String documentLink, Attachment attachment, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Creating a Attachment. documentLink [{}], attachment id [{}]", (Object)documentLink, (Object)attachment.getId());
            Observable reqObs = this.getAttachmentRequest(documentLink, attachment, options, OperationType.Create).toObservable();
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(req);
                }
                return this.create((RxDocumentServiceRequest)req).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Attachment.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a Attachment due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Attachment>> upsertAttachment(String documentLink, Attachment attachment, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.retryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertAttachmentInternal(documentLink, attachment, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Attachment>> upsertAttachmentInternal(String documentLink, Attachment attachment, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a Attachment. documentLink [{}], attachment id [{}]", (Object)documentLink, (Object)attachment.getId());
            Observable reqObs = this.getAttachmentRequest(documentLink, attachment, options, OperationType.Upsert).toObservable();
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(req);
                }
                return this.upsert((RxDocumentServiceRequest)req).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Attachment.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a Attachment due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Attachment>> replaceAttachment(Attachment attachment, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceAttachmentInternal(attachment, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Attachment>> replaceAttachmentInternal(Attachment attachment, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (attachment == null) {
                throw new IllegalArgumentException("attachment");
            }
            this.logger.debug("Replacing a Attachment. attachment id [{}]", (Object)attachment.getId());
            RxDocumentClientImpl.validateResource((Resource)attachment);
            String path = Utils.joinPath((String)attachment.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Replace, (ResourceType)ResourceType.Attachment, (String)path, (Resource)attachment, requestHeaders, (Object)options);
            Observable reqObs = this.addPartitionKeyInformation(request, null, options).toObservable();
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(request);
                }
                return this.replace(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Attachment.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a Attachment due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Attachment>> deleteAttachment(String attachmentLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteAttachmentInternal(attachmentLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Attachment>> deleteAttachmentInternal(String attachmentLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)attachmentLink)) {
                throw new IllegalArgumentException("attachmentLink");
            }
            this.logger.debug("Deleting a Attachment. attachmentLink [{}]", (Object)attachmentLink);
            String path = Utils.joinPath((String)attachmentLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Delete, (ResourceType)ResourceType.Attachment, (String)path, requestHeaders, (Object)options);
            Observable reqObs = this.addPartitionKeyInformation(request, null, options).toObservable();
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(req);
                }
                return this.delete((RxDocumentServiceRequest)req).map(resp -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)resp, Attachment.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a Attachment due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Attachment>> readAttachment(String attachmentLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readAttachmentInternal(attachmentLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Attachment>> readAttachmentInternal(String attachmentLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)attachmentLink)) {
                throw new IllegalArgumentException("attachmentLink");
            }
            this.logger.debug("Reading a Attachment. attachmentLink [{}]", (Object)attachmentLink);
            String path = Utils.joinPath((String)attachmentLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Read, (ResourceType)ResourceType.Attachment, (String)path, requestHeaders, (Object)options);
            Observable reqObs = this.addPartitionKeyInformation(request, null, options).toObservable();
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(request);
                }
                return this.read(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Attachment.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a Attachment due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<FeedResponse<Attachment>> readAttachments(String documentLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        return this.readFeedCollectionChild(options, ResourceType.Attachment, Attachment.class, Utils.joinPath((String)documentLink, (String)"attachments"));
    }

    @Override
    public Observable<MediaResponse> readMedia(String mediaLink) {
        if (StringUtils.isEmpty((CharSequence)mediaLink)) {
            throw new IllegalArgumentException("mediaLink");
        }
        String targetPath = Utils.joinPath((String)mediaLink, null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readMediaInternal(targetPath), (IRetryPolicy)this.resetSessionTokenRetryPolicy.getRequestPolicy());
    }

    private Observable<MediaResponse> readMediaInternal(String mediaLink) {
        this.logger.debug("Reading a Media. mediaLink [{}]", (Object)mediaLink);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Read, (ResourceType)ResourceType.Media, (String)mediaLink, (Map)null, null);
        request.setIsMedia(true);
        this.populateHeaders(request, "GET");
        return this.gatewayProxy.processMessage(request).map(response -> BridgeInternal.toMediaResponse((RxDocumentServiceResponse)response, (this.connectionPolicy.getMediaReadMode() == MediaReadMode.Buffered ? 1 : 0) != 0));
    }

    @Override
    public Observable<MediaResponse> updateMedia(String mediaLink, InputStream mediaStream, MediaOptions options) {
        if (StringUtils.isEmpty((CharSequence)mediaLink)) {
            throw new IllegalArgumentException("mediaLink");
        }
        if (mediaStream == null) {
            throw new IllegalArgumentException("mediaStream");
        }
        String targetPath = Utils.joinPath((String)mediaLink, null);
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.updateMediaInternal(targetPath, mediaStream, options), (IRetryPolicy)this.resetSessionTokenRetryPolicy.getRequestPolicy());
    }

    private Observable<MediaResponse> updateMediaInternal(String mediaLink, InputStream mediaStream, MediaOptions options) {
        this.logger.debug("Updating a Media. mediaLink [{}]", (Object)mediaLink);
        Map<String, String> requestHeaders = this.getMediaHeaders(options);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Replace, (ResourceType)ResourceType.Media, (String)mediaLink, (InputStream)mediaStream, requestHeaders);
        request.setIsMedia(true);
        this.populateHeaders(request, "PUT");
        return this.gatewayProxy.processMessage(request).map(response -> BridgeInternal.toMediaResponse((RxDocumentServiceResponse)response, (this.connectionPolicy.getMediaReadMode() == MediaReadMode.Buffered ? 1 : 0) != 0));
    }

    @Override
    public Observable<FeedResponse<Attachment>> queryAttachments(String documentLink, String query, FeedOptions options) {
        return this.queryAttachments(documentLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Observable<FeedResponse<Attachment>> queryAttachments(String documentLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(documentLink, querySpec, options, Attachment.class, ResourceType.Attachment);
    }

    private Single<RxDocumentServiceRequest> getAttachmentRequest(String documentLink, Attachment attachment, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        if (attachment == null) {
            throw new IllegalArgumentException("attachment");
        }
        RxDocumentClientImpl.validateResource((Resource)attachment);
        String path = Utils.joinPath((String)documentLink, (String)"attachments");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)operationType, (ResourceType)ResourceType.Attachment, (String)path, (Resource)attachment, requestHeaders, (Object)options);
        return this.addPartitionKeyInformation(request, null, options);
    }

    @Override
    public Observable<ResourceResponse<Attachment>> createAttachment(String documentLink, InputStream mediaStream, MediaOptions options, RequestOptions requestOptions) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createAttachmentInternal(documentLink, mediaStream, options, requestOptions, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Attachment>> createAttachmentInternal(String documentLink, InputStream mediaStream, MediaOptions options, RequestOptions requestOptions, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Creating a Attachment. attachmentLink [{}]", (Object)documentLink);
            Observable reqObs = this.getAttachmentRequest(documentLink, mediaStream, options, requestOptions, OperationType.Create).toObservable();
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(req);
                }
                return this.create((RxDocumentServiceRequest)req).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Attachment.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a Attachment due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Attachment>> upsertAttachment(String documentLink, InputStream mediaStream, MediaOptions options, RequestOptions requestOptions) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertAttachmentInternal(documentLink, mediaStream, options, requestOptions, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Attachment>> upsertAttachmentInternal(String documentLink, InputStream mediaStream, MediaOptions options, RequestOptions requestOptions, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a Attachment. attachmentLink [{}]", (Object)documentLink);
            Observable reqObs = this.getAttachmentRequest(documentLink, mediaStream, options, requestOptions, OperationType.Upsert).toObservable();
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(req);
                }
                return this.upsert((RxDocumentServiceRequest)req).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Attachment.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a Attachment due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    private Single<RxDocumentServiceRequest> getAttachmentRequest(String documentLink, InputStream mediaStream, MediaOptions options, RequestOptions requestOptions, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)documentLink)) {
            throw new IllegalArgumentException("documentLink");
        }
        if (mediaStream == null) {
            throw new IllegalArgumentException("mediaStream");
        }
        String path = Utils.joinPath((String)documentLink, (String)"attachments");
        Map<String, String> requestHeaders = this.getMediaHeaders(options);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)operationType, (ResourceType)ResourceType.Attachment, (String)path, (InputStream)mediaStream, requestHeaders);
        request.setIsMedia(true);
        return this.addPartitionKeyInformation(request, null, requestOptions);
    }

    @Override
    public Observable<ResourceResponse<Conflict>> readConflict(String conflictLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readConflictInternal(conflictLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Conflict>> readConflictInternal(String conflictLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)conflictLink)) {
                throw new IllegalArgumentException("conflictLink");
            }
            this.logger.debug("Reading a Conflict. conflictLink [{}]", (Object)conflictLink);
            String path = Utils.joinPath((String)conflictLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Read, (ResourceType)ResourceType.Conflict, (String)path, requestHeaders, (Object)options);
            Observable reqObs = this.addPartitionKeyInformation(request, null, options).toObservable();
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(request);
                }
                return this.read(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Conflict.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a Conflict due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<FeedResponse<Conflict>> readConflicts(String collectionLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink");
        }
        return this.readFeed(options, ResourceType.Conflict, Conflict.class, Utils.joinPath((String)collectionLink, (String)"conflicts"));
    }

    @Override
    public Observable<FeedResponse<Conflict>> queryConflicts(String collectionLink, String query, FeedOptions options) {
        return this.queryConflicts(collectionLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Observable<FeedResponse<Conflict>> queryConflicts(String collectionLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(collectionLink, querySpec, options, Conflict.class, ResourceType.Conflict);
    }

    @Override
    public Observable<ResourceResponse<Conflict>> deleteConflict(String conflictLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteConflictInternal(conflictLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Conflict>> deleteConflictInternal(String conflictLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)conflictLink)) {
                throw new IllegalArgumentException("conflictLink");
            }
            this.logger.debug("Deleting a Conflict. conflictLink [{}]", (Object)conflictLink);
            String path = Utils.joinPath((String)conflictLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Delete, (ResourceType)ResourceType.Conflict, (String)path, requestHeaders, (Object)options);
            Observable reqObs = this.addPartitionKeyInformation(request, null, options).toObservable();
            return reqObs.flatMap(req -> {
                if (retryPolicyInstance != null) {
                    retryPolicyInstance.onBeforeSendRequest(request);
                }
                return this.delete(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Conflict.class));
            });
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a Conflict due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<User>> createUser(String databaseLink, User user, RequestOptions options) {
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createUserInternal(databaseLink, user, options), (IRetryPolicy)this.resetSessionTokenRetryPolicy.getRequestPolicy());
    }

    private Observable<ResourceResponse<User>> createUserInternal(String databaseLink, User user, RequestOptions options) {
        try {
            this.logger.debug("Creating a User. databaseLink [{}], user id [{}]", (Object)databaseLink, (Object)user.getId());
            RxDocumentServiceRequest request = this.getUserRequest(databaseLink, user, options, OperationType.Create);
            return this.create(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, User.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<User>> upsertUser(String databaseLink, User user, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertUserInternal(databaseLink, user, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<User>> upsertUserInternal(String databaseLink, User user, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a User. databaseLink [{}], user id [{}]", (Object)databaseLink, (Object)user.getId());
            RxDocumentServiceRequest request = this.getUserRequest(databaseLink, user, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, User.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    private RxDocumentServiceRequest getUserRequest(String databaseLink, User user, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        if (user == null) {
            throw new IllegalArgumentException("user");
        }
        RxDocumentClientImpl.validateResource((Resource)user);
        String path = Utils.joinPath((String)databaseLink, (String)"users");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)operationType, (ResourceType)ResourceType.User, (String)path, (Resource)user, requestHeaders, (Object)options);
        return request;
    }

    @Override
    public Observable<ResourceResponse<User>> replaceUser(User user, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceUserInternal(user, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<User>> replaceUserInternal(User user, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (user == null) {
                throw new IllegalArgumentException("user");
            }
            this.logger.debug("Replacing a User. user id [{}]", (Object)user.getId());
            RxDocumentClientImpl.validateResource((Resource)user);
            String path = Utils.joinPath((String)user.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Replace, (ResourceType)ResourceType.User, (String)path, (Resource)user, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, User.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<User>> deleteUser(String userLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deleteUserInternal(userLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<User>> deleteUserInternal(String userLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)userLink)) {
                throw new IllegalArgumentException("userLink");
            }
            this.logger.debug("Deleting a User. userLink [{}]", (Object)userLink);
            String path = Utils.joinPath((String)userLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Delete, (ResourceType)ResourceType.User, (String)path, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, User.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<User>> readUser(String userLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readUserInternal(userLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<User>> readUserInternal(String userLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)userLink)) {
                throw new IllegalArgumentException("userLink");
            }
            this.logger.debug("Reading a User. userLink [{}]", (Object)userLink);
            String path = Utils.joinPath((String)userLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Read, (ResourceType)ResourceType.User, (String)path, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, User.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a User due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<FeedResponse<User>> readUsers(String databaseLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)databaseLink)) {
            throw new IllegalArgumentException("databaseLink");
        }
        return this.readFeed(options, ResourceType.User, User.class, Utils.joinPath((String)databaseLink, (String)"users"));
    }

    @Override
    public Observable<FeedResponse<User>> queryUsers(String databaseLink, String query, FeedOptions options) {
        return this.queryUsers(databaseLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Observable<FeedResponse<User>> queryUsers(String databaseLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(databaseLink, querySpec, options, User.class, ResourceType.User);
    }

    @Override
    public Observable<ResourceResponse<Permission>> createPermission(String userLink, Permission permission, RequestOptions options) {
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.createPermissionInternal(userLink, permission, options), (IRetryPolicy)this.resetSessionTokenRetryPolicy.getRequestPolicy());
    }

    private Observable<ResourceResponse<Permission>> createPermissionInternal(String userLink, Permission permission, RequestOptions options) {
        try {
            this.logger.debug("Creating a Permission. userLink [{}], permission id [{}]", (Object)userLink, (Object)permission.getId());
            RxDocumentServiceRequest request = this.getPermissionRequest(userLink, permission, options, OperationType.Create);
            return this.create(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Permission.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in creating a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Permission>> upsertPermission(String userLink, Permission permission, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.upsertPermissionInternal(userLink, permission, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Permission>> upsertPermissionInternal(String userLink, Permission permission, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            this.logger.debug("Upserting a Permission. userLink [{}], permission id [{}]", (Object)userLink, (Object)permission.getId());
            RxDocumentServiceRequest request = this.getPermissionRequest(userLink, permission, options, OperationType.Upsert);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.upsert(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Permission.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in upserting a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    private RxDocumentServiceRequest getPermissionRequest(String userLink, Permission permission, RequestOptions options, OperationType operationType) {
        if (StringUtils.isEmpty((CharSequence)userLink)) {
            throw new IllegalArgumentException("userLink");
        }
        if (permission == null) {
            throw new IllegalArgumentException("permission");
        }
        RxDocumentClientImpl.validateResource((Resource)permission);
        String path = Utils.joinPath((String)userLink, (String)"permissions");
        Map<String, String> requestHeaders = this.getRequestHeaders(options);
        RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)operationType, (ResourceType)ResourceType.Permission, (String)path, (Resource)permission, requestHeaders, (Object)options);
        return request;
    }

    @Override
    public Observable<ResourceResponse<Permission>> replacePermission(Permission permission, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replacePermissionInternal(permission, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Permission>> replacePermissionInternal(Permission permission, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (permission == null) {
                throw new IllegalArgumentException("permission");
            }
            this.logger.debug("Replacing a Permission. permission id [{}]", (Object)permission.getId());
            RxDocumentClientImpl.validateResource((Resource)permission);
            String path = Utils.joinPath((String)permission.getSelfLink(), null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Replace, (ResourceType)ResourceType.Permission, (String)path, (Resource)permission, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.replace(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Permission.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Permission>> deletePermission(String permissionLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.deletePermissionInternal(permissionLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Permission>> deletePermissionInternal(String permissionLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)permissionLink)) {
                throw new IllegalArgumentException("permissionLink");
            }
            this.logger.debug("Deleting a Permission. permissionLink [{}]", (Object)permissionLink);
            String path = Utils.joinPath((String)permissionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Delete, (ResourceType)ResourceType.Permission, (String)path, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.delete(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Permission.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in deleting a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Permission>> readPermission(String permissionLink, RequestOptions options) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readPermissionInternal(permissionLink, options, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Permission>> readPermissionInternal(String permissionLink, RequestOptions options, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)permissionLink)) {
                throw new IllegalArgumentException("permissionLink");
            }
            this.logger.debug("Reading a Permission. permissionLink [{}]", (Object)permissionLink);
            String path = Utils.joinPath((String)permissionLink, null);
            Map<String, String> requestHeaders = this.getRequestHeaders(options);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Read, (ResourceType)ResourceType.Permission, (String)path, requestHeaders, (Object)options);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Permission.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading a Permission due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<FeedResponse<Permission>> readPermissions(String userLink, FeedOptions options) {
        if (StringUtils.isEmpty((CharSequence)userLink)) {
            throw new IllegalArgumentException("userLink");
        }
        return this.readFeed(options, ResourceType.Permission, Permission.class, Utils.joinPath((String)userLink, (String)"permissions"));
    }

    @Override
    public Observable<FeedResponse<Permission>> queryPermissions(String userLink, String query, FeedOptions options) {
        return this.queryPermissions(userLink, new SqlQuerySpec(query), options);
    }

    @Override
    public Observable<FeedResponse<Permission>> queryPermissions(String userLink, SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(userLink, querySpec, options, Permission.class, ResourceType.Permission);
    }

    @Override
    public Observable<ResourceResponse<Offer>> replaceOffer(Offer offer) {
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.replaceOfferInternal(offer), (IRetryPolicy)this.resetSessionTokenRetryPolicy.getRequestPolicy());
    }

    private Observable<ResourceResponse<Offer>> replaceOfferInternal(Offer offer) {
        try {
            if (offer == null) {
                throw new IllegalArgumentException("offer");
            }
            this.logger.debug("Replacing an Offer. offer id [{}]", (Object)offer.getId());
            RxDocumentClientImpl.validateResource((Resource)offer);
            String path = Utils.joinPath((String)offer.getSelfLink(), null);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Replace, (ResourceType)ResourceType.Offer, (String)path, (Resource)offer, null, null);
            return this.replace(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Offer.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in replacing an Offer due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<ResourceResponse<Offer>> readOffer(String offerLink) {
        IDocumentClientRetryPolicy retryPolicyInstance = this.resetSessionTokenRetryPolicy.getRequestPolicy();
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.readOfferInternal(offerLink, retryPolicyInstance), (IRetryPolicy)retryPolicyInstance);
    }

    private Observable<ResourceResponse<Offer>> readOfferInternal(String offerLink, IDocumentClientRetryPolicy retryPolicyInstance) {
        try {
            if (StringUtils.isEmpty((CharSequence)offerLink)) {
                throw new IllegalArgumentException("offerLink");
            }
            this.logger.debug("Reading an Offer. offerLink [{}]", (Object)offerLink);
            String path = Utils.joinPath((String)offerLink, null);
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Read, (ResourceType)ResourceType.Offer, (String)path, (Map)null, null);
            if (retryPolicyInstance != null) {
                retryPolicyInstance.onBeforeSendRequest(request);
            }
            return this.read(request).map(response -> BridgeInternal.toResourceResponse((RxDocumentServiceResponse)response, Offer.class));
        }
        catch (Exception e) {
            this.logger.debug("Failure in reading an Offer due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    @Override
    public Observable<FeedResponse<Offer>> readOffers(FeedOptions options) {
        return this.readFeed(options, ResourceType.Offer, Offer.class, Utils.joinPath((String)"offers", null));
    }

    private <T extends Resource> Observable<FeedResponse<T>> readFeedCollectionChild(FeedOptions options, ResourceType resourceType, Class<T> klass, String resourceLink) {
        if (options == null) {
            options = new FeedOptions();
        }
        int maxPageSize = options.getMaxItemCount() != null ? options.getMaxItemCount() : -1;
        FeedOptions finalFeedOptions = options;
        RequestOptions requestOptions = new RequestOptions();
        requestOptions.setPartitionKey(options.getPartitionKey());
        Func2 createRequestFunc = (continuationToken, pageSize) -> {
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            if (continuationToken != null) {
                requestHeaders.put("x-ms-continuation", (String)continuationToken);
            }
            requestHeaders.put("x-ms-max-item-count", Integer.toString(pageSize));
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.ReadFeed, (ResourceType)resourceType, (String)resourceLink, requestHeaders, (Object)finalFeedOptions);
            return request;
        };
        Func1 executeFunc = request -> ObservableHelper.inlineIfPossibleAsObs(() -> {
            Single collectionObs = this.collectionCache.resolveCollectionAsync(request);
            Single<RxDocumentServiceRequest> requestObs = this.addPartitionKeyInformation((RxDocumentServiceRequest)request, null, requestOptions, (Single<DocumentCollection>)collectionObs);
            return requestObs.toObservable().flatMap(req -> this.readFeed((RxDocumentServiceRequest)req).map(response -> BridgeInternal.toFeedResponsePage((RxDocumentServiceResponse)response, (Class)klass)));
        }, (IRetryPolicy)this.resetSessionTokenRetryPolicy.getRequestPolicy());
        return Paginator.getPaginatedQueryResultAsObservable((FeedOptions)options, (Func2)createRequestFunc, (Func1)executeFunc, klass, (int)maxPageSize);
    }

    private <T extends Resource> Observable<FeedResponse<T>> readFeed(FeedOptions options, ResourceType resourceType, Class<T> klass, String resourceLink) {
        if (options == null) {
            options = new FeedOptions();
        }
        int maxPageSize = options.getMaxItemCount() != null ? options.getMaxItemCount() : -1;
        FeedOptions finalFeedOptions = options;
        Func2 createRequestFunc = (continuationToken, pageSize) -> {
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            if (continuationToken != null) {
                requestHeaders.put("x-ms-continuation", (String)continuationToken);
            }
            requestHeaders.put("x-ms-max-item-count", Integer.toString(pageSize));
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.ReadFeed, (ResourceType)resourceType, (String)resourceLink, requestHeaders, (Object)finalFeedOptions);
            return request;
        };
        Func1 executeFunc = request -> ObservableHelper.inlineIfPossibleAsObs(() -> this.readFeed((RxDocumentServiceRequest)request).map(response -> BridgeInternal.toFeedResponsePage((RxDocumentServiceResponse)response, (Class)klass)), (IRetryPolicy)this.resetSessionTokenRetryPolicy.getRequestPolicy());
        return Paginator.getPaginatedQueryResultAsObservable((FeedOptions)options, (Func2)createRequestFunc, (Func1)executeFunc, klass, (int)maxPageSize);
    }

    @Override
    public Observable<FeedResponse<Offer>> queryOffers(String query, FeedOptions options) {
        return this.queryOffers(new SqlQuerySpec(query), options);
    }

    @Override
    public Observable<FeedResponse<Offer>> queryOffers(SqlQuerySpec querySpec, FeedOptions options) {
        return this.createQuery(null, querySpec, options, Offer.class, ResourceType.Offer);
    }

    @Override
    public Observable<DatabaseAccount> getDatabaseAccount() {
        return ObservableHelper.inlineIfPossibleAsObs(() -> this.getDatabaseAccountInternal(), (IRetryPolicy)this.resetSessionTokenRetryPolicy.getRequestPolicy());
    }

    private Observable<DatabaseAccount> getDatabaseAccountInternal() {
        try {
            this.logger.debug("Getting Database Account");
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Read, (ResourceType)ResourceType.DatabaseAccount, (String)"", (Map)null, null);
            return this.read(request).map(response -> BridgeInternal.toDatabaseAccount((RxDocumentServiceResponse)response));
        }
        catch (Exception e) {
            this.logger.debug("Failure in getting Database Account due to [{}]", (Object)e.getMessage(), (Object)e);
            return Observable.error((Throwable)e);
        }
    }

    public Object getSession() {
        return this.sessionContainer;
    }

    public void setSession(Object sessionContainer) {
        this.sessionContainer = (SessionContainer)sessionContainer;
    }

    public RxPartitionKeyRangeCache getPartitionKeyRangeCache() {
        return this.partitionKeyRangeCache;
    }

    public Observable<DatabaseAccount> getDatabaseAccountFromEndpoint(URI endpoint) {
        return Observable.defer(() -> {
            RxDocumentServiceRequest request = RxDocumentServiceRequest.create((OperationType)OperationType.Read, (ResourceType)ResourceType.DatabaseAccount, (String)"", (Map)null, null);
            this.populateHeaders(request, "GET");
            request.setEndpointOverride(endpoint);
            return this.gatewayProxy.processMessage(request).doOnError(e -> {
                String message = String.format("Failed to retrieve database account information. %s", e.getCause() != null ? e.getCause().toString() : e.toString());
                this.logger.warn(message);
            }).map(rsp -> (DatabaseAccount)rsp.getResource(DatabaseAccount.class)).doOnNext(databaseAccount -> {
                this.useMultipleWriteLocations = this.connectionPolicy.isUsingMultipleWriteLocations() && BridgeInternal.isEnableMultipleWriteLocations((DatabaseAccount)databaseAccount);
            });
        });
    }

    private RxStoreModel getStoreProxy(RxDocumentServiceRequest request) {
        if (request.UseGatewayMode) {
            return this.gatewayProxy;
        }
        ResourceType resourceType = request.getResourceType();
        OperationType operationType = request.getOperationType();
        if (resourceType == ResourceType.Offer || resourceType.isScript() && operationType != OperationType.ExecuteJavaScript || resourceType == ResourceType.PartitionKeyRange) {
            return this.gatewayProxy;
        }
        if (operationType == OperationType.Create || operationType == OperationType.Upsert) {
            if (resourceType == ResourceType.Database || resourceType == ResourceType.User || resourceType == ResourceType.DocumentCollection || resourceType == ResourceType.Permission) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Delete) {
            if (resourceType == ResourceType.Database || resourceType == ResourceType.User || resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Replace) {
            if (resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if (operationType == OperationType.Read) {
            if (resourceType == ResourceType.DocumentCollection) {
                return this.gatewayProxy;
            }
            return this.storeModel;
        }
        if ((request.getOperationType() == OperationType.Query || request.getOperationType() == OperationType.SqlQuery) && Utils.isCollectionChild((ResourceType)request.getResourceType()) && request.getPartitionKeyRangeIdentity() == null) {
            return this.gatewayProxy;
        }
        return this.storeModel;
    }

    @Override
    public void close() {
        this.logger.info("Shutting down ...");
        LifeCycleUtils.closeQuietly((AutoCloseable)this.globalEndpointManager);
        LifeCycleUtils.closeQuietly((AutoCloseable)this.storeClientFactory);
        try {
            this.rxClient.shutdown();
        }
        catch (Exception e) {
            this.logger.warn("Failure in shutting down rxClient", (Throwable)e);
        }
    }
}

