/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.ConnectionPolicy;
import com.microsoft.azure.cosmosdb.internal.UserAgentContainer;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.AddressInformation;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.AddressResolver;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GatewayAddressCache;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.GatewayServiceConfigurationReader;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.IAddressCache;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.IAddressResolver;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.Protocol;
import com.microsoft.azure.cosmosdb.rx.internal.GlobalEndpointManager;
import com.microsoft.azure.cosmosdb.rx.internal.IAuthorizationTokenProvider;
import com.microsoft.azure.cosmosdb.rx.internal.ICollectionRoutingMapCache;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxCollectionCache;
import com.microsoft.azure.cosmosdb.rx.internal.caches.RxPartitionKeyRangeCache;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.protocol.http.client.CompositeHttpClient;
import java.net.URL;
import rx.Single;

public class GlobalAddressResolver
implements IAddressResolver {
    private static final int MaxBackupReadRegions = 3;
    private final GlobalEndpointManager endpointManager;
    private final Protocol protocol;
    private final IAuthorizationTokenProvider tokenProvider;
    private final UserAgentContainer userAgentContainer;
    private final RxCollectionCache collectionCache;
    private final RxPartitionKeyRangeCache routingMapProvider;
    private final GatewayServiceConfigurationReader serviceConfigReader;
    private GatewayAddressCache gatewayAddressCache;
    private AddressResolver addressResolver;
    private CompositeHttpClient<ByteBuf, ByteBuf> httpClient;

    public GlobalAddressResolver(CompositeHttpClient<ByteBuf, ByteBuf> httpClient, GlobalEndpointManager endpointManager, Protocol protocol, IAuthorizationTokenProvider tokenProvider, RxCollectionCache collectionCache, RxPartitionKeyRangeCache routingMapProvider, UserAgentContainer userAgentContainer, GatewayServiceConfigurationReader serviceConfigReader, ConnectionPolicy connectionPolicy) {
        this.httpClient = httpClient;
        this.endpointManager = endpointManager;
        this.protocol = protocol;
        this.tokenProvider = tokenProvider;
        this.userAgentContainer = userAgentContainer;
        this.collectionCache = collectionCache;
        this.routingMapProvider = routingMapProvider;
        this.serviceConfigReader = serviceConfigReader;
        this.initializeAddressCache();
    }

    private void initializeAddressCache() {
        this.gatewayAddressCache = new GatewayAddressCache((URL)this.endpointManager.getReadEndpoints().get(0), this.tokenProvider, this.userAgentContainer, this.httpClient);
        this.addressResolver = new AddressResolver();
        this.addressResolver.initializeCaches(this.collectionCache, (ICollectionRoutingMapCache)this.routingMapProvider, (IAddressCache)this.gatewayAddressCache);
    }

    public Single<AddressInformation[]> resolveAsync(RxDocumentServiceRequest request, boolean forceRefreshPartitionAddresses) {
        return this.addressResolver.resolveAsync(request, false);
    }
}

