/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.rx.internal.query.AggregateDocumentQueryExecutionContext;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryExecutionComponent;
import com.microsoft.azure.cosmosdb.rx.internal.query.ParallelDocumentQueryExecutionContextBase;
import rx.Observable;
import rx.functions.Func1;

public class TopDocumentQueryExecutionContext<T extends Resource>
implements IDocumentQueryExecutionComponent<T> {
    private final IDocumentQueryExecutionComponent<T> component;
    private final int top;

    public TopDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<T> component, int top) {
        this.component = component;
        this.top = top;
    }

    public static <T extends Resource> Observable<IDocumentQueryExecutionComponent<T>> createAsync(Observable<IDocumentQueryExecutionComponent<T>> observableComponent, int top) {
        return observableComponent.map(component -> new TopDocumentQueryExecutionContext(component, top));
    }

    @Override
    public Observable<FeedResponse<T>> drainAsync(int maxPageSize) {
        ParallelDocumentQueryExecutionContextBase context = this.component instanceof AggregateDocumentQueryExecutionContext ? (ParallelDocumentQueryExecutionContextBase)((AggregateDocumentQueryExecutionContext)this.component).getComponent() : (ParallelDocumentQueryExecutionContextBase)this.component;
        context.setTop(this.top);
        return this.component.drainAsync(maxPageSize).takeUntil(new Func1<FeedResponse<T>, Boolean>(){
            private volatile int fetchedItems = 0;

            public Boolean call(FeedResponse<T> frp) {
                this.fetchedItems += frp.getResults().size();
                return this.fetchedItems >= TopDocumentQueryExecutionContext.this.top;
            }
        }).map(new Func1<FeedResponse<T>, FeedResponse<T>>(){
            private volatile int collectedItems = 0;
            private volatile boolean lastPage = false;

            public FeedResponse<T> call(FeedResponse<T> t) {
                if (this.collectedItems + t.getResults().size() <= TopDocumentQueryExecutionContext.this.top) {
                    this.collectedItems += t.getResults().size();
                    return t;
                }
                assert (!this.lastPage);
                this.lastPage = true;
                int lastPageSize = TopDocumentQueryExecutionContext.this.top - this.collectedItems;
                this.collectedItems += lastPageSize;
                return BridgeInternal.createFeedResponse(t.getResults().subList(0, lastPageSize), t.getResponseHeaders());
            }
        });
    }
}

