/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.SqlQuerySpec;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.query.PartitionedQueryExecutionInfo;
import com.microsoft.azure.cosmosdb.internal.query.QueryInfo;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.query.AggregateDocumentQueryExecutionContext;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryClient;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryExecutionComponent;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryExecutionContext;
import com.microsoft.azure.cosmosdb.rx.internal.query.OrderByDocumentQueryExecutionContext;
import com.microsoft.azure.cosmosdb.rx.internal.query.ParallelDocumentQueryExecutionContext;
import com.microsoft.azure.cosmosdb.rx.internal.query.TopDocumentQueryExecutionContext;
import java.util.List;
import java.util.UUID;
import rx.Observable;

public class PipelinedDocumentQueryExecutionContext<T extends Resource>
implements IDocumentQueryExecutionContext<T> {
    private IDocumentQueryExecutionComponent<T> component;
    private int actualPageSize;
    private UUID correlatedActivityId;

    private PipelinedDocumentQueryExecutionContext(IDocumentQueryExecutionComponent<T> component, int actualPageSize, UUID correlatedActivityId) {
        this.component = component;
        this.actualPageSize = actualPageSize;
        this.correlatedActivityId = correlatedActivityId;
    }

    public static <T extends Resource> Observable<PipelinedDocumentQueryExecutionContext<T>> createAsync(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec expression, FeedOptions feedOptions, String resourceLink, String collectionRid, PartitionedQueryExecutionInfo partitionedQueryExecutionInfo, List<PartitionKeyRange> targetRanges, int initialPageSize, boolean isContinuationExpected, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        int actualPageSize;
        QueryInfo queryInfo = partitionedQueryExecutionInfo.getQueryInfo();
        Observable<IDocumentQueryExecutionComponent<T>> component = queryInfo.hasOrderBy() ? OrderByDocumentQueryExecutionContext.createAsync(client, resourceTypeEnum, resourceType, expression, feedOptions, resourceLink, collectionRid, partitionedQueryExecutionInfo, targetRanges, initialPageSize, isContinuationExpected, getLazyFeedResponse, correlatedActivityId) : ParallelDocumentQueryExecutionContext.createAsync(client, resourceTypeEnum, resourceType, expression, feedOptions, resourceLink, collectionRid, partitionedQueryExecutionInfo, targetRanges, initialPageSize, isContinuationExpected, getLazyFeedResponse, correlatedActivityId);
        if (queryInfo.hasAggregates()) {
            component = AggregateDocumentQueryExecutionContext.createAsync(component, queryInfo.getAggregates());
        }
        if (queryInfo.hasTop()) {
            component = TopDocumentQueryExecutionContext.createAsync(component, queryInfo.getTop());
        }
        if ((actualPageSize = Utils.getValueOrDefault(feedOptions.getMaxItemCount(), 100)) == -1) {
            actualPageSize = Integer.MAX_VALUE;
        }
        int pageSize = Math.min(actualPageSize, Utils.getValueOrDefault(queryInfo.getTop(), actualPageSize));
        return component.map(c -> new PipelinedDocumentQueryExecutionContext(c, pageSize, correlatedActivityId));
    }

    @Override
    public Observable<FeedResponse<T>> executeAsync() {
        return this.component.drainAsync(this.actualPageSize);
    }
}

