/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.SqlQuerySpec;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.routing.Range;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import com.microsoft.azure.cosmosdb.rx.internal.query.DocumentProducer;
import com.microsoft.azure.cosmosdb.rx.internal.query.DocumentQueryExecutionContextBase;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryClient;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryExecutionComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func3;

public abstract class ParallelDocumentQueryExecutionContextBase<T extends Resource>
extends DocumentQueryExecutionContextBase<T>
implements IDocumentQueryExecutionComponent<T> {
    protected final List<DocumentProducer<T>> documentProducers = new ArrayList<DocumentProducer<T>>();
    protected final SqlQuerySpec querySpec;
    protected int pageSize;
    protected int top = -1;

    protected ParallelDocumentQueryExecutionContextBase(IDocumentQueryClient client, ResourceType resourceTypeEnum, Class<T> resourceType, SqlQuerySpec query, FeedOptions feedOptions, String resourceLink, String rewrittenQuery, boolean isContinuationExpected, boolean getLazyFeedResponse, UUID correlatedActivityId) {
        super(client, resourceTypeEnum, resourceType, query, feedOptions, resourceLink, getLazyFeedResponse, correlatedActivityId);
        this.querySpec = !Strings.isNullOrEmpty(rewrittenQuery) ? new SqlQuerySpec(rewrittenQuery, this.query.getParameters()) : this.query;
    }

    protected void initialize(String collectionRid, List<Range<String>> queryRanges, List<PartitionKeyRange> partitionKeyRanges, int initialPageSize, SqlQuerySpec querySpecForInit) {
        this.pageSize = initialPageSize;
        Map<String, String> commonRequestHeaders = this.createCommonHeadersAsync(this.getFeedOptions(null, null));
        for (PartitionKeyRange targetRange : partitionKeyRanges) {
            Func3 createRequestFunc = (partitionKeyRange, continuationToken, pageSize) -> {
                HashMap<String, String> headers = new HashMap<String, String>(commonRequestHeaders);
                headers.put("x-ms-continuation", (String)continuationToken);
                headers.put("x-ms-max-item-count", Strings.toString(pageSize));
                return this.createDocumentServiceRequest((Map<String, String>)headers, querySpecForInit, (PartitionKeyRange)partitionKeyRange, collectionRid);
            };
            Func1 executeFunc = request -> this.executeRequestAsync((RxDocumentServiceRequest)request).toObservable();
            DocumentProducer<T> dp = this.createDocumentProducer(collectionRid, targetRange, initialPageSize, querySpecForInit, commonRequestHeaders, (Func3<PartitionKeyRange, String, Integer, RxDocumentServiceRequest>)createRequestFunc, executeFunc, (Func0<IDocumentClientRetryPolicy>)((Func0)() -> this.client.getRetryPolicyFactory().getRequestPolicy()));
            this.documentProducers.add(dp);
        }
    }

    protected abstract DocumentProducer<T> createDocumentProducer(String var1, PartitionKeyRange var2, int var3, SqlQuerySpec var4, Map<String, String> var5, Func3<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> var6, Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> var7, Func0<IDocumentClientRetryPolicy> var8);

    @Override
    public abstract Observable<FeedResponse<T>> drainAsync(int var1);

    public void setTop(int newTop) {
        this.top = newTop;
        for (DocumentProducer<T> producer : this.documentProducers) {
            producer.top = newTop;
        }
    }
}

