/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.PartitionKeyRange;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.internal.routing.Range;
import com.microsoft.azure.cosmosdb.rx.internal.Exceptions;
import com.microsoft.azure.cosmosdb.rx.internal.IDocumentClientRetryPolicy;
import com.microsoft.azure.cosmosdb.rx.internal.ObservableHelper;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.query.IDocumentQueryClient;
import com.microsoft.azure.cosmosdb.rx.internal.query.Paginator;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Single;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.functions.Func3;

class DocumentProducer<T extends Resource> {
    private static final Logger logger = LoggerFactory.getLogger(DocumentProducer.class);
    protected final IDocumentQueryClient client;
    protected final String collectionRid;
    protected final FeedOptions feedOptions;
    protected final Class<T> resourceType;
    protected final PartitionKeyRange targetRange;
    protected final String collectionLink;
    protected final Func3<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> createRequestFunc;
    protected final Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> executeRequestFuncWithRetries;
    protected final Func0<IDocumentClientRetryPolicy> createRetryPolicyFunc;
    protected final int pageSize;
    protected final UUID correlatedActivityId;
    public int top;
    private volatile String lastResponseContinuationToken;

    public DocumentProducer(IDocumentQueryClient client, String collectionResourceId, Func3<PartitionKeyRange, String, Integer, RxDocumentServiceRequest> createRequestFunc, Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> executeRequestFunc, PartitionKeyRange targetRange, String collectionLink, Func0<IDocumentClientRetryPolicy> createRetryPolicyFunc, Class<T> resourceType, UUID correlatedActivityId, int initialPageSize, String initialContinuationToken, int top) {
        this.client = client;
        this.collectionRid = collectionResourceId;
        this.createRequestFunc = createRequestFunc;
        this.executeRequestFuncWithRetries = request -> {
            IDocumentClientRetryPolicy retryPolicy = null;
            if (createRetryPolicyFunc != null) {
                retryPolicy = (IDocumentClientRetryPolicy)createRetryPolicyFunc.call();
                retryPolicy.onBeforeSendRequest((RxDocumentServiceRequest)request);
            }
            return ObservableHelper.inlineIfPossibleAsObs(() -> (Observable)executeRequestFunc.call(request), retryPolicy);
        };
        this.correlatedActivityId = correlatedActivityId;
        this.feedOptions = new FeedOptions();
        this.feedOptions.setRequestContinuation(initialContinuationToken);
        this.lastResponseContinuationToken = initialContinuationToken;
        this.resourceType = resourceType;
        this.targetRange = targetRange;
        this.collectionLink = collectionLink;
        this.createRetryPolicyFunc = createRetryPolicyFunc;
        this.pageSize = initialPageSize;
        this.top = top;
    }

    public Observable<DocumentProducerFeedResponse> produceAsync() {
        Func2 sourcePartitionCreateRequestFunc = (token, maxItemCount) -> (RxDocumentServiceRequest)this.createRequestFunc.call((Object)this.targetRange, token, maxItemCount);
        Observable obs = Paginator.getPaginatedQueryResultAsObservable(this.feedOptions, (Func2<String, Integer, RxDocumentServiceRequest>)sourcePartitionCreateRequestFunc, this.executeRequestFuncWithRetries, this.resourceType, this.top, this.pageSize).map(rsp -> {
            this.lastResponseContinuationToken = rsp.getResponseContinuation();
            return rsp;
        });
        return this.splitProof((Observable<DocumentProducerFeedResponse>)obs.map(page -> new DocumentProducerFeedResponse(page)));
    }

    private Observable<DocumentProducerFeedResponse> splitProof(Observable<DocumentProducerFeedResponse> sourceFeedResponseObservable) {
        return sourceFeedResponseObservable.onErrorResumeNext(t -> {
            DocumentClientException dce = Utils.as(t, DocumentClientException.class);
            if (dce == null || !this.isSplit(dce)) {
                return Observable.error((Throwable)t);
            }
            Single<List<PartitionKeyRange>> replacementRangesObs = this.getReplacementRanges(this.targetRange.toRange());
            Observable replacementProducers = replacementRangesObs.toObservable().flatMap(partitionKeyRanges -> {
                if (logger.isDebugEnabled()) {
                    logger.info("Cross Partition Query Execution detected partition [{}] split into [{} partitions, last continuation token is [{}].", new Object[]{this.targetRange.toJson(), String.join((CharSequence)", ", partitionKeyRanges.stream().map(pkr -> pkr.toJson()).collect(Collectors.toList())), this.lastResponseContinuationToken});
                }
                return Observable.from(this.createReplacingDocumentProducersOnSplit((List<PartitionKeyRange>)partitionKeyRanges));
            });
            return this.produceOnSplit(replacementProducers);
        });
    }

    protected Observable<DocumentProducerFeedResponse> produceOnSplit(Observable<DocumentProducer<T>> replacingDocumentProducers) {
        return replacingDocumentProducers.flatMap(dp -> dp.produceAsync(), 1);
    }

    private List<DocumentProducer<T>> createReplacingDocumentProducersOnSplit(List<PartitionKeyRange> partitionKeyRanges) {
        ArrayList<DocumentProducer<T>> replacingDocumentProducers = new ArrayList<DocumentProducer<T>>(partitionKeyRanges.size());
        for (PartitionKeyRange pkr : partitionKeyRanges) {
            replacingDocumentProducers.add(this.createChildDocumentProducerOnSplit(pkr, this.lastResponseContinuationToken));
        }
        return replacingDocumentProducers;
    }

    protected DocumentProducer<T> createChildDocumentProducerOnSplit(PartitionKeyRange targetRange, String initialContinuationToken) {
        return new DocumentProducer<T>(this.client, this.collectionRid, this.createRequestFunc, this.executeRequestFuncWithRetries, targetRange, this.collectionLink, null, this.resourceType, this.correlatedActivityId, this.pageSize, initialContinuationToken, this.top);
    }

    private Single<List<PartitionKeyRange>> getReplacementRanges(Range<String> range) {
        return this.client.getPartitionKeyRangeCache().tryGetOverlappingRangesAsync(this.collectionRid, range, true);
    }

    private boolean isSplit(DocumentClientException e) {
        return Exceptions.isPartitionSplit(e);
    }

    class DocumentProducerFeedResponse {
        FeedResponse<T> pageResult;
        PartitionKeyRange sourcePartitionKeyRange;

        DocumentProducerFeedResponse(FeedResponse<T> pageResult) {
            this.pageResult = pageResult;
            this.sourcePartitionKeyRange = DocumentProducer.this.targetRange;
        }

        DocumentProducerFeedResponse(FeedResponse<T> pageResult, PartitionKeyRange pkr) {
            this.pageResult = pageResult;
            this.sourcePartitionKeyRange = pkr;
        }
    }
}

