/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.ConnectionPolicy;
import com.microsoft.azure.cosmosdb.ConsistencyLevel;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.EndpointManager;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.QueryCompatibilityMode;
import com.microsoft.azure.cosmosdb.internal.UserAgentContainer;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceResponse;
import com.microsoft.azure.cosmosdb.rx.internal.RxStoreModel;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.netty.client.RxClient;
import io.reactivex.netty.protocol.http.client.CompositeHttpClient;
import io.reactivex.netty.protocol.http.client.HttpClientRequest;
import io.reactivex.netty.protocol.http.client.HttpClientResponse;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

class RxGatewayStoreModel
implements RxStoreModel {
    private static final int INITIAL_RESPONSE_BUFFER_SIZE = 1024;
    private final Logger logger = LoggerFactory.getLogger(RxGatewayStoreModel.class);
    private final Map<String, String> defaultHeaders = new HashMap<String, String>();
    private final CompositeHttpClient<ByteBuf, ByteBuf> httpClient;
    private final QueryCompatibilityMode queryCompatibilityMode;
    private final EndpointManager globalEndpointManager;

    public RxGatewayStoreModel(ConnectionPolicy connectionPolicy, ConsistencyLevel consistencyLevel, QueryCompatibilityMode queryCompatibilityMode, String masterKey, Map<String, String> resourceTokens, UserAgentContainer userAgentContainer, EndpointManager globalEndpointManager, CompositeHttpClient<ByteBuf, ByteBuf> httpClient) {
        this.defaultHeaders.put("Cache-Control", "no-cache");
        this.defaultHeaders.put("x-ms-version", "2017-11-15");
        if (userAgentContainer == null) {
            userAgentContainer = new UserAgentContainer();
        }
        this.defaultHeaders.put("User-Agent", userAgentContainer.getUserAgent());
        if (consistencyLevel != null) {
            this.defaultHeaders.put("x-ms-consistency-level", consistencyLevel.toString());
        }
        this.globalEndpointManager = globalEndpointManager;
        this.queryCompatibilityMode = queryCompatibilityMode;
        this.httpClient = httpClient;
    }

    private Observable<RxDocumentServiceResponse> doCreate(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.POST);
    }

    private Observable<RxDocumentServiceResponse> upsert(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.POST);
    }

    private Observable<RxDocumentServiceResponse> read(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.GET);
    }

    private Observable<RxDocumentServiceResponse> replace(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.PUT);
    }

    private Observable<RxDocumentServiceResponse> delete(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.DELETE);
    }

    private Observable<RxDocumentServiceResponse> execute(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.POST);
    }

    private Observable<RxDocumentServiceResponse> readFeed(RxDocumentServiceRequest request) {
        return this.performRequest(request, HttpMethod.GET);
    }

    private Observable<RxDocumentServiceResponse> query(RxDocumentServiceRequest request) {
        request.getHeaders().put("x-ms-documentdb-isquery", "true");
        switch (this.queryCompatibilityMode) {
            case SqlQuery: {
                request.getHeaders().put("Content-Type", "application/sql");
                break;
            }
            default: {
                request.getHeaders().put("Content-Type", "application/query+json");
            }
        }
        return this.performRequest(request, HttpMethod.POST);
    }

    public Observable<RxDocumentServiceResponse> performRequest(RxDocumentServiceRequest request, HttpMethod method) {
        URI uri = this.getUri(request);
        HttpClientRequest httpRequest = HttpClientRequest.create((HttpMethod)method, (String)uri.toString());
        this.fillHttpRequestBaseWithHeaders(request.getHeaders(), (HttpClientRequest<ByteBuf>)httpRequest);
        try {
            if (request.getContentObservable() != null) {
                Observable byteBufObservable = request.getContentObservable().map(bytes -> Unpooled.wrappedBuffer((byte[])bytes));
                httpRequest.withContentSource(byteBufObservable);
            } else if (request.getContent() != null) {
                httpRequest.withContent(request.getContent());
            }
        }
        catch (Exception e) {
            return Observable.error((Throwable)e);
        }
        RxClient.ServerInfo serverInfo = new RxClient.ServerInfo(uri.getHost(), uri.getPort());
        Observable clientResponseObservable = this.httpClient.submit(serverInfo, httpRequest);
        return this.toDocumentServiceResponse((Observable<HttpClientResponse<ByteBuf>>)clientResponseObservable, request);
    }

    private void fillHttpRequestBaseWithHeaders(Map<String, String> headers, HttpClientRequest<ByteBuf> req) {
        for (Map.Entry<String, String> entry : this.defaultHeaders.entrySet()) {
            req.withHeader(entry.getKey(), entry.getValue());
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                if (entry.getValue() == null) {
                    req.withHeader(entry.getKey(), "");
                    continue;
                }
                req.withHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    private URI getUri(RxDocumentServiceRequest request) {
        URI uri;
        URI rootUri = request.getEndpointOverride();
        if (rootUri == null) {
            rootUri = request.getIsMedia() ? this.globalEndpointManager.getWriteEndpoint() : this.globalEndpointManager.resolveServiceEndpoint(request.getOperationType());
        }
        try {
            uri = new URI("https", null, rootUri.getHost(), rootUri.getPort(), this.ensureSlashPrefixed(request.getPath()), null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Incorrect uri from request.", e);
        }
        return uri;
    }

    private String ensureSlashPrefixed(String path) {
        if (path == null) {
            return path;
        }
        if (path.startsWith("/")) {
            return path;
        }
        return "/" + path;
    }

    private Observable<InputStream> toInputStream(Observable<ByteBuf> contentObservable) {
        return contentObservable.reduce((Object)new ByteArrayOutputStream(), (out, bb) -> {
            try {
                bb.readBytes((OutputStream)out, bb.readableBytes());
                return out;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).map(out -> new ByteArrayInputStream(out.toByteArray()));
    }

    private Observable<String> toString(Observable<ByteBuf> contentObservable) {
        return contentObservable.reduce((Object)new ByteArrayOutputStream(1024), (out, bb) -> {
            try {
                bb.readBytes((OutputStream)out, bb.readableBytes());
                return out;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).map(out -> new String(out.toByteArray(), StandardCharsets.UTF_8));
    }

    private Observable<RxDocumentServiceResponse> toDocumentServiceResponse(Observable<HttpClientResponse<ByteBuf>> clientResponseObservable, RxDocumentServiceRequest request) {
        if (request.getIsMedia()) {
            return clientResponseObservable.flatMap(clientResponse -> {
                HttpResponseHeaders httpResponseHeaders = clientResponse.getHeaders();
                HttpResponseStatus httpResponseStatus = clientResponse.getStatus();
                Observable<InputStream> inputStreamObservable = request.getOperationType() == OperationType.Delete ? Observable.just(null) : this.toInputStream((Observable<ByteBuf>)clientResponse.getContent());
                Observable storeResponseObservable = inputStreamObservable.flatMap(contentInputStream -> {
                    try {
                        this.validateOrThrow(request, httpResponseStatus, httpResponseHeaders, null, (InputStream)contentInputStream);
                        StoreResponse rsp = new StoreResponse(httpResponseStatus.code(), (List<Map.Entry<String, String>>)httpResponseHeaders.entries(), (InputStream)contentInputStream);
                        return Observable.just((Object)rsp);
                    }
                    catch (Exception e) {
                        return Observable.error((Throwable)e);
                    }
                });
                return storeResponseObservable;
            }).map(storeResponse -> new RxDocumentServiceResponse((StoreResponse)storeResponse));
        }
        return clientResponseObservable.flatMap(clientResponse -> {
            HttpResponseHeaders httpResponseHeaders = clientResponse.getHeaders();
            HttpResponseStatus httpResponseStatus = clientResponse.getStatus();
            Observable<String> contentObservable = request.getOperationType() == OperationType.Delete ? Observable.just(null) : this.toString((Observable<ByteBuf>)clientResponse.getContent());
            Observable storeResponseObservable = contentObservable.flatMap(content -> {
                try {
                    this.validateOrThrow(request, httpResponseStatus, httpResponseHeaders, (String)content, null);
                    StoreResponse rsp = new StoreResponse(httpResponseStatus.code(), (List<Map.Entry<String, String>>)httpResponseHeaders.entries(), (String)content);
                    return Observable.just((Object)rsp);
                }
                catch (Exception e) {
                    return Observable.error((Throwable)e);
                }
            });
            return storeResponseObservable;
        }).map(storeResponse -> new RxDocumentServiceResponse((StoreResponse)storeResponse));
    }

    private void validateOrThrow(RxDocumentServiceRequest request, HttpResponseStatus status, HttpResponseHeaders headers, String body, InputStream inputStream) throws DocumentClientException {
        int statusCode = status.code();
        if (statusCode >= 400) {
            if (body == null && inputStream != null) {
                try {
                    body = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    this.logger.error("Failed to get content from the http response", (Throwable)e);
                    throw new IllegalStateException("Failed to get content from the http response", e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            for (Map.Entry header : headers.entries()) {
                responseHeaders.put((String)header.getKey(), (String)header.getValue());
            }
            String statusCodeString = status.reasonPhrase() != null ? status.reasonPhrase().replace(" ", "") : "";
            Error error = null;
            error = body != null ? new Error(body) : new Error();
            error = new Error(statusCodeString, String.format("%s, StatusCode: %s", error.getMessage(), statusCodeString), error.getPartitionedQueryExecutionInfo());
            throw new DocumentClientException(statusCode, error, responseHeaders);
        }
    }

    @Override
    public Observable<RxDocumentServiceResponse> processMessage(RxDocumentServiceRequest request) {
        switch (request.getOperationType()) {
            case Create: {
                return this.doCreate(request);
            }
            case Upsert: {
                return this.upsert(request);
            }
            case Delete: {
                return this.delete(request);
            }
            case ExecuteJavaScript: {
                return this.execute(request);
            }
            case Read: {
                return this.read(request);
            }
            case ReadFeed: {
                return this.readFeed(request);
            }
            case Replace: {
                return this.replace(request);
            }
            case SqlQuery: 
            case Query: {
                return this.query(request);
            }
        }
        throw new IllegalStateException("Unknown operation type " + (Object)((Object)request.getOperationType()));
    }
}

