/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import com.microsoft.azure.cosmosdb.ConnectionPolicy;
import com.microsoft.azure.cosmosdb.DatabaseAccount;
import com.microsoft.azure.cosmosdb.DatabaseAccountLocation;
import com.microsoft.azure.cosmosdb.internal.EndpointManager;
import com.microsoft.azure.cosmosdb.internal.OperationType;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.DatabaseAccountManagerInternal;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentClientImpl;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.schedulers.Schedulers;

class GlobalEndpointManager
implements EndpointManager {
    private static final Logger logger = LoggerFactory.getLogger(GlobalEndpointManager.class);
    private final DatabaseAccountManagerInternal client;
    private final Collection<String> preferredLocations;
    private final boolean enableEndpointDiscovery;
    private final URI defaultEndpoint;
    private Map<String, URI> readableLocations;
    private Map<String, URI> writableLocations;
    private ConcurrentMap<String, Long> unavailableRegions;
    private URI currentWriteLocation;
    private URI currentReadLocation;
    private volatile boolean initialized;
    private volatile boolean refreshing;
    private boolean preferredLocationValid;
    private String mostPreferredRegion;
    private volatile boolean isClosed;
    private Subscription endpointCheckIntervalSubscription;
    private static final long DEFAULT_UNAVAILABLE_LOCATION_EXPIRATION_TIME = 300000L;
    private static final long DEFAULT_BACKGROUND_REFRESH_LOCATION_TIME_INTERVAL_IN_MS = 300000L;

    public GlobalEndpointManager(final RxDocumentClientImpl client) {
        this(new DatabaseAccountManagerInternal(){

            @Override
            public URI getServiceEndpoint() {
                return client.getServiceEndpoint();
            }

            @Override
            public Observable<DatabaseAccount> getDatabaseAccountFromEndpoint(URI endpoint) {
                logger.trace("Getting database account endpoint from {}", (Object)endpoint);
                return client.getDatabaseAccountFromEndpoint(endpoint);
            }

            @Override
            public ConnectionPolicy getConnectionPolicy() {
                return client.getConnectionPolicy();
            }
        });
        String candidateRegion;
        this.preferredLocationValid = false;
        this.mostPreferredRegion = null;
        if (this.preferredLocations != null && this.preferredLocations.size() > 0 && StringUtils.isNotEmpty((CharSequence)(candidateRegion = this.preferredLocations.iterator().next()))) {
            this.preferredLocationValid = true;
            this.mostPreferredRegion = candidateRegion;
            logger.trace("Most preferred read region is {}", (Object)this.mostPreferredRegion);
        }
        if (this.enableEndpointDiscovery) {
            this.setupPeriodicCheckAndRefreshEndpoint();
        }
    }

    @Override
    public void close() {
        this.isClosed = true;
        if (this.endpointCheckIntervalSubscription != null && !this.endpointCheckIntervalSubscription.isUnsubscribed()) {
            this.endpointCheckIntervalSubscription.unsubscribe();
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    private void setupPeriodicCheckAndRefreshEndpoint() {
        Observable endpointCheckIntervalOb = Observable.interval((long)300000L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.endpointCheckIntervalSubscription = endpointCheckIntervalOb.subscribe(tick -> {
            if (this.preferredLocationValid && this.readableLocations != null && this.readableLocations.get(this.mostPreferredRegion) == null) {
                logger.trace("Current read region is not the most preferred region {}", (Object)this.mostPreferredRegion);
                this.refreshEndpointList();
            } else {
                logger.trace("Most preferred read region is active.");
            }
        });
    }

    @Override
    public void markEndpointUnavailable() {
        if (!this.getReadEndpoint().equals(this.getWriteEndpoint())) {
            Long currentMs = System.currentTimeMillis();
            if (this.unavailableRegions.putIfAbsent(this.getReadEndpoint().toString(), currentMs) == null) {
                logger.debug("Added endpoint {} to unavailable regions with timestamp {}.", (Object)this.getReadEndpoint(), (Object)currentMs);
            } else {
                logger.trace("Endpoint {} is already in unavailable regions list.", (Object)this.getReadEndpoint());
            }
        } else {
            this.unavailableRegions.remove(this.getReadEndpoint().toString());
            logger.debug("Read endpoint is write endpoint {}, not marking as unavailable.", (Object)this.getReadEndpoint());
        }
    }

    private boolean checkAndUpdateIfEndpointIsUnavailable(String endpoint) {
        Long addedTimestamp = (Long)this.unavailableRegions.get(endpoint);
        if (addedTimestamp == null) {
            return false;
        }
        if (System.currentTimeMillis() - addedTimestamp > 300000L) {
            if (this.unavailableRegions.remove(endpoint) != null) {
                logger.debug("Remove endpoint {} from unavailable endpoint", (Object)endpoint);
            }
            return false;
        }
        logger.debug("Endpoint {} is present in unavailable regions list", (Object)endpoint);
        return true;
    }

    public GlobalEndpointManager(DatabaseAccountManagerInternal client) {
        this.client = client;
        this.preferredLocations = client.getConnectionPolicy().getPreferredLocations();
        this.enableEndpointDiscovery = client.getConnectionPolicy().getEnableEndpointDiscovery();
        this.defaultEndpoint = client.getServiceEndpoint();
        this.initialized = false;
        this.refreshing = false;
        this.unavailableRegions = new ConcurrentHashMap<String, Long>();
    }

    @Override
    public URI getWriteEndpoint() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.currentWriteLocation;
    }

    @Override
    public URI getReadEndpoint() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.currentReadLocation;
    }

    @Override
    public URI resolveServiceEndpoint(OperationType operationType) {
        URI endpoint = null;
        endpoint = Utils.isWriteOperation(operationType) ? this.getWriteEndpoint() : this.getReadEndpoint();
        if (endpoint == null) {
            endpoint = this.defaultEndpoint;
        }
        return endpoint;
    }

    @Override
    public synchronized void refreshEndpointList() {
        if (this.refreshing) {
            logger.trace("Endpoint list is being refreshed.");
            return;
        }
        this.refreshing = true;
        this.refreshEndpointListInternal().subscribe((Subscriber)new Subscriber<DatabaseAccount>(){

            public void onCompleted() {
                logger.debug("Endpoint list has been updated.");
                GlobalEndpointManager.this.refreshing = false;
            }

            public void onError(Throwable e) {
                logger.warn("refreshEndpointList has encountered an error: {}", (Object)e.getMessage(), (Object)e);
                GlobalEndpointManager.this.refreshing = false;
            }

            public void onNext(DatabaseAccount o) {
            }
        });
    }

    @Override
    public Observable<DatabaseAccount> getDatabaseAccountFromAnyEndpoint() {
        return this.client.getDatabaseAccountFromEndpoint(this.defaultEndpoint).flatMap(databaseAccount -> {
            if (databaseAccount == null) {
                if (this.preferredLocations != null && this.preferredLocations.size() > 0) {
                    Observable dbObs = Observable.empty();
                    for (String regionName : this.preferredLocations) {
                        URI regionalUri = this.getRegionalEndpoint(regionName);
                        if (regionalUri == null) continue;
                        dbObs = dbObs.concatWith(this.client.getDatabaseAccountFromEndpoint(regionalUri).subscribeOn(Schedulers.io()));
                    }
                    return dbObs.firstOrDefault(null, Objects::nonNull).flatMap(db -> {
                        if (db != null) {
                            return Observable.just((Object)db);
                        }
                        return Observable.error((Throwable)new IllegalStateException("Attempted reading database account from the preferred regions list but failed."));
                    });
                }
                logger.warn("There was an issue with the global endpoint and the preferred locations are not provided.");
            }
            if (databaseAccount != null) {
                logger.trace("Fetched database account: {}", databaseAccount);
                return Observable.just((Object)databaseAccount);
            }
            return Observable.error((Throwable)new IllegalStateException("Failed to read database account from all endpoints."));
        });
    }

    private synchronized void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.refreshEndpointListInternal().toBlocking().firstOrDefault(null);
        logger.trace("initialize has been completed.");
    }

    private Observable<DatabaseAccount> refreshEndpointListInternal() {
        if (!this.enableEndpointDiscovery) {
            logger.warn("Endpoint discovery is disabled. Skipping endpoint refresh.");
            return Observable.empty();
        }
        HashMap writableLocations = new HashMap();
        HashMap readableLocations = new HashMap();
        return this.getDatabaseAccountFromAnyEndpoint().flatMap(databaseAccount -> {
            if (databaseAccount != null) {
                URI regionUri;
                if (databaseAccount.getWritableLocations() != null) {
                    for (DatabaseAccountLocation location : databaseAccount.getWritableLocations()) {
                        if (!StringUtils.isNotEmpty((CharSequence)location.getName())) continue;
                        regionUri = null;
                        try {
                            regionUri = new URI(location.getEndpoint());
                        }
                        catch (URISyntaxException e) {
                            logger.warn("Unexpected endpoint URI {}", (Object)location.getEndpoint());
                        }
                        if (regionUri == null) continue;
                        writableLocations.put(location.getName(), regionUri);
                    }
                }
                if (databaseAccount.getReadableLocations() != null) {
                    for (DatabaseAccountLocation location : databaseAccount.getReadableLocations()) {
                        if (!StringUtils.isNotEmpty((CharSequence)location.getName()) || this.checkAndUpdateIfEndpointIsUnavailable(location.getEndpoint())) continue;
                        regionUri = null;
                        try {
                            regionUri = new URI(location.getEndpoint());
                        }
                        catch (URISyntaxException e) {
                            logger.warn("Unexpected endpoint URI {}", (Object)location.getEndpoint());
                        }
                        if (regionUri == null) continue;
                        readableLocations.put(location.getName(), regionUri);
                    }
                }
                this.updateEndpointsCache(writableLocations, readableLocations);
            }
            return Observable.just((Object)databaseAccount);
        });
    }

    private void updateEndpointsCache(Map<String, URI> writableLocations, Map<String, URI> readableLocations) {
        this.writableLocations = writableLocations;
        this.readableLocations = readableLocations;
        if (!this.enableEndpointDiscovery) {
            this.currentReadLocation = this.defaultEndpoint;
            this.currentWriteLocation = this.defaultEndpoint;
            return;
        }
        if (this.writableLocations.size() == 0) {
            this.currentWriteLocation = this.defaultEndpoint;
        } else {
            Iterator<Map.Entry<String, URI>> iterator = this.writableLocations.entrySet().iterator();
            this.currentWriteLocation = iterator.next().getValue();
        }
        URI newReadRegion = null;
        if (this.readableLocations.size() == 0) {
            newReadRegion = this.currentWriteLocation;
        } else if (this.preferredLocations == null || this.preferredLocations.size() == 0) {
            newReadRegion = this.currentWriteLocation;
        } else {
            for (String regionName : this.preferredLocations) {
                if (StringUtils.isNotEmpty((CharSequence)regionName) && ((newReadRegion = this.readableLocations.get(regionName)) != null || (newReadRegion = this.writableLocations.get(regionName)) != null)) break;
            }
        }
        this.currentReadLocation = newReadRegion != null ? newReadRegion : this.currentWriteLocation;
        logger.debug("Current read location {}, current write location {}", (Object)this.currentReadLocation, (Object)this.currentWriteLocation);
    }

    private URI getRegionalEndpoint(String regionName) {
        if (StringUtils.isNotEmpty((CharSequence)regionName)) {
            String databaseAccountName = this.defaultEndpoint.getHost();
            int indexOfDot = this.defaultEndpoint.getHost().indexOf(46);
            if (indexOfDot >= 0) {
                databaseAccountName = databaseAccountName.substring(0, indexOfDot);
            }
            String regionalAccountName = databaseAccountName + "-" + regionName.replace(" ", "");
            String regionalUrl = this.defaultEndpoint.toString().replaceFirst(databaseAccountName, regionalAccountName);
            try {
                return new URI(regionalUrl);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }
}

