/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal;

import org.apache.commons.lang3.StringUtils;

class Configs {
    private static final String MAX_HTTP_BODY_LENGTH_IN_BYTES = "MAX_HTTP_BODY_LENGTH_IN_BYTES";
    private static final String MAX_HTTP_INITIAL_LINE_LENGTH_IN_BYTES = "MAX_HTTP_INITIAL_LINE_LENGTH_IN_BYTES";
    private static final String MAX_HTTP_CHUNK_SIZE_IN_BYTES = "MAX_HTTP_CHUNK_SIZE_IN_BYTES";
    private static final String MAX_HTTP_HEADER_SIZE_IN_BYTES = "MAX_HTTP_HEADER_SIZE_IN_BYTES";
    private static final int DEFAULT_MAX_HTTP_BODY_LENGTH_IN_BYTES = 0x200000;
    private static final int DEFAULT_MAX_HTTP_INITIAL_LINE_LENGTH = 4096;
    private static final int DEFAULT_MAX_HTTP_CHUNK_SIZE_IN_BYTES = 8192;
    private static final int DEFAULT_MAX_HTTP_REQUEST_HEADER_SIZE = 32768;

    Configs() {
    }

    public int getMaxHttpHeaderSize() {
        return Configs.getJVMConfigAsInt(MAX_HTTP_HEADER_SIZE_IN_BYTES, 32768);
    }

    public int getMaxHttpInitialLineLength() {
        return Configs.getJVMConfigAsInt(MAX_HTTP_INITIAL_LINE_LENGTH_IN_BYTES, 4096);
    }

    public int getMaxHttpChunkSize() {
        return Configs.getJVMConfigAsInt(MAX_HTTP_CHUNK_SIZE_IN_BYTES, 8192);
    }

    public int getMaxHttpBodyLength() {
        return Configs.getJVMConfigAsInt(MAX_HTTP_BODY_LENGTH_IN_BYTES, 0x200000);
    }

    private static int getJVMConfigAsInt(String propName, int defaultValue) {
        String propValue = System.getProperty(propName);
        return Configs.getIntValue(propValue, defaultValue);
    }

    private static int getIntValue(String val, int defaultValue) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            return defaultValue;
        }
        return Integer.valueOf(val);
    }
}

