/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal;

import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.internal.SessionContainer;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class SessionTokenHelper {
    public static void setPartitionLocalSessionToken(RxDocumentServiceRequest request, SessionContainer sessionContainer) throws DocumentClientException {
        String originalSessionToken = request.getHeaders().get("x-ms-session-token");
        String partitionKeyRangeId = request.getResolvedPartitionKeyRange().getId();
        if (StringUtils.isNotEmpty((CharSequence)originalSessionToken)) {
            Long sessionLsn = SessionTokenHelper.getLocalSessionToken(request, originalSessionToken, partitionKeyRangeId);
            if (sessionLsn != null) {
                request.setSessionLsn(sessionLsn);
            }
        } else {
            Long sessionLsn = sessionContainer.resolvePartitionLocalSessionToken(request, partitionKeyRangeId);
            if (sessionLsn != null) {
                request.setSessionLsn(sessionLsn);
            }
        }
        if (request.getSessionLsn() == -1L) {
            request.getHeaders().remove("x-ms-session-token");
        } else {
            request.getHeaders().put("x-ms-session-token", String.format("%1s:%2d", "0", request.getSessionLsn()));
        }
    }

    private static Long getLocalSessionToken(RxDocumentServiceRequest request, String sessionToken, String partitionKeyRangeId) throws DocumentClientException {
        if (partitionKeyRangeId == null || partitionKeyRangeId.isEmpty()) {
            throw new IllegalStateException("Partition key range Id is absent in the context.");
        }
        String[] localTokens = sessionToken.split(",");
        HashSet<String> partitionKeyRangeSet = new HashSet<String>();
        partitionKeyRangeSet.add(partitionKeyRangeId);
        Long maxLsn = null;
        if (request.getResolvedPartitionKeyRange() != null && request.getResolvedPartitionKeyRange().getParents() != null) {
            partitionKeyRangeSet.addAll(request.getResolvedPartitionKeyRange().getParents());
        }
        for (String localToken : localTokens) {
            String[] items = localToken.split(":");
            Long tokenLsn = null;
            if (items.length == 2) {
                try {
                    tokenLsn = Long.parseLong(items[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (tokenLsn == null) {
                throw new DocumentClientException(400, "Invalid session token value.");
            }
            if (!partitionKeyRangeSet.contains(items[0]) || maxLsn != null && maxLsn >= tokenLsn) continue;
            maxLsn = tokenLsn;
        }
        return maxLsn;
    }

    static Long resolvePartitionLocalSessionToken(RxDocumentServiceRequest request, String partitionKeyRangeId, ConcurrentHashMap<String, Long> rangeIdToTokenMap) {
        if (rangeIdToTokenMap != null) {
            if (rangeIdToTokenMap.containsKey(partitionKeyRangeId)) {
                return rangeIdToTokenMap.get(partitionKeyRangeId);
            }
            Collection<String> parents = request.getResolvedPartitionKeyRange().getParents();
            if (parents != null) {
                ArrayList<String> parentsList = new ArrayList<String>(parents);
                for (int i = parentsList.size() - 1; i >= 0; --i) {
                    String parentId = (String)parentsList.get(i);
                    if (!rangeIdToTokenMap.containsKey(parentId)) continue;
                    return rangeIdToTokenMap.get(parentId);
                }
            }
        }
        return null;
    }

    public static Long resolvePartitionLocalSessionToken(RxDocumentServiceRequest request, String partitionKeyRangeId, SessionContainer sessionContainer) throws DocumentClientException {
        return sessionContainer.resolvePartitionLocalSessionToken(request, partitionKeyRangeId);
    }
}

