/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal;

import com.microsoft.azure.cosmosdb.internal.PathInfo;
import com.microsoft.azure.cosmosdb.internal.PathsHelper;
import com.microsoft.azure.cosmosdb.internal.ResourceId;
import com.microsoft.azure.cosmosdb.internal.SessionTokenHelper;
import com.microsoft.azure.cosmosdb.internal.Utils;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceResponse;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public final class SessionContainer {
    private final ConcurrentHashMap<Long, ConcurrentHashMap<String, Long>> collectionResourceIdToSessionTokens;
    private final ConcurrentHashMap<String, Long> collectionNameToCollectionResourceId;
    private final String hostName;

    public SessionContainer(String hostName) {
        this(hostName, new ConcurrentHashMap<String, Long>(), new ConcurrentHashMap<Long, ConcurrentHashMap<String, Long>>());
    }

    public SessionContainer(String hostName, ConcurrentHashMap<String, Long> nameToRidMap, ConcurrentHashMap<Long, ConcurrentHashMap<String, Long>> ridToTokensMap) {
        this.hostName = hostName;
        this.collectionResourceIdToSessionTokens = ridToTokensMap;
        this.collectionNameToCollectionResourceId = nameToRidMap;
    }

    public String getHostName() {
        return this.hostName;
    }

    private ConcurrentHashMap<String, Long> getPartitionKeyRangeIdToTokenMap(RxDocumentServiceRequest request) {
        return this.getPartitionKeyRangeIdToTokenMap(request.getIsNameBased(), request.getResourceId(), request.getResourceAddress());
    }

    private ConcurrentHashMap<String, Long> getPartitionKeyRangeIdToTokenMap(boolean isNameBased, String rId, String resourceAddress) {
        ConcurrentHashMap<String, Long> rangeIdToTokenMap = null;
        if (!isNameBased) {
            ResourceId resourceId;
            if (!StringUtils.isEmpty((CharSequence)rId) && (resourceId = ResourceId.parse(rId)).getDocumentCollection() != 0) {
                rangeIdToTokenMap = this.collectionResourceIdToSessionTokens.get(resourceId.getUniqueDocumentCollectionId());
            }
        } else {
            String collectionName = Utils.getCollectionName(resourceAddress);
            if (!StringUtils.isEmpty((CharSequence)collectionName) && this.collectionNameToCollectionResourceId.containsKey(collectionName)) {
                rangeIdToTokenMap = this.collectionResourceIdToSessionTokens.get(this.collectionNameToCollectionResourceId.get(collectionName));
            }
        }
        return rangeIdToTokenMap;
    }

    public String resolveGlobalSessionToken(RxDocumentServiceRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        return this.resolveGlobalSessionToken(request.getIsNameBased(), request.getResourceId(), request.getResourceAddress());
    }

    private String resolveGlobalSessionToken(boolean isNameBased, String rId, String resourceAddress) {
        ConcurrentHashMap<String, Long> rangeIdToTokenMap = this.getPartitionKeyRangeIdToTokenMap(isNameBased, rId, resourceAddress);
        if (rangeIdToTokenMap != null) {
            return this.getCombinedSessionToken(rangeIdToTokenMap);
        }
        return "";
    }

    public String resolveGlobalSessionToken(String collectionLink) {
        if (StringUtils.isEmpty((CharSequence)collectionLink)) {
            throw new IllegalArgumentException("collectionLink cannot be null");
        }
        PathInfo pathInfo = PathsHelper.parsePathSegments(collectionLink);
        if (pathInfo == null) {
            return "";
        }
        return this.resolveGlobalSessionToken(pathInfo.isNameBased, pathInfo.resourceIdOrFullName, pathInfo.resourcePath);
    }

    public void clearToken(RxDocumentServiceRequest request) {
        Long collectionResourceId = null;
        if (!request.getIsNameBased()) {
            ResourceId resourceId;
            if (!StringUtils.isEmpty((CharSequence)request.getResourceId()) && (resourceId = ResourceId.parse(request.getResourceId())).getDocumentCollection() != 0) {
                collectionResourceId = resourceId.getUniqueDocumentCollectionId();
            }
        } else {
            String collectionName = Utils.getCollectionName(request.getResourceAddress());
            if (!StringUtils.isEmpty((CharSequence)collectionName)) {
                collectionResourceId = this.collectionNameToCollectionResourceId.get(collectionName);
                this.collectionNameToCollectionResourceId.remove(collectionName);
            }
        }
        if (collectionResourceId != null) {
            this.collectionResourceIdToSessionTokens.remove(collectionResourceId);
        }
    }

    public void setSessionToken(RxDocumentServiceRequest request, RxDocumentServiceResponse response) {
        String sessionToken;
        if (response != null && !request.isReadingFromMaster() && !StringUtils.isEmpty((CharSequence)(sessionToken = response.getResponseHeaders().get("x-ms-session-token")))) {
            ResourceId resourceId;
            String ownerId;
            String ownerFullName = response.getResponseHeaders().get("x-ms-alt-content-path");
            if (StringUtils.isEmpty((CharSequence)ownerFullName)) {
                ownerFullName = request.getResourceAddress();
            }
            String collectionName = Utils.getCollectionName(ownerFullName);
            if (!request.getIsNameBased()) {
                ownerId = request.getResourceId();
            } else {
                ownerId = response.getResponseHeaders().get("x-ms-content-path");
                if (StringUtils.isEmpty((CharSequence)ownerId)) {
                    ownerId = request.getResourceId();
                }
            }
            if (!StringUtils.isEmpty((CharSequence)ownerId) && (resourceId = ResourceId.parse(ownerId)).getDocumentCollection() != 0 && !StringUtils.isEmpty((CharSequence)collectionName)) {
                Long uniqueDocumentCollectionId = resourceId.getUniqueDocumentCollectionId();
                this.setSessionToken(uniqueDocumentCollectionId, collectionName, sessionToken);
            }
        }
    }

    private void setSessionToken(long collectionRid, String collectionName, String sessionToken) {
        this.collectionResourceIdToSessionTokens.putIfAbsent(collectionRid, new ConcurrentHashMap());
        this.compareAndSetToken(sessionToken, this.collectionResourceIdToSessionTokens.get(collectionRid));
        this.collectionNameToCollectionResourceId.putIfAbsent(collectionName, collectionRid);
    }

    private String getCombinedSessionToken(ConcurrentHashMap<String, Long> tokens) {
        StringBuilder result = new StringBuilder();
        if (tokens != null) {
            Iterator<Map.Entry<String, Long>> iterator = tokens.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Long> entry = iterator.next();
                result = result.append(entry.getKey()).append(":").append(entry.getValue());
                if (!iterator.hasNext()) continue;
                result = result.append(",");
            }
        }
        return result.toString();
    }

    private void compareAndSetToken(String newToken, ConcurrentHashMap<String, Long> oldTokens) {
        String[] newTokenParts;
        if (StringUtils.isNotEmpty((CharSequence)newToken) && (newTokenParts = newToken.split(":")).length == 2) {
            Boolean success;
            String range = newTokenParts[0];
            Long newLSN = Long.parseLong(newTokenParts[1]);
            do {
                Long oldLSN;
                if ((success = Boolean.valueOf((oldLSN = oldTokens.putIfAbsent(range, newLSN)) == null || newLSN < oldLSN)).booleanValue()) continue;
                success = oldTokens.replace(range, oldLSN, newLSN);
            } while (!success.booleanValue());
        }
    }

    Long resolvePartitionLocalSessionToken(RxDocumentServiceRequest request, String partitionKeyRangeId) {
        return SessionTokenHelper.resolvePartitionLocalSessionToken(request, partitionKeyRangeId, this.getPartitionKeyRangeIdToTokenMap(request));
    }
}

